import _typeof from "@babel/runtime/helpers/esm/typeof";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { computed, ref, defineComponent } from 'vue';
import VcSlider from '../vc-slider/src/Slider';
import VcRange from '../vc-slider/src/Range';
import VcHandle from '../vc-slider/src/Handle';
import { stringType, booleanType, someType, objectType, withInstall, functionType } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import SliderTooltip from './SliderTooltip';
import classNames from '../_util/classNames';
import { useInjectFormItemContext } from '../form/FormItemContext';
// CSSINJS
import useStyle from './style';
import devWarning from '../vc-util/devWarning';
var defaultTipFormatter = function defaultTipFormatter(value) {
  return typeof value === 'number' ? value.toString() : '';
};
export var sliderProps = function sliderProps() {
  return {
    id: String,
    prefixCls: String,
    tooltipPrefixCls: String,
    range: someType([Boolean, Object]),
    reverse: booleanType(),
    min: Number,
    max: Number,
    step: someType([Object, Number]),
    marks: objectType(),
    dots: booleanType(),
    value: someType([Array, Number]),
    defaultValue: someType([Array, Number]),
    included: booleanType(),
    disabled: booleanType(),
    vertical: booleanType(),
    tipFormatter: someType([Function, Object], function () {
      return defaultTipFormatter;
    }),
    tooltipOpen: booleanType(),
    /** @deprecated `tooltipVisible` is deprecated. Please use `tooltipOpen` instead. */
    tooltipVisible: booleanType(),
    tooltipPlacement: stringType(),
    getTooltipPopupContainer: functionType(),
    autofocus: booleanType(),
    handleStyle: someType([Array, Object]),
    trackStyle: someType([Array, Object]),
    onChange: functionType(),
    onAfterChange: functionType(),
    onFocus: functionType(),
    onBlur: functionType(),
    'onUpdate:value': functionType()
  };
};
var Slider = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ASlider',
  inheritAttrs: false,
  props: sliderProps(),
  // emits: ['update:value', 'change', 'afterChange', 'blur'],
  slots: ['mark'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots,
      emit = _ref.emit,
      expose = _ref.expose;
    // Warning for deprecated usage
    if (process.env.NODE_ENV !== 'production') {
      [['tooltipVisible', 'tooltipOpen']].forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        devWarning(props.tooltipVisible === undefined, 'Slider', "`".concat(deprecatedName, "` is deprecated, please use `").concat(newName, "` instead."));
      });
    }
    var _useConfigInject = useConfigInject('slider', props),
      prefixCls = _useConfigInject.prefixCls,
      rootPrefixCls = _useConfigInject.rootPrefixCls,
      direction = _useConfigInject.direction,
      getPopupContainer = _useConfigInject.getPopupContainer,
      configProvider = _useConfigInject.configProvider;
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var formItemContext = useInjectFormItemContext();
    var sliderRef = ref();
    var visibles = ref({});
    var toggleTooltipOpen = function toggleTooltipOpen(index, visible) {
      visibles.value[index] = visible;
    };
    var tooltipPlacement = computed(function () {
      if (props.tooltipPlacement) {
        return props.tooltipPlacement;
      }
      if (!props.vertical) {
        return 'top';
      }
      return direction.value === 'rtl' ? 'left' : 'right';
    });
    var focus = function focus() {
      var _a;
      (_a = sliderRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = sliderRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var handleChange = function handleChange(val) {
      emit('update:value', val);
      emit('change', val);
      formItemContext.onFieldChange();
    };
    var handleBlur = function handleBlur(e) {
      emit('blur', e);
    };
    expose({
      focus: focus,
      blur: blur
    });
    var handleWithTooltip = function handleWithTooltip(_a) {
      var tooltipPrefixCls = _a.tooltipPrefixCls,
        _b = _a.info,
        value = _b.value,
        dragging = _b.dragging,
        index = _b.index,
        restProps = __rest(_b, ["value", "dragging", "index"]);
      var tipFormatter = props.tipFormatter,
        _props$tooltipOpen = props.tooltipOpen,
        tooltipOpen = _props$tooltipOpen === void 0 ? props.tooltipVisible : _props$tooltipOpen,
        getTooltipPopupContainer = props.getTooltipPopupContainer;
      var isTipFormatter = tipFormatter ? visibles.value[index] || dragging : false;
      var open = tooltipOpen || tooltipOpen === undefined && isTipFormatter;
      return _createVNode(SliderTooltip, {
        "prefixCls": tooltipPrefixCls,
        "title": tipFormatter ? tipFormatter(value) : '',
        "open": open,
        "placement": tooltipPlacement.value,
        "transitionName": "".concat(rootPrefixCls.value, "-zoom-down"),
        "key": index,
        "overlayClassName": "".concat(prefixCls.value, "-tooltip"),
        "getPopupContainer": getTooltipPopupContainer || (getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value)
      }, {
        default: function _default() {
          return [_createVNode(VcHandle, _objectSpread(_objectSpread({}, restProps), {}, {
            "value": value,
            "onMouseenter": function onMouseenter() {
              return toggleTooltipOpen(index, true);
            },
            "onMouseleave": function onMouseleave() {
              return toggleTooltipOpen(index, false);
            }
          }), null)];
        }
      });
    };
    return function () {
      var customizeTooltipPrefixCls = props.tooltipPrefixCls,
        range = props.range,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id,
        restProps = __rest(props, ["tooltipPrefixCls", "range", "id"]);
      var tooltipPrefixCls = configProvider.getPrefixCls('tooltip', customizeTooltipPrefixCls);
      var cls = classNames(attrs.class, _defineProperty({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), hashId.value);
      // make reverse default on rtl direction
      if (direction.value === 'rtl' && !restProps.vertical) {
        restProps.reverse = !restProps.reverse;
      }
      // extrack draggableTrack from range={{ ... }}
      var draggableTrack;
      if (_typeof(range) === 'object') {
        draggableTrack = range.draggableTrack;
      }
      if (range) {
        return wrapSSR(_createVNode(VcRange, _objectSpread(_objectSpread(_objectSpread({}, attrs), restProps), {}, {
          "step": restProps.step,
          "draggableTrack": draggableTrack,
          "class": cls,
          "ref": sliderRef,
          "handle": function handle(info) {
            return handleWithTooltip({
              tooltipPrefixCls: tooltipPrefixCls,
              prefixCls: prefixCls.value,
              info: info
            });
          },
          "prefixCls": prefixCls.value,
          "onChange": handleChange,
          "onBlur": handleBlur
        }), {
          mark: slots.mark
        }));
      }
      return wrapSSR(_createVNode(VcSlider, _objectSpread(_objectSpread(_objectSpread({}, attrs), restProps), {}, {
        "id": id,
        "step": restProps.step,
        "class": cls,
        "ref": sliderRef,
        "handle": function handle(info) {
          return handleWithTooltip({
            tooltipPrefixCls: tooltipPrefixCls,
            prefixCls: prefixCls.value,
            info: info
          });
        },
        "prefixCls": prefixCls.value,
        "onChange": handleChange,
        "onBlur": handleBlur
      }), {
        mark: slots.mark
      }));
    };
  }
});
export default withInstall(Slider);