import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { Fragment as _Fragment, createVNode as _createVNode } from "vue";
import { defineComponent, computed, ref, watch, Fragment } from 'vue';
import PropTypes from '../_util/vue-types';
import { filterEmpty } from '../_util/props-util';
import { booleanType, tuple } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useFlexGapSupport from '../_util/hooks/useFlexGapSupport';
import classNames from '../_util/classNames';
import Compact from './Compact';
import useStyle from './style';
var spaceSize = {
  small: 8,
  middle: 16,
  large: 24
};
export var spaceProps = function spaceProps() {
  return {
    prefixCls: String,
    size: {
      type: [String, Number, Array]
    },
    direction: PropTypes.oneOf(tuple('horizontal', 'vertical')).def('horizontal'),
    align: PropTypes.oneOf(tuple('start', 'end', 'center', 'baseline')),
    wrap: booleanType()
  };
};
function getNumberSize(size) {
  return typeof size === 'string' ? spaceSize[size] : size || 0;
}
var Space = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ASpace',
  inheritAttrs: false,
  props: spaceProps(),
  slots: ['split'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('space', props),
      prefixCls = _useConfigInject.prefixCls,
      space = _useConfigInject.space,
      directionConfig = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var supportFlexGap = useFlexGapSupport();
    var size = computed(function () {
      var _a, _b, _c;
      return (_c = (_a = props.size) !== null && _a !== void 0 ? _a : (_b = space === null || space === void 0 ? void 0 : space.value) === null || _b === void 0 ? void 0 : _b.size) !== null && _c !== void 0 ? _c : 'small';
    });
    var horizontalSize = ref();
    var verticalSize = ref();
    watch(size, function () {
      var _map = (Array.isArray(size.value) ? size.value : [size.value, size.value]).map(function (item) {
        return getNumberSize(item);
      });
      var _map2 = _slicedToArray(_map, 2);
      horizontalSize.value = _map2[0];
      verticalSize.value = _map2[1];
    }, {
      immediate: true
    });
    var mergedAlign = computed(function () {
      return props.align === undefined && props.direction === 'horizontal' ? 'center' : props.align;
    });
    var cn = computed(function () {
      var _classNames;
      return classNames(prefixCls.value, hashId.value, "".concat(prefixCls.value, "-").concat(props.direction), (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), directionConfig.value === 'rtl'), _defineProperty(_classNames, "".concat(prefixCls.value, "-align-").concat(mergedAlign.value), mergedAlign.value), _classNames));
    });
    var marginDirection = computed(function () {
      return directionConfig.value === 'rtl' ? 'marginLeft' : 'marginRight';
    });
    var style = computed(function () {
      var gapStyle = {};
      if (supportFlexGap.value) {
        gapStyle.columnGap = "".concat(horizontalSize.value, "px");
        gapStyle.rowGap = "".concat(verticalSize.value, "px");
      }
      return _extends(_extends({}, gapStyle), props.wrap && {
        flexWrap: 'wrap',
        marginBottom: "".concat(-verticalSize.value, "px")
      });
    });
    return function () {
      var _a, _b;
      var wrap = props.wrap,
        _props$direction = props.direction,
        direction = _props$direction === void 0 ? 'horizontal' : _props$direction;
      var children = (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
      var items = filterEmpty(children);
      var len = items.length;
      if (len === 0) {
        return null;
      }
      var split = (_b = slots.split) === null || _b === void 0 ? void 0 : _b.call(slots);
      var itemClassName = "".concat(prefixCls.value, "-item");
      var horizontalSizeVal = horizontalSize.value;
      var latestIndex = len - 1;
      return _createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": cn.value,
        "style": [style.value, attrs.style]
      }), [items.map(function (child, index) {
        var originIndex = children.indexOf(child);
        var itemStyle = {};
        if (!supportFlexGap.value) {
          if (direction === 'vertical') {
            if (index < latestIndex) {
              itemStyle = {
                marginBottom: "".concat(horizontalSizeVal / (split ? 2 : 1), "px")
              };
            }
          } else {
            itemStyle = _extends(_extends({}, index < latestIndex && _defineProperty({}, marginDirection.value, "".concat(horizontalSizeVal / (split ? 2 : 1), "px"))), wrap && {
              paddingBottom: "".concat(verticalSize.value, "px")
            });
          }
        }
        return wrapSSR(_createVNode(_Fragment, {
          "key": originIndex
        }, [_createVNode("div", {
          "class": itemClassName,
          "style": itemStyle
        }, [child]), index < latestIndex && split && _createVNode("span", {
          "class": "".concat(itemClassName, "-split"),
          "style": itemStyle
        }, [split])]));
      })]);
    };
  }
});
Space.Compact = Compact;
Space.install = function (app) {
  app.component(Space.name, Space);
  app.component(Compact.name, Compact);
  return app;
};
export { Compact };
export default Space;