import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { onBeforeUnmount, cloneVNode, isVNode, defineComponent, shallowRef, watch } from 'vue';
import { debounce } from 'throttle-debounce';
import PropTypes from '../_util/vue-types';
import { filterEmpty, getPropsSlot } from '../_util/props-util';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import useStyle from './style';
import useConfigInject from '../config-provider/hooks/useConfigInject';
export var spinProps = function spinProps() {
  return {
    prefixCls: String,
    spinning: {
      type: Boolean,
      default: undefined
    },
    size: String,
    wrapperClassName: String,
    tip: PropTypes.any,
    delay: Number,
    indicator: PropTypes.any
  };
};
// Render indicator
var defaultIndicator = null;
function shouldDelay(spinning, delay) {
  return !!spinning && !!delay && !isNaN(Number(delay));
}
export function setDefaultIndicator(Content) {
  var Indicator = Content.indicator;
  defaultIndicator = typeof Indicator === 'function' ? Indicator : function () {
    return _createVNode(Indicator, null, null);
  };
}
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ASpin',
  inheritAttrs: false,
  props: initDefaultProps(spinProps(), {
    size: 'default',
    spinning: true,
    wrapperClassName: ''
  }),
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var _useConfigInject = useConfigInject('spin', props),
      prefixCls = _useConfigInject.prefixCls,
      size = _useConfigInject.size,
      direction = _useConfigInject.direction;
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var sSpinning = shallowRef(props.spinning && !shouldDelay(props.spinning, props.delay));
    var updateSpinning;
    watch([function () {
      return props.spinning;
    }, function () {
      return props.delay;
    }], function () {
      updateSpinning === null || updateSpinning === void 0 ? void 0 : updateSpinning.cancel();
      updateSpinning = debounce(props.delay, function () {
        sSpinning.value = props.spinning;
      });
      updateSpinning === null || updateSpinning === void 0 ? void 0 : updateSpinning();
    }, {
      immediate: true,
      flush: 'post'
    });
    onBeforeUnmount(function () {
      updateSpinning === null || updateSpinning === void 0 ? void 0 : updateSpinning.cancel();
    });
    return function () {
      var _spinClassName;
      var _a, _b;
      var cls = attrs.class,
        divProps = __rest(attrs, ["class"]);
      var _props$tip = props.tip,
        tip = _props$tip === void 0 ? (_a = slots.tip) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$tip;
      var children = (_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots);
      var spinClassName = (_spinClassName = {}, _defineProperty(_spinClassName, hashId.value, true), _defineProperty(_spinClassName, prefixCls.value, true), _defineProperty(_spinClassName, "".concat(prefixCls.value, "-sm"), size.value === 'small'), _defineProperty(_spinClassName, "".concat(prefixCls.value, "-lg"), size.value === 'large'), _defineProperty(_spinClassName, "".concat(prefixCls.value, "-spinning"), sSpinning.value), _defineProperty(_spinClassName, "".concat(prefixCls.value, "-show-text"), !!tip), _defineProperty(_spinClassName, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _defineProperty(_spinClassName, cls, !!cls), _spinClassName);
      function renderIndicator(prefixCls) {
        var dotClassName = "".concat(prefixCls, "-dot");
        var indicator = getPropsSlot(slots, props, 'indicator');
        // should not be render default indicator when indicator value is null
        if (indicator === null) {
          return null;
        }
        if (Array.isArray(indicator)) {
          indicator = indicator.length === 1 ? indicator[0] : indicator;
        }
        if (isVNode(indicator)) {
          return cloneVNode(indicator, {
            class: dotClassName
          });
        }
        if (defaultIndicator && isVNode(defaultIndicator())) {
          return cloneVNode(defaultIndicator(), {
            class: dotClassName
          });
        }
        return _createVNode("span", {
          "class": "".concat(dotClassName, " ").concat(prefixCls, "-dot-spin")
        }, [_createVNode("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null), _createVNode("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null), _createVNode("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null), _createVNode("i", {
          "class": "".concat(prefixCls, "-dot-item")
        }, null)]);
      }
      var spinElement = _createVNode("div", _objectSpread(_objectSpread({}, divProps), {}, {
        "class": spinClassName,
        "aria-live": "polite",
        "aria-busy": sSpinning.value
      }), [renderIndicator(prefixCls.value), tip ? _createVNode("div", {
        "class": "".concat(prefixCls.value, "-text")
      }, [tip]) : null]);
      if (children && filterEmpty(children).length) {
        var _containerClassName;
        var containerClassName = (_containerClassName = {}, _defineProperty(_containerClassName, "".concat(prefixCls.value, "-container"), true), _defineProperty(_containerClassName, "".concat(prefixCls.value, "-blur"), sSpinning.value), _containerClassName);
        return wrapSSR(_createVNode("div", {
          "class": ["".concat(prefixCls.value, "-nested-loading"), props.wrapperClassName, hashId.value]
        }, [sSpinning.value && _createVNode("div", {
          "key": "loading"
        }, [spinElement]), _createVNode("div", {
          "class": containerClassName,
          "key": "container"
        }, [children])]));
      }
      return wrapSSR(spinElement);
    };
  }
});