import _extends from "@babel/runtime/helpers/esm/extends";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
var genStepsInlineStyle = function genStepsInlineStyle(token) {
  var _icon, _extends3, _$concat;
  var componentCls = token.componentCls,
    inlineDotSize = token.inlineDotSize,
    inlineTitleColor = token.inlineTitleColor,
    inlineTailColor = token.inlineTailColor;
  var containerPaddingTop = token.paddingXS + token.lineWidth;
  var titleStyle = _defineProperty({}, "".concat(componentCls, "-item-container ").concat(componentCls, "-item-content ").concat(componentCls, "-item-title"), {
    color: inlineTitleColor
  });
  return _defineProperty({}, "&".concat(componentCls, "-inline"), _defineProperty({
    width: 'auto',
    display: 'inline-flex'
  }, "".concat(componentCls, "-item"), (_$concat = {
    flex: 'none',
    '&-container': _defineProperty({
      padding: "".concat(containerPaddingTop, "px ").concat(token.paddingXXS, "px 0"),
      margin: "0 ".concat(token.marginXXS / 2, "px"),
      borderRadius: token.borderRadiusSM,
      cursor: 'pointer',
      transition: "background-color ".concat(token.motionDurationMid),
      '&:hover': {
        background: token.controlItemBgHover
      }
    }, "&[role='button']:hover", {
      opacity: 1
    }),
    '&-icon': (_icon = {
      width: inlineDotSize,
      height: inlineDotSize,
      marginInlineStart: "calc(50% - ".concat(inlineDotSize / 2, "px)")
    }, _defineProperty(_icon, "> ".concat(componentCls, "-icon"), {
      top: 0
    }), _defineProperty(_icon, "".concat(componentCls, "-icon-dot"), {
      borderRadius: token.fontSizeSM / 4
    }), _icon),
    '&-content': {
      width: 'auto',
      marginTop: token.marginXS - token.lineWidth
    },
    '&-title': {
      color: inlineTitleColor,
      fontSize: token.fontSizeSM,
      lineHeight: token.lineHeightSM,
      fontWeight: 'normal',
      marginBottom: token.marginXXS / 2
    },
    '&-description': {
      display: 'none'
    },
    '&-tail': {
      marginInlineStart: 0,
      top: containerPaddingTop + inlineDotSize / 2,
      transform: "translateY(-50%)",
      '&:after': {
        width: '100%',
        height: token.lineWidth,
        borderRadius: 0,
        marginInlineStart: 0,
        background: inlineTailColor
      }
    }
  }, _defineProperty(_$concat, "&:first-child ".concat(componentCls, "-item-tail"), {
    width: '50%',
    marginInlineStart: '50%'
  }), _defineProperty(_$concat, "&:last-child ".concat(componentCls, "-item-tail"), {
    display: 'block',
    width: '50%'
  }), _defineProperty(_$concat, '&-wait', _extends(_defineProperty({}, "".concat(componentCls, "-item-icon ").concat(componentCls, "-icon ").concat(componentCls, "-icon-dot"), {
    backgroundColor: token.colorBorderBg,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(inlineTailColor)
  }), titleStyle)), _defineProperty(_$concat, '&-finish', _extends((_extends3 = {}, _defineProperty(_extends3, "".concat(componentCls, "-item-tail::after"), {
    backgroundColor: inlineTailColor
  }), _defineProperty(_extends3, "".concat(componentCls, "-item-icon ").concat(componentCls, "-icon ").concat(componentCls, "-icon-dot"), {
    backgroundColor: inlineTailColor,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(inlineTailColor)
  }), _extends3), titleStyle)), _defineProperty(_$concat, '&-error', titleStyle), _defineProperty(_$concat, '&-active, &-process', _extends(_defineProperty({}, "".concat(componentCls, "-item-icon"), {
    width: inlineDotSize,
    height: inlineDotSize,
    marginInlineStart: "calc(50% - ".concat(inlineDotSize / 2, "px)"),
    top: 0
  }), titleStyle)), _defineProperty(_$concat, "&:not(".concat(componentCls, "-item-active) > ").concat(componentCls, "-item-container[role='button']:hover"), _defineProperty({}, "".concat(componentCls, "-item-title"), {
    color: inlineTitleColor
  })), _$concat)));
};
export default genStepsInlineStyle;