import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import useState from '../../_util/hooks/useState';
import { computed } from 'vue';
import extendsObject from '../../_util/extendsObject';
export var DEFAULT_PAGE_SIZE = 10;
export function getPaginationParam(mergedPagination, pagination) {
  var param = {
    current: mergedPagination.current,
    pageSize: mergedPagination.pageSize
  };
  var paginationObj = pagination && _typeof(pagination) === 'object' ? pagination : {};
  Object.keys(paginationObj).forEach(function (pageProp) {
    var value = mergedPagination[pageProp];
    if (typeof value !== 'function') {
      param[pageProp] = value;
    }
  });
  return param;
}
export default function usePagination(totalRef, paginationRef, onChange) {
  var pagination = computed(function () {
    return paginationRef.value && _typeof(paginationRef.value) === 'object' ? paginationRef.value : {};
  });
  var paginationTotal = computed(function () {
    return pagination.value.total || 0;
  });
  var _useState = useState(function () {
      return {
        current: 'defaultCurrent' in pagination.value ? pagination.value.defaultCurrent : 1,
        pageSize: 'defaultPageSize' in pagination.value ? pagination.value.defaultPageSize : DEFAULT_PAGE_SIZE
      };
    }),
    _useState2 = _slicedToArray(_useState, 2),
    innerPagination = _useState2[0],
    setInnerPagination = _useState2[1];
  // ============ Basic Pagination Config ============
  var mergedPagination = computed(function () {
    var mP = extendsObject(innerPagination.value, pagination.value, {
      total: paginationTotal.value > 0 ? paginationTotal.value : totalRef.value
    });
    // Reset `current` if data length or pageSize changed
    var maxPage = Math.ceil((paginationTotal.value || totalRef.value) / mP.pageSize);
    if (mP.current > maxPage) {
      // Prevent a maximum page count of 0
      mP.current = maxPage || 1;
    }
    return mP;
  });
  var refreshPagination = function refreshPagination(current, pageSize) {
    if (paginationRef.value === false) return;
    setInnerPagination({
      current: current !== null && current !== void 0 ? current : 1,
      pageSize: pageSize || mergedPagination.value.pageSize
    });
  };
  var onInternalChange = function onInternalChange(current, pageSize) {
    var _a, _b;
    if (paginationRef.value) {
      (_b = (_a = pagination.value).onChange) === null || _b === void 0 ? void 0 : _b.call(_a, current, pageSize);
    }
    refreshPagination(current, pageSize);
    onChange(current, pageSize || mergedPagination.value.pageSize);
  };
  return [computed(function () {
    return paginationRef.value === false ? {} : _extends(_extends({}, mergedPagination.value), {
      onChange: onInternalChange
    });
  }), refreshPagination];
}