import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { TinyColor } from '@ctrl/tinycolor';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import genBorderedStyle from './bordered';
import genEllipsisStyle from './ellipsis';
import genEmptyStyle from './empty';
import genExpandStyle from './expand';
import genFilterStyle from './filter';
import genFixedStyle from './fixed';
import genPaginationStyle from './pagination';
import genRadiusStyle from './radius';
import genRtlStyle from './rtl';
import genSelectionStyle from './selection';
import genSizeStyle from './size';
import genResizeStyle from './resize';
import genSorterStyle from './sorter';
import genStickyStyle from './sticky';
import genSummaryStyle from './summary';
import { clearFix, resetComponent } from '../../style';
var genTableStyle = function genTableStyle(token) {
  var _$concat, _tr2, _ref, _extends2;
  var componentCls = token.componentCls,
    fontWeightStrong = token.fontWeightStrong,
    tablePaddingVertical = token.tablePaddingVertical,
    tablePaddingHorizontal = token.tablePaddingHorizontal,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    tableBorderColor = token.tableBorderColor,
    tableFontSize = token.tableFontSize,
    tableBg = token.tableBg,
    tableRadius = token.tableRadius,
    tableHeaderTextColor = token.tableHeaderTextColor,
    motionDurationMid = token.motionDurationMid,
    tableHeaderBg = token.tableHeaderBg,
    tableHeaderCellSplitColor = token.tableHeaderCellSplitColor,
    tableRowHoverBg = token.tableRowHoverBg,
    tableSelectedRowBg = token.tableSelectedRowBg,
    tableSelectedRowHoverBg = token.tableSelectedRowHoverBg,
    tableFooterTextColor = token.tableFooterTextColor,
    tableFooterBg = token.tableFooterBg,
    paddingContentVerticalLG = token.paddingContentVerticalLG,
    wireframe = token.wireframe;
  var tableBorder = "".concat(lineWidth, "px ").concat(lineType, " ").concat(tableBorderColor);
  return _defineProperty({}, "".concat(componentCls, "-wrapper"), _extends(_extends({
    clear: 'both',
    maxWidth: '100%'
  }, clearFix()), (_extends2 = {}, _defineProperty(_extends2, componentCls, _extends(_extends({}, resetComponent(token)), {
    fontSize: tableFontSize,
    background: tableBg,
    borderRadius: "".concat(tableRadius, "px ").concat(tableRadius, "px 0 0")
  })), _defineProperty(_extends2, "table", {
    width: '100%',
    textAlign: 'start',
    borderRadius: "".concat(tableRadius, "px ").concat(tableRadius, "px 0 0"),
    borderCollapse: 'separate',
    borderSpacing: 0
  }), _defineProperty(_extends2, "\n          ".concat(componentCls, "-thead > tr > th,\n          ").concat(componentCls, "-tbody > tr > td,\n          tfoot > tr > th,\n          tfoot > tr > td\n        "), {
    position: 'relative',
    padding: "".concat(paddingContentVerticalLG, "px ").concat(tablePaddingHorizontal, "px"),
    overflowWrap: 'break-word'
  }), _defineProperty(_extends2, "".concat(componentCls, "-title"), {
    padding: "".concat(tablePaddingVertical, "px ").concat(tablePaddingHorizontal, "px")
  }), _defineProperty(_extends2, "".concat(componentCls, "-thead"), (_$concat = {}, _defineProperty(_$concat, "\n          > tr > th,\n          > tr > td\n        ", _defineProperty({
    position: 'relative',
    color: tableHeaderTextColor,
    fontWeight: fontWeightStrong,
    textAlign: 'start',
    background: tableHeaderBg,
    borderBottom: tableBorder,
    transition: "background ".concat(motionDurationMid, " ease"),
    "&[colspan]:not([colspan='1'])": {
      textAlign: 'center'
    }
  }, "&:not(:last-child):not(".concat(componentCls, "-selection-column):not(").concat(componentCls, "-row-expand-icon-cell):not([colspan])::before"), {
    position: 'absolute',
    top: '50%',
    insetInlineEnd: 0,
    width: 1,
    height: '1.6em',
    backgroundColor: tableHeaderCellSplitColor,
    transform: 'translateY(-50%)',
    transition: "background-color ".concat(motionDurationMid),
    content: '""'
  })), _defineProperty(_$concat, '> tr:not(:last-child) > th[colspan]', {
    borderBottom: 0
  }), _$concat)), _defineProperty(_extends2, "".concat(componentCls, ":not(").concat(componentCls, "-bordered)"), _defineProperty({}, "".concat(componentCls, "-tbody"), {
    '> tr': _defineProperty({
      '> td': {
        borderTop: tableBorder,
        borderBottom: 'transparent'
      },
      '&:last-child > td': {
        borderBottom: tableBorder
      }
    }, "&:first-child > td,\n              &".concat(componentCls, "-measure-row + tr > td"), {
      borderTop: 'none',
      borderTopColor: 'transparent'
    })
  })), _defineProperty(_extends2, "".concat(componentCls).concat(componentCls, "-bordered"), _defineProperty({}, "".concat(componentCls, "-tbody"), {
    '> tr': {
      '> td': {
        borderBottom: tableBorder
      }
    }
  })), _defineProperty(_extends2, "".concat(componentCls, "-tbody"), {
    '> tr': (_tr2 = {
      '> td': _defineProperty({
        transition: "background ".concat(motionDurationMid, ", border-color ").concat(motionDurationMid)
      }, "\n              > ".concat(componentCls, "-wrapper:only-child,\n              > ").concat(componentCls, "-expanded-row-fixed > ").concat(componentCls, "-wrapper:only-child\n            "), _defineProperty({}, componentCls, _defineProperty({
        marginBlock: "-".concat(tablePaddingVertical, "px"),
        marginInline: "".concat(token.tableExpandColumnWidth - tablePaddingHorizontal, "px -").concat(tablePaddingHorizontal, "px")
      }, "".concat(componentCls, "-tbody > tr:last-child > td"), {
        borderBottom: 0,
        '&:first-child, &:last-child': {
          borderRadius: 0
        }
      })))
    }, _defineProperty(_tr2, "\n            &".concat(componentCls, "-row:hover > td,\n            > td").concat(componentCls, "-cell-row-hover\n          "), {
      background: tableRowHoverBg
    }), _defineProperty(_tr2, "&".concat(componentCls, "-row-selected"), {
      '> td': {
        background: tableSelectedRowBg
      },
      '&:hover > td': {
        background: tableSelectedRowHoverBg
      }
    }), _tr2)
  }), _defineProperty(_extends2, "".concat(componentCls, ":not(").concat(componentCls, "-bordered) ").concat(componentCls, "-tbody > tr"), wireframe ? undefined : (_ref = {}, _defineProperty(_ref, "&".concat(componentCls, "-row:hover, &").concat(componentCls, "-row").concat(componentCls, "-row-selected"), _defineProperty({}, "+ tr".concat(componentCls, "-row > td"), {
    borderTopColor: 'transparent'
  })), _defineProperty(_ref, "&".concat(componentCls, "-row:last-child:hover > td,\n          &").concat(componentCls, "-row").concat(componentCls, "-row-selected:last-child > td"), {
    borderBottomColor: 'transparent'
  }), _defineProperty(_ref, "\n          &".concat(componentCls, "-row:hover > td,\n          > td").concat(componentCls, "-cell-row-hover,\n          &").concat(componentCls, "-row").concat(componentCls, "-row-selected > td\n        "), {
    borderTopColor: 'transparent',
    '&:first-child': {
      borderStartStartRadius: tableRadius,
      borderEndStartRadius: tableRadius
    },
    '&:last-child': {
      borderStartEndRadius: tableRadius,
      borderEndEndRadius: tableRadius
    }
  }), _ref)), _defineProperty(_extends2, "".concat(componentCls, "-footer"), {
    padding: "".concat(tablePaddingVertical, "px ").concat(tablePaddingHorizontal, "px"),
    color: tableFooterTextColor,
    background: tableFooterBg
  }), _extends2)));
};
// ============================== Export ==============================
export default genComponentStyleHook('Table', function (token) {
  var controlItemBgActive = token.controlItemBgActive,
    controlItemBgActiveHover = token.controlItemBgActiveHover,
    colorTextPlaceholder = token.colorTextPlaceholder,
    colorTextHeading = token.colorTextHeading,
    colorSplit = token.colorSplit,
    colorBorderSecondary = token.colorBorderSecondary,
    fontSize = token.fontSize,
    padding = token.padding,
    paddingXS = token.paddingXS,
    paddingSM = token.paddingSM,
    controlHeight = token.controlHeight,
    colorFillAlter = token.colorFillAlter,
    colorIcon = token.colorIcon,
    colorIconHover = token.colorIconHover,
    opacityLoading = token.opacityLoading,
    colorBgContainer = token.colorBgContainer,
    borderRadiusLG = token.borderRadiusLG,
    colorFillContent = token.colorFillContent,
    colorFillSecondary = token.colorFillSecondary,
    checkboxSize = token.controlInteractiveSize;
  var baseColorAction = new TinyColor(colorIcon);
  var baseColorActionHover = new TinyColor(colorIconHover);
  var tableSelectedRowBg = controlItemBgActive;
  var zIndexTableFixed = 2;
  var colorFillSecondarySolid = new TinyColor(colorFillSecondary).onBackground(colorBgContainer).toHexString();
  var colorFillContentSolid = new TinyColor(colorFillContent).onBackground(colorBgContainer).toHexString();
  var colorFillAlterSolid = new TinyColor(colorFillAlter).onBackground(colorBgContainer).toHexString();
  var tableToken = mergeToken(token, {
    tableFontSize: fontSize,
    tableBg: colorBgContainer,
    tableRadius: borderRadiusLG,
    tablePaddingVertical: padding,
    tablePaddingHorizontal: padding,
    tablePaddingVerticalMiddle: paddingSM,
    tablePaddingHorizontalMiddle: paddingXS,
    tablePaddingVerticalSmall: paddingXS,
    tablePaddingHorizontalSmall: paddingXS,
    tableBorderColor: colorBorderSecondary,
    tableHeaderTextColor: colorTextHeading,
    tableHeaderBg: colorFillAlterSolid,
    tableFooterTextColor: colorTextHeading,
    tableFooterBg: colorFillAlterSolid,
    tableHeaderCellSplitColor: colorBorderSecondary,
    tableHeaderSortBg: colorFillSecondarySolid,
    tableHeaderSortHoverBg: colorFillContentSolid,
    tableHeaderIconColor: baseColorAction.clone().setAlpha(baseColorAction.getAlpha() * opacityLoading).toRgbString(),
    tableHeaderIconColorHover: baseColorActionHover.clone().setAlpha(baseColorActionHover.getAlpha() * opacityLoading).toRgbString(),
    tableBodySortBg: colorFillAlterSolid,
    tableFixedHeaderSortActiveBg: colorFillSecondarySolid,
    tableHeaderFilterActiveBg: colorFillContent,
    tableFilterDropdownBg: colorBgContainer,
    tableRowHoverBg: colorFillAlterSolid,
    tableSelectedRowBg: tableSelectedRowBg,
    tableSelectedRowHoverBg: controlItemBgActiveHover,
    zIndexTableFixed: zIndexTableFixed,
    zIndexTableSticky: zIndexTableFixed + 1,
    tableFontSizeMiddle: fontSize,
    tableFontSizeSmall: fontSize,
    tableSelectionColumnWidth: controlHeight,
    tableExpandIconBg: colorBgContainer,
    tableExpandColumnWidth: checkboxSize + 2 * token.padding,
    tableExpandedRowBg: colorFillAlter,
    // Dropdown
    tableFilterDropdownWidth: 120,
    tableFilterDropdownHeight: 264,
    tableFilterDropdownSearchWidth: 140,
    // Virtual Scroll Bar
    tableScrollThumbSize: 8,
    tableScrollThumbBg: colorTextPlaceholder,
    tableScrollThumbBgHover: colorTextHeading,
    tableScrollBg: colorSplit
  });
  return [genTableStyle(tableToken), genPaginationStyle(tableToken), genSummaryStyle(tableToken), genSorterStyle(tableToken), genFilterStyle(tableToken), genBorderedStyle(tableToken), genRadiusStyle(tableToken), genExpandStyle(tableToken), genSummaryStyle(tableToken), genEmptyStyle(tableToken), genSelectionStyle(tableToken), genFixedStyle(tableToken), genStickyStyle(tableToken), genEllipsisStyle(tableToken), genSizeStyle(tableToken), genResizeStyle(tableToken), genRtlStyle(tableToken)];
});