import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { defineComponent, computed } from 'vue';
import classNames from '../_util/classNames';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import useStyle from './style';
var checkableTagProps = function checkableTagProps() {
  return {
    prefixCls: String,
    checked: {
      type: Boolean,
      default: undefined
    },
    onChange: {
      type: Function
    },
    onClick: {
      type: Function
    },
    'onUpdate:checked': Function
  };
};
var CheckableTag = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ACheckableTag',
  inheritAttrs: false,
  props: checkableTagProps(),
  // emits: ['update:checked', 'change', 'click'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('tag', props),
      prefixCls = _useConfigInject.prefixCls;
    // Style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var handleClick = function handleClick(e) {
      var checked = props.checked;
      emit('update:checked', !checked);
      emit('change', !checked);
      emit('click', e);
    };
    var cls = computed(function () {
      var _classNames;
      return classNames(prefixCls.value, hashId.value, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-checkable"), true), _defineProperty(_classNames, "".concat(prefixCls.value, "-checkable-checked"), props.checked), _classNames));
    });
    return function () {
      var _a;
      return wrapSSR(_createVNode("span", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": cls.value,
        "onClick": handleClick
      }), [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]));
    };
  }
});
export default CheckableTag;