import _extends from "@babel/runtime/helpers/esm/extends";
import { createTheme, useCacheToken, useStyleRegister } from '../_util/cssinjs';
import version from '../version';
import { PresetColors } from './interface';
import defaultDerivative from './themes/default';
import defaultSeedToken from './themes/seed';
import formatToken from './util/alias';
import genComponentStyleHook from './util/genComponentStyleHook';
import statisticToken, { merge as mergeToken, statistic } from './util/statistic';
import { objectType } from '../_util/type';
import { defineComponent, provide, computed, inject, watchEffect, ref } from 'vue';
import { toReactive } from '../_util/toReactive';
var defaultTheme = createTheme(defaultDerivative);
export {
// colors
PresetColors,
// Statistic
statistic, statisticToken, mergeToken,
// hooks
useStyleRegister, genComponentStyleHook };
// ================================ Context =================================
// To ensure snapshot stable. We disable hashed in test env.
export var defaultConfig = {
  token: defaultSeedToken,
  hashed: true
};
//defaultConfig
var DesignTokenContextKey = Symbol('DesignTokenContext');
export var globalDesignTokenApi = ref();
export var useDesignTokenProvider = function useDesignTokenProvider(value) {
  provide(DesignTokenContextKey, value);
  watchEffect(function () {
    globalDesignTokenApi.value = value;
  });
};
export var useDesignTokenInject = function useDesignTokenInject() {
  return inject(DesignTokenContextKey, globalDesignTokenApi.value || defaultConfig);
};
export var DesignTokenProvider = defineComponent({
  props: {
    value: objectType()
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    useDesignTokenProvider(toReactive(computed(function () {
      return props.value;
    })));
    return function () {
      var _a;
      return (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots);
    };
  }
});
// ================================== Hook ==================================
export function useToken() {
  var designTokenContext = inject(DesignTokenContextKey, globalDesignTokenApi.value || defaultConfig);
  var salt = computed(function () {
    return "".concat(version, "-").concat(designTokenContext.hashed || '');
  });
  var mergedTheme = computed(function () {
    return designTokenContext.theme || defaultTheme;
  });
  var cacheToken = useCacheToken(mergedTheme, computed(function () {
    return [defaultSeedToken, designTokenContext.token];
  }), computed(function () {
    return {
      salt: salt.value,
      override: _extends({
        override: designTokenContext.token
      }, designTokenContext.components),
      formatToken: formatToken
    };
  }));
  return [mergedTheme, computed(function () {
    return cacheToken.value[0];
  }), computed(function () {
    return designTokenContext.hashed ? cacheToken.value[1] : '';
  })];
}