import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
/* eslint-disable no-redeclare */
import { useStyleRegister } from '../../_util/cssinjs';
import { genCommonStyle, genLinkStyle } from '../../style';
import { mergeToken, statisticToken, useToken } from '../internal';
import { computed } from 'vue';
import { useConfigContextInject } from '../../config-provider/context';
export default function genComponentStyleHook(component, styleFn, getDefaultToken) {
  return function (_prefixCls) {
    var prefixCls = computed(function () {
      return _prefixCls === null || _prefixCls === void 0 ? void 0 : _prefixCls.value;
    });
    var _useToken = useToken(),
      _useToken2 = _slicedToArray(_useToken, 3),
      theme = _useToken2[0],
      token = _useToken2[1],
      hashId = _useToken2[2];
    var _useConfigContextInje = useConfigContextInject(),
      getPrefixCls = _useConfigContextInje.getPrefixCls,
      iconPrefixCls = _useConfigContextInje.iconPrefixCls;
    var rootPrefixCls = computed(function () {
      return getPrefixCls();
    });
    var sharedInfo = computed(function () {
      return {
        theme: theme.value,
        token: token.value,
        hashId: hashId.value,
        path: ['Shared', rootPrefixCls.value]
      };
    });
    // Generate style for all a tags in antd component.
    useStyleRegister(sharedInfo, function () {
      return [{
        // Link
        '&': genLinkStyle(token.value)
      }];
    });
    var componentInfo = computed(function () {
      return {
        theme: theme.value,
        token: token.value,
        hashId: hashId.value,
        path: [component, prefixCls.value, iconPrefixCls.value]
      };
    });
    return [useStyleRegister(componentInfo, function () {
      var _statisticToken = statisticToken(token.value),
        proxyToken = _statisticToken.token,
        flush = _statisticToken.flush;
      var defaultComponentToken = typeof getDefaultToken === 'function' ? getDefaultToken(proxyToken) : getDefaultToken;
      var mergedComponentToken = _extends(_extends({}, defaultComponentToken), token.value[component]);
      var componentCls = ".".concat(prefixCls.value);
      var mergedToken = mergeToken(proxyToken, {
        componentCls: componentCls,
        prefixCls: prefixCls.value,
        iconCls: ".".concat(iconPrefixCls.value),
        antCls: ".".concat(rootPrefixCls.value)
      }, mergedComponentToken);
      var styleInterpolation = styleFn(mergedToken, {
        hashId: hashId.value,
        prefixCls: prefixCls.value,
        rootPrefixCls: rootPrefixCls.value,
        iconPrefixCls: iconPrefixCls.value,
        overrideComponentToken: token.value[component]
      });
      flush(component, mergedComponentToken);
      return [genCommonStyle(token.value, prefixCls.value), styleInterpolation];
    }), hashId];
  };
}