import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import { cloneVNode, defineComponent } from 'vue';
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import { filterEmpty } from '../_util/props-util';
import initDefaultProps from '../_util/props-util/initDefaultProps';
import TimelineItem from './TimelineItem';
import LoadingOutlined from "@ant-design/icons-vue/es/icons/LoadingOutlined";
import { tuple, booleanType } from '../_util/type';
import useConfigInject from '../config-provider/hooks/useConfigInject';
// CSSINJS
import useStyle from './style';
export var timelineProps = function timelineProps() {
  return {
    prefixCls: String,
    /** 指定最后一个幽灵节点是否存在或内容 */
    pending: PropTypes.any,
    pendingDot: PropTypes.any,
    reverse: booleanType(),
    mode: PropTypes.oneOf(tuple('left', 'alternate', 'right', ''))
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ATimeline',
  inheritAttrs: false,
  props: initDefaultProps(timelineProps(), {
    reverse: false,
    mode: ''
  }),
  slots: ['pending', 'pendingDot'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('timeline', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getPositionCls = function getPositionCls(ele, idx) {
      var eleProps = ele.props || {};
      if (props.mode === 'alternate') {
        if (eleProps.position === 'right') return "".concat(prefixCls.value, "-item-right");
        if (eleProps.position === 'left') return "".concat(prefixCls.value, "-item-left");
        return idx % 2 === 0 ? "".concat(prefixCls.value, "-item-left") : "".concat(prefixCls.value, "-item-right");
      }
      if (props.mode === 'left') return "".concat(prefixCls.value, "-item-left");
      if (props.mode === 'right') return "".concat(prefixCls.value, "-item-right");
      if (eleProps.position === 'right') return "".concat(prefixCls.value, "-item-right");
      return '';
    };
    return function () {
      var _classNames;
      var _a, _b, _c;
      var _props$pending = props.pending,
        pending = _props$pending === void 0 ? (_a = slots.pending) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$pending,
        _props$pendingDot = props.pendingDot,
        pendingDot = _props$pendingDot === void 0 ? (_b = slots.pendingDot) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$pendingDot,
        reverse = props.reverse,
        mode = props.mode;
      var pendingNode = typeof pending === 'boolean' ? null : pending;
      var children = filterEmpty((_c = slots.default) === null || _c === void 0 ? void 0 : _c.call(slots));
      var pendingItem = pending ? _createVNode(TimelineItem, {
        "pending": !!pending,
        "dot": pendingDot || _createVNode(LoadingOutlined, null, null)
      }, {
        default: function _default() {
          return [pendingNode];
        }
      }) : null;
      if (pendingItem) {
        children.push(pendingItem);
      }
      var timeLineItems = reverse ? children.reverse() : children;
      var itemsCount = timeLineItems.length;
      var lastCls = "".concat(prefixCls.value, "-item-last");
      var items = timeLineItems.map(function (ele, idx) {
        var pendingClass = idx === itemsCount - 2 ? lastCls : '';
        var readyClass = idx === itemsCount - 1 ? lastCls : '';
        return cloneVNode(ele, {
          class: classNames([!reverse && !!pending ? pendingClass : readyClass, getPositionCls(ele, idx)])
        });
      });
      var hasLabelItem = timeLineItems.some(function (item) {
        var _a, _b;
        return !!(((_a = item.props) === null || _a === void 0 ? void 0 : _a.label) || ((_b = item.children) === null || _b === void 0 ? void 0 : _b.label));
      });
      var classString = classNames(prefixCls.value, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value, "-pending"), !!pending), _defineProperty(_classNames, "".concat(prefixCls.value, "-reverse"), !!reverse), _defineProperty(_classNames, "".concat(prefixCls.value, "-").concat(mode), !!mode && !hasLabelItem), _defineProperty(_classNames, "".concat(prefixCls.value, "-label"), hasLabelItem), _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames), attrs.class, hashId.value);
      return wrapSSR(_createVNode("ul", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": classString
      }), [items]));
    };
  }
});