import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, createVNode as _createVNode } from "vue";
import { computed, watch, defineComponent, ref } from 'vue';
import VcTooltip from '../vc-tooltip';
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import warning from '../_util/warning';
import { getStyle, filterEmpty, isValidElement, initDefaultProps, isFragment } from '../_util/props-util';
import { cloneElement } from '../_util/vnode';
import abstractTooltipProps from './abstractTooltipProps';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import getPlacements from '../_util/placements';
import firstNotUndefined from '../_util/firstNotUndefined';
import raf from '../_util/raf';
import { parseColor } from './util';
import useStyle from './style';
import { getTransitionName } from '../_util/transition';
var splitObject = function splitObject(obj, keys) {
  var picked = {};
  var omitted = _extends({}, obj);
  keys.forEach(function (key) {
    if (obj && key in obj) {
      picked[key] = obj[key];
      delete omitted[key];
    }
  });
  return {
    picked: picked,
    omitted: omitted
  };
};
export var tooltipProps = function tooltipProps() {
  return _extends(_extends({}, abstractTooltipProps()), {
    title: PropTypes.any
  });
};
export var tooltipDefaultProps = function tooltipDefaultProps() {
  return {
    trigger: 'hover',
    align: {},
    placement: 'top',
    mouseEnterDelay: 0.1,
    mouseLeaveDelay: 0.1,
    arrowPointAtCenter: false,
    autoAdjustOverflow: true
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'ATooltip',
  inheritAttrs: false,
  props: initDefaultProps(tooltipProps(), {
    trigger: 'hover',
    align: {},
    placement: 'top',
    mouseEnterDelay: 0.1,
    mouseLeaveDelay: 0.1,
    arrowPointAtCenter: false,
    autoAdjustOverflow: true
  }),
  slots: ['title'],
  // emits: ['update:visible', 'visibleChange'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    if (process.env.NODE_ENV !== 'production') {
      [['visible', 'open'], ['onVisibleChange', 'onOpenChange']].forEach(function (_ref2) {
        var _ref3 = _slicedToArray(_ref2, 2),
          deprecatedName = _ref3[0],
          newName = _ref3[1];
        warning(props[deprecatedName] === undefined, 'Tooltip', "`".concat(deprecatedName, "` is deprecated, please use `").concat(newName, "` instead."));
      });
    }
    var _useConfigInject = useConfigInject('tooltip', props),
      prefixCls = _useConfigInject.prefixCls,
      getPopupContainer = _useConfigInject.getPopupContainer,
      direction = _useConfigInject.direction,
      rootPrefixCls = _useConfigInject.rootPrefixCls;
    var mergedOpen = computed(function () {
      var _a;
      return (_a = props.open) !== null && _a !== void 0 ? _a : props.visible;
    });
    var innerOpen = ref(firstNotUndefined([props.open, props.visible]));
    var tooltip = ref();
    var rafId;
    watch(mergedOpen, function (val) {
      raf.cancel(rafId);
      rafId = raf(function () {
        innerOpen.value = !!val;
      });
    });
    var isNoTitle = function isNoTitle() {
      var _a;
      var title = (_a = props.title) !== null && _a !== void 0 ? _a : slots.title;
      return !title && title !== 0;
    };
    var handleVisibleChange = function handleVisibleChange(val) {
      var noTitle = isNoTitle();
      if (mergedOpen.value === undefined) {
        innerOpen.value = noTitle ? false : val;
      }
      if (!noTitle) {
        emit('update:visible', val);
        emit('visibleChange', val);
        emit('update:open', val);
        emit('openChange', val);
      }
    };
    var getPopupDomNode = function getPopupDomNode() {
      return tooltip.value.getPopupDomNode();
    };
    expose({
      getPopupDomNode: getPopupDomNode,
      open: innerOpen,
      forcePopupAlign: function forcePopupAlign() {
        var _a;
        return (_a = tooltip.value) === null || _a === void 0 ? void 0 : _a.forcePopupAlign();
      }
    });
    var tooltipPlacements = computed(function () {
      var builtinPlacements = props.builtinPlacements,
        arrowPointAtCenter = props.arrowPointAtCenter,
        autoAdjustOverflow = props.autoAdjustOverflow;
      return builtinPlacements || getPlacements({
        arrowPointAtCenter: arrowPointAtCenter,
        autoAdjustOverflow: autoAdjustOverflow
      });
    });
    var isTrueProps = function isTrueProps(val) {
      return val || val === '';
    };
    var getDisabledCompatibleChildren = function getDisabledCompatibleChildren(ele) {
      var elementType = ele.type;
      if (_typeof(elementType) === 'object' && ele.props) {
        if ((elementType.__ANT_BUTTON === true || elementType === 'button') && isTrueProps(ele.props.disabled) || elementType.__ANT_SWITCH === true && (isTrueProps(ele.props.disabled) || isTrueProps(ele.props.loading)) || elementType.__ANT_RADIO === true && isTrueProps(ele.props.disabled)) {
          // Pick some layout related style properties up to span
          // Prevent layout bugs like https://github.com/ant-design/ant-design/issues/5254
          var _splitObject = splitObject(getStyle(ele), ['position', 'left', 'right', 'top', 'bottom', 'float', 'display', 'zIndex']),
            picked = _splitObject.picked,
            omitted = _splitObject.omitted;
          var spanStyle = _extends(_extends({
            display: 'inline-block'
          }, picked), {
            cursor: 'not-allowed',
            lineHeight: 1,
            width: ele.props && ele.props.block ? '100%' : undefined
          });
          var buttonStyle = _extends(_extends({}, omitted), {
            pointerEvents: 'none'
          });
          var child = cloneElement(ele, {
            style: buttonStyle
          }, true);
          return _createVNode("span", {
            "style": spanStyle,
            "class": "".concat(prefixCls.value, "-disabled-compatible-wrapper")
          }, [child]);
        }
      }
      return ele;
    };
    var getOverlay = function getOverlay() {
      var _a, _b;
      return (_a = props.title) !== null && _a !== void 0 ? _a : (_b = slots.title) === null || _b === void 0 ? void 0 : _b.call(slots);
    };
    var onPopupAlign = function onPopupAlign(domNode, align) {
      var placements = tooltipPlacements.value;
      // 当前返回的位置
      var placement = Object.keys(placements).find(function (key) {
        var _a, _b;
        return placements[key].points[0] === ((_a = align.points) === null || _a === void 0 ? void 0 : _a[0]) && placements[key].points[1] === ((_b = align.points) === null || _b === void 0 ? void 0 : _b[1]);
      });
      if (placement) {
        // 根据当前坐标设置动画点
        var rect = domNode.getBoundingClientRect();
        var transformOrigin = {
          top: '50%',
          left: '50%'
        };
        if (placement.indexOf('top') >= 0 || placement.indexOf('Bottom') >= 0) {
          transformOrigin.top = "".concat(rect.height - align.offset[1], "px");
        } else if (placement.indexOf('Top') >= 0 || placement.indexOf('bottom') >= 0) {
          transformOrigin.top = "".concat(-align.offset[1], "px");
        }
        if (placement.indexOf('left') >= 0 || placement.indexOf('Right') >= 0) {
          transformOrigin.left = "".concat(rect.width - align.offset[0], "px");
        } else if (placement.indexOf('right') >= 0 || placement.indexOf('Left') >= 0) {
          transformOrigin.left = "".concat(-align.offset[0], "px");
        }
        domNode.style.transformOrigin = "".concat(transformOrigin.left, " ").concat(transformOrigin.top);
      }
    };
    var colorInfo = computed(function () {
      return parseColor(prefixCls.value, props.color);
    });
    var injectFromPopover = computed(function () {
      return attrs['data-popover-inject'];
    });
    var _useStyle = useStyle(prefixCls, computed(function () {
        return !injectFromPopover.value;
      })),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _classNames;
      var _a, _b;
      var openClassName = props.openClassName,
        overlayClassName = props.overlayClassName,
        overlayInnerStyle = props.overlayInnerStyle;
      var children = (_b = filterEmpty((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots))) !== null && _b !== void 0 ? _b : null;
      children = children.length === 1 ? children[0] : children;
      var tempVisible = innerOpen.value;
      // Hide tooltip when there is no title
      if (mergedOpen.value === undefined && isNoTitle()) {
        tempVisible = false;
      }
      if (!children) {
        return null;
      }
      var child = getDisabledCompatibleChildren(isValidElement(children) && !isFragment(children) ? children : _createVNode("span", null, [children]));
      var childCls = classNames((_classNames = {}, _defineProperty(_classNames, openClassName || "".concat(prefixCls.value, "-open"), true), _defineProperty(_classNames, child.props && child.props.class, child.props && child.props.class), _classNames));
      var customOverlayClassName = classNames(overlayClassName, _defineProperty({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), colorInfo.value.className, hashId.value);
      var formattedOverlayInnerStyle = _extends(_extends({}, colorInfo.value.overlayStyle), overlayInnerStyle);
      var arrowContentStyle = colorInfo.value.arrowStyle;
      var vcTooltipProps = _extends(_extends(_extends({}, attrs), props), {
        prefixCls: prefixCls.value,
        getPopupContainer: getPopupContainer === null || getPopupContainer === void 0 ? void 0 : getPopupContainer.value,
        builtinPlacements: tooltipPlacements.value,
        visible: tempVisible,
        ref: tooltip,
        overlayClassName: customOverlayClassName,
        overlayInnerStyle: formattedOverlayInnerStyle,
        onVisibleChange: handleVisibleChange,
        onPopupAlign: onPopupAlign,
        transitionName: getTransitionName(rootPrefixCls.value, 'zoom-big-fast', props.transitionName)
      });
      return wrapSSR(_createVNode(VcTooltip, vcTooltipProps, {
        default: function _default() {
          return [innerOpen.value ? cloneElement(child, {
            class: childCls
          }) : child];
        },
        arrowContent: function arrowContent() {
          return _createVNode("span", {
            "class": "".concat(prefixCls.value, "-arrow-content"),
            "style": arrowContentStyle
          }, null);
        },
        overlay: getOverlay
      }));
    };
  }
});