import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import classNames from '../_util/classNames';
import { isPresetColor } from '../_util/colors';
export function parseColor(prefixCls, color) {
  var isInternalColor = isPresetColor(color);
  var className = classNames(_defineProperty({}, "".concat(prefixCls, "-").concat(color), color && isInternalColor));
  var overlayStyle = {};
  var arrowStyle = {};
  if (color && !isInternalColor) {
    overlayStyle.background = color;
    // @ts-ignore
    arrowStyle['--antd-arrow-background-color'] = color;
  }
  return {
    className: className,
    overlayStyle: overlayStyle,
    arrowStyle: arrowStyle
  };
}