import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import { createTextVNode as _createTextVNode, Fragment as _Fragment, createVNode as _createVNode } from "vue";
import classNames from '../_util/classNames';
import PropTypes from '../_util/vue-types';
import { isValidElement, splitAttrs, filterEmpty } from '../_util/props-util';
import DownOutlined from "@ant-design/icons-vue/es/icons/DownOutlined";
import Checkbox from '../checkbox';
import Menu from '../menu';
import Dropdown from '../dropdown';
import Search from './search';
import ListBody from './ListBody';
import { watchEffect, computed, defineComponent, ref } from 'vue';
import { stringType, arrayType, booleanType } from '../_util/type';
import { groupKeysMap } from '../_util/transKeys';
var defaultRender = function defaultRender() {
  return null;
};
function isRenderResultPlainObject(result) {
  return !!(result && !isValidElement(result) && Object.prototype.toString.call(result) === '[object Object]');
}
function getEnabledItemKeys(items) {
  return items.filter(function (data) {
    return !data.disabled;
  }).map(function (data) {
    return data.key;
  });
}
export var transferListProps = {
  prefixCls: String,
  dataSource: arrayType([]),
  filter: String,
  filterOption: Function,
  checkedKeys: PropTypes.arrayOf(PropTypes.string),
  handleFilter: Function,
  handleClear: Function,
  renderItem: Function,
  showSearch: booleanType(false),
  searchPlaceholder: String,
  notFoundContent: PropTypes.any,
  itemUnit: String,
  itemsUnit: String,
  renderList: PropTypes.any,
  disabled: booleanType(),
  direction: stringType(),
  showSelectAll: booleanType(),
  remove: String,
  selectAll: String,
  selectCurrent: String,
  selectInvert: String,
  removeAll: String,
  removeCurrent: String,
  selectAllLabel: PropTypes.any,
  showRemove: booleanType(),
  pagination: PropTypes.any,
  onItemSelect: Function,
  onItemSelectAll: Function,
  onItemRemove: Function,
  onScroll: Function
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'TransferList',
  inheritAttrs: false,
  props: transferListProps,
  // emits: ['scroll', 'itemSelectAll', 'itemRemove', 'itemSelect'],
  slots: ['footer', 'titleText'],
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var filterValue = ref('');
    var transferNode = ref();
    var defaultListBodyRef = ref();
    var renderListBody = function renderListBody(renderList, props) {
      var bodyContent = renderList ? renderList(props) : null;
      var customize = !!bodyContent && filterEmpty(bodyContent).length > 0;
      if (!customize) {
        bodyContent = _createVNode(ListBody, _objectSpread(_objectSpread({}, props), {}, {
          "ref": defaultListBodyRef
        }), null);
      }
      return {
        customize: customize,
        bodyContent: bodyContent
      };
    };
    var renderItemHtml = function renderItemHtml(item) {
      var _props$renderItem = props.renderItem,
        renderItem = _props$renderItem === void 0 ? defaultRender : _props$renderItem;
      var renderResult = renderItem(item);
      var isRenderResultPlain = isRenderResultPlainObject(renderResult);
      return {
        renderedText: isRenderResultPlain ? renderResult.value : renderResult,
        renderedEl: isRenderResultPlain ? renderResult.label : renderResult,
        item: item
      };
    };
    var filteredItems = ref([]);
    var filteredRenderItems = ref([]);
    watchEffect(function () {
      var fItems = [];
      var fRenderItems = [];
      props.dataSource.forEach(function (item) {
        var renderedItem = renderItemHtml(item);
        var renderedText = renderedItem.renderedText;
        // Filter skip
        if (filterValue.value && filterValue.value.trim() && !matchFilter(renderedText, item)) {
          return null;
        }
        fItems.push(item);
        fRenderItems.push(renderedItem);
      });
      filteredItems.value = fItems;
      filteredRenderItems.value = fRenderItems;
    });
    var checkStatus = computed(function () {
      var checkedKeys = props.checkedKeys;
      if (checkedKeys.length === 0) {
        return 'none';
      }
      var checkedKeysMap = groupKeysMap(checkedKeys);
      if (filteredItems.value.every(function (item) {
        return checkedKeysMap.has(item.key) || !!item.disabled;
      })) {
        return 'all';
      }
      return 'part';
    });
    var enabledItemKeys = computed(function () {
      return getEnabledItemKeys(filteredItems.value);
    });
    var getNewSelectKeys = function getNewSelectKeys(keys, unCheckedKeys) {
      return Array.from(new Set([].concat(_toConsumableArray(keys), _toConsumableArray(props.checkedKeys)))).filter(function (key) {
        return unCheckedKeys.indexOf(key) === -1;
      });
    };
    var getCheckBox = function getCheckBox(_ref2) {
      var disabled = _ref2.disabled,
        prefixCls = _ref2.prefixCls;
      var _a;
      var checkedAll = checkStatus.value === 'all';
      var checkAllCheckbox = _createVNode(Checkbox, {
        "disabled": ((_a = props.dataSource) === null || _a === void 0 ? void 0 : _a.length) === 0 || disabled,
        "checked": checkedAll,
        "indeterminate": checkStatus.value === 'part',
        "class": "".concat(prefixCls, "-checkbox"),
        "onChange": function onChange() {
          // Only select enabled items
          var keys = enabledItemKeys.value;
          props.onItemSelectAll(getNewSelectKeys(!checkedAll ? keys : [], checkedAll ? props.checkedKeys : []));
        }
      }, null);
      return checkAllCheckbox;
    };
    var handleFilter = function handleFilter(e) {
      var _a;
      var filter = e.target.value;
      filterValue.value = filter;
      (_a = props.handleFilter) === null || _a === void 0 ? void 0 : _a.call(props, e);
    };
    var handleClear = function handleClear(e) {
      var _a;
      filterValue.value = '';
      (_a = props.handleClear) === null || _a === void 0 ? void 0 : _a.call(props, e);
    };
    var matchFilter = function matchFilter(text, item) {
      var filterOption = props.filterOption;
      if (filterOption) {
        return filterOption(filterValue.value, item);
      }
      return text.includes(filterValue.value);
    };
    var getSelectAllLabel = function getSelectAllLabel(selectedCount, totalCount) {
      var itemsUnit = props.itemsUnit,
        itemUnit = props.itemUnit,
        selectAllLabel = props.selectAllLabel;
      if (selectAllLabel) {
        return typeof selectAllLabel === 'function' ? selectAllLabel({
          selectedCount: selectedCount,
          totalCount: totalCount
        }) : selectAllLabel;
      }
      var unit = totalCount > 1 ? itemsUnit : itemUnit;
      return _createVNode(_Fragment, null, [(selectedCount > 0 ? "".concat(selectedCount, "/") : '') + totalCount, _createTextVNode(" "), unit]);
    };
    var notFoundContentEle = computed(function () {
      return Array.isArray(props.notFoundContent) ? props.notFoundContent[props.direction === 'left' ? 0 : 1] : props.notFoundContent;
    });
    var getListBody = function getListBody(prefixCls, searchPlaceholder, checkedKeys, renderList, showSearch, disabled) {
      var search = showSearch ? _createVNode("div", {
        "class": "".concat(prefixCls, "-body-search-wrapper")
      }, [_createVNode(Search, {
        "prefixCls": "".concat(prefixCls, "-search"),
        "onChange": handleFilter,
        "handleClear": handleClear,
        "placeholder": searchPlaceholder,
        "value": filterValue.value,
        "disabled": disabled
      }, null)]) : null;
      var bodyNode;
      var _splitAttrs = splitAttrs(attrs),
        onEvents = _splitAttrs.onEvents;
      var _renderListBody = renderListBody(renderList, _extends(_extends(_extends({}, props), {
          filteredItems: filteredItems.value,
          filteredRenderItems: filteredRenderItems.value,
          selectedKeys: checkedKeys
        }), onEvents)),
        bodyContent = _renderListBody.bodyContent,
        customize = _renderListBody.customize;
      // We should wrap customize list body in a classNamed div to use flex layout.
      if (customize) {
        bodyNode = _createVNode("div", {
          "class": "".concat(prefixCls, "-body-customize-wrapper")
        }, [bodyContent]);
      } else {
        bodyNode = filteredItems.value.length ? bodyContent : _createVNode("div", {
          "class": "".concat(prefixCls, "-body-not-found")
        }, [notFoundContentEle.value]);
      }
      return _createVNode("div", {
        "class": showSearch ? "".concat(prefixCls, "-body ").concat(prefixCls, "-body-with-search") : "".concat(prefixCls, "-body"),
        "ref": transferNode
      }, [search, bodyNode]);
    };
    return function () {
      var _classNames;
      var _a, _b;
      var prefixCls = props.prefixCls,
        checkedKeys = props.checkedKeys,
        disabled = props.disabled,
        showSearch = props.showSearch,
        searchPlaceholder = props.searchPlaceholder,
        selectAll = props.selectAll,
        selectCurrent = props.selectCurrent,
        selectInvert = props.selectInvert,
        removeAll = props.removeAll,
        removeCurrent = props.removeCurrent,
        renderList = props.renderList,
        onItemSelectAll = props.onItemSelectAll,
        onItemRemove = props.onItemRemove,
        _props$showSelectAll = props.showSelectAll,
        showSelectAll = _props$showSelectAll === void 0 ? true : _props$showSelectAll,
        showRemove = props.showRemove,
        pagination = props.pagination;
      // Custom Layout
      var footerDom = (_a = slots.footer) === null || _a === void 0 ? void 0 : _a.call(slots, _extends({}, props));
      var listCls = classNames(prefixCls, (_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls, "-with-pagination"), !!pagination), _defineProperty(_classNames, "".concat(prefixCls, "-with-footer"), !!footerDom), _classNames));
      // ================================= List Body =================================
      var listBody = getListBody(prefixCls, searchPlaceholder, checkedKeys, renderList, showSearch, disabled);
      var listFooter = footerDom ? _createVNode("div", {
        "class": "".concat(prefixCls, "-footer")
      }, [footerDom]) : null;
      var checkAllCheckbox = !showRemove && !pagination && getCheckBox({
        disabled: disabled,
        prefixCls: prefixCls
      });
      var menu = null;
      if (showRemove) {
        menu = _createVNode(Menu, null, {
          default: function _default() {
            return [pagination && _createVNode(Menu.Item, {
              "key": "removeCurrent",
              "onClick": function onClick() {
                var pageKeys = getEnabledItemKeys((defaultListBodyRef.value.items || []).map(function (entity) {
                  return entity.item;
                }));
                onItemRemove === null || onItemRemove === void 0 ? void 0 : onItemRemove(pageKeys);
              }
            }, {
              default: function _default() {
                return [removeCurrent];
              }
            }), _createVNode(Menu.Item, {
              "key": "removeAll",
              "onClick": function onClick() {
                onItemRemove === null || onItemRemove === void 0 ? void 0 : onItemRemove(enabledItemKeys.value);
              }
            }, {
              default: function _default() {
                return [removeAll];
              }
            })];
          }
        });
      } else {
        menu = _createVNode(Menu, null, {
          default: function _default() {
            return [_createVNode(Menu.Item, {
              "key": "selectAll",
              "onClick": function onClick() {
                var keys = enabledItemKeys.value;
                onItemSelectAll(getNewSelectKeys(keys, []));
              }
            }, {
              default: function _default() {
                return [selectAll];
              }
            }), pagination && _createVNode(Menu.Item, {
              "onClick": function onClick() {
                var pageKeys = getEnabledItemKeys((defaultListBodyRef.value.items || []).map(function (entity) {
                  return entity.item;
                }));
                onItemSelectAll(getNewSelectKeys(pageKeys, []));
              }
            }, {
              default: function _default() {
                return [selectCurrent];
              }
            }), _createVNode(Menu.Item, {
              "key": "selectInvert",
              "onClick": function onClick() {
                var availableKeys;
                if (pagination) {
                  availableKeys = getEnabledItemKeys((defaultListBodyRef.value.items || []).map(function (entity) {
                    return entity.item;
                  }));
                } else {
                  availableKeys = enabledItemKeys.value;
                }
                var checkedKeySet = new Set(checkedKeys);
                var newCheckedKeys = [];
                var newUnCheckedKeys = [];
                availableKeys.forEach(function (key) {
                  if (checkedKeySet.has(key)) {
                    newUnCheckedKeys.push(key);
                  } else {
                    newCheckedKeys.push(key);
                  }
                });
                onItemSelectAll(getNewSelectKeys(newCheckedKeys, newUnCheckedKeys));
              }
            }, {
              default: function _default() {
                return [selectInvert];
              }
            })];
          }
        });
      }
      var dropdown = _createVNode(Dropdown, {
        "class": "".concat(prefixCls, "-header-dropdown"),
        "overlay": menu,
        "disabled": disabled
      }, {
        default: function _default() {
          return [_createVNode(DownOutlined, null, null)];
        }
      });
      return _createVNode("div", {
        "class": listCls,
        "style": attrs.style
      }, [_createVNode("div", {
        "class": "".concat(prefixCls, "-header")
      }, [showSelectAll ? _createVNode(_Fragment, null, [checkAllCheckbox, dropdown]) : null, _createVNode("span", {
        "class": "".concat(prefixCls, "-header-selected")
      }, [_createVNode("span", null, [getSelectAllLabel(checkedKeys.length, filteredItems.value.length)]), _createVNode("span", {
        "class": "".concat(prefixCls, "-header-title")
      }, [(_b = slots.titleText) === null || _b === void 0 ? void 0 : _b.call(slots)])])]), listBody, listFooter]);
    };
  }
});