import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { getStyle as getCheckboxStyle } from '../../checkbox/style';
import { genComponentStyleHook, mergeToken } from '../../theme/internal';
import { genTreeStyle } from '../../tree/style';
// =============================== Base ===============================
var genBaseStyle = function genBaseStyle(token) {
  var componentCls = token.componentCls,
    treePrefixCls = token.treePrefixCls,
    colorBgElevated = token.colorBgElevated;
  var treeCls = ".".concat(treePrefixCls);
  return [// ======================================================
  // ==                     Dropdown                     ==
  // ======================================================
  _defineProperty({}, "".concat(componentCls, "-dropdown"), [{
    padding: "".concat(token.paddingXS, "px ").concat(token.paddingXS / 2, "px")
  },
  // ====================== Tree ======================
  genTreeStyle(treePrefixCls, mergeToken(token, {
    colorBgContainer: colorBgElevated
  })), _defineProperty({}, treeCls, {
    borderRadius: 0,
    '&-list-holder-inner': _defineProperty({
      alignItems: 'stretch'
    }, "".concat(treeCls, "-treenode"), _defineProperty({}, "".concat(treeCls, "-node-content-wrapper"), {
      flex: 'auto'
    }))
  }),
  // ==================== Checkbox ====================
  getCheckboxStyle("".concat(treePrefixCls, "-checkbox"), token),
  // ====================== RTL =======================
  {
    '&-rtl': _defineProperty({
      direction: 'rtl'
    }, "".concat(treeCls, "-switcher").concat(treeCls, "-switcher_close"), _defineProperty({}, "".concat(treeCls, "-switcher-icon svg"), {
      transform: 'rotate(90deg)'
    }))
  }])];
};
// ============================== Export ==============================
export default function useTreeSelectStyle(prefixCls, treePrefixCls) {
  return genComponentStyleHook('TreeSelect', function (token) {
    var treeSelectToken = mergeToken(token, {
      treePrefixCls: treePrefixCls.value
    });
    return [genBaseStyle(treeSelectToken)];
  })(prefixCls);
}