import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
import KeyCode from '../_util/KeyCode';
import TextArea from '../input/TextArea';
import EnterOutlined from "@ant-design/icons-vue/es/icons/EnterOutlined";
import { defineComponent, ref, reactive, watch, onMounted, toRefs } from 'vue';
import classNames from '../_util/classNames';
// CSSINJS
import useStyle from './style';
var editableProps = function editableProps() {
  return {
    prefixCls: String,
    value: String,
    maxlength: Number,
    autoSize: {
      type: [Boolean, Object]
    },
    onSave: Function,
    onCancel: Function,
    onEnd: Function,
    onChange: Function,
    originContent: String,
    direction: String,
    component: String
  };
};
var Editable = defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'Editable',
  inheritAttrs: false,
  props: editableProps(),
  // emits: ['save', 'cancel', 'end', 'change'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      slots = _ref.slots,
      attrs = _ref.attrs;
    var _toRefs = toRefs(props),
      prefixCls = _toRefs.prefixCls;
    var state = reactive({
      current: props.value || '',
      lastKeyCode: undefined,
      inComposition: false,
      cancelFlag: false
    });
    watch(function () {
      return props.value;
    }, function (current) {
      state.current = current;
    });
    var textArea = ref();
    onMounted(function () {
      var _a;
      if (textArea.value) {
        var resizableTextArea = (_a = textArea.value) === null || _a === void 0 ? void 0 : _a.resizableTextArea;
        var innerTextArea = resizableTextArea === null || resizableTextArea === void 0 ? void 0 : resizableTextArea.textArea;
        innerTextArea.focus();
        var length = innerTextArea.value.length;
        innerTextArea.setSelectionRange(length, length);
      }
    });
    function saveTextAreaRef(node) {
      textArea.value = node;
    }
    function onChange(_ref2) {
      var value = _ref2.target.value;
      state.current = value.replace(/[\r\n]/g, '');
      emit('change', state.current);
    }
    function onCompositionStart() {
      state.inComposition = true;
    }
    function onCompositionEnd() {
      state.inComposition = false;
    }
    function onKeyDown(e) {
      var keyCode = e.keyCode;
      if (keyCode === KeyCode.ENTER) {
        e.preventDefault();
      }
      // We don't record keyCode when IME is using
      if (state.inComposition) return;
      state.lastKeyCode = keyCode;
    }
    function onKeyUp(e) {
      var keyCode = e.keyCode,
        ctrlKey = e.ctrlKey,
        altKey = e.altKey,
        metaKey = e.metaKey,
        shiftKey = e.shiftKey;
      // Check if it's a real key
      if (state.lastKeyCode === keyCode && !state.inComposition && !ctrlKey && !altKey && !metaKey && !shiftKey) {
        if (keyCode === KeyCode.ENTER) {
          confirmChange();
          emit('end');
        } else if (keyCode === KeyCode.ESC) {
          state.current = props.originContent;
          emit('cancel');
        }
      }
    }
    function onBlur() {
      confirmChange();
    }
    function confirmChange() {
      emit('save', state.current.trim());
    }
    // style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _classNames;
      var textAreaClassName = classNames((_classNames = {}, _defineProperty(_classNames, "".concat(prefixCls.value), true), _defineProperty(_classNames, "".concat(prefixCls.value, "-edit-content"), true), _defineProperty(_classNames, "".concat(prefixCls.value, "-rtl"), props.direction === 'rtl'), _defineProperty(_classNames, props.component ? "".concat(prefixCls.value, "-").concat(props.component) : '', true), _classNames), attrs.class, hashId.value);
      return wrapSSR(_createVNode("div", _objectSpread(_objectSpread({}, attrs), {}, {
        "class": textAreaClassName
      }), [_createVNode(TextArea, {
        "ref": saveTextAreaRef,
        "maxlength": props.maxlength,
        "value": state.current,
        "onChange": onChange,
        "onKeydown": onKeyDown,
        "onKeyup": onKeyUp,
        "onCompositionstart": onCompositionStart,
        "onCompositionend": onCompositionEnd,
        "onBlur": onBlur,
        "rows": 1,
        "autoSize": props.autoSize === undefined || props.autoSize
      }, null), slots.enterIcon ? slots.enterIcon({
        className: "".concat(props.prefixCls, "-edit-content-confirm")
      }) : _createVNode(EnterOutlined, {
        "class": "".concat(props.prefixCls, "-edit-content-confirm")
      }, null)]));
    };
  }
});
export default Editable;