import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import _slicedToArray from "@babel/runtime/helpers/esm/slicedToArray";
import { createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { defineComponent } from 'vue';
import useConfigInject from '../config-provider/hooks/useConfigInject';
import classNames from '../_util/classNames';
// CSSINJS
import useStyle from './style';
export var typographyProps = function typographyProps() {
  return {
    prefixCls: String,
    direction: String,
    // Form Internal use
    component: String
  };
};
var Typography = defineComponent({
  name: 'ATypography',
  inheritAttrs: false,
  props: typographyProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = useConfigInject('typography', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    // Style
    var _useStyle = useStyle(prefixCls),
      _useStyle2 = _slicedToArray(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _a;
      var _b = _extends(_extends({}, props), attrs),
        _prefixCls = _b.prefixCls,
        _className = _b.class,
        _direction = _b.direction,
        _b$component = _b.component,
        Component = _b$component === void 0 ? 'article' : _b$component,
        restProps = __rest(_b, ["prefixCls", "class", "direction", "component"]);
      return wrapSSR(_createVNode(Component, _objectSpread({
        "class": classNames(prefixCls.value, _defineProperty({}, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), attrs.class, hashId.value)
      }, restProps), {
        default: function _default() {
          return [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)];
        }
      }));
    };
  }
});
export default Typography;