import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { withDirectives as _withDirectives, createVNode as _createVNode, vShow as _vShow } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { Transition, defineComponent, onMounted, onUnmounted, nextTick, watch, shallowRef } from 'vue';
import classnames from '../../_util/classNames';
import KeyCode from '../../_util/KeyCode';
import omit from '../../_util/omit';
import { drawerChildProps } from './IDrawerPropTypes';
import { dataToArray, windowIsUndefined } from './utils';
var currentDrawer = {};
var DrawerChild = defineComponent({
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: false,
  props: drawerChildProps(),
  emits: ['close', 'handleClick', 'change'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      slots = _ref.slots;
    var contentWrapper = shallowRef();
    var dom = shallowRef();
    var maskDom = shallowRef();
    var handlerDom = shallowRef();
    var contentDom = shallowRef();
    var levelDom = [];
    var drawerId = "drawer_id_".concat(Number((Date.now() + Math.random()).toString().replace('.', Math.round(Math.random() * 9).toString())).toString(16));
    onMounted(function () {
      nextTick(function () {
        var _a;
        var open = props.open,
          getContainer = props.getContainer,
          showMask = props.showMask,
          autofocus = props.autofocus;
        var container = getContainer === null || getContainer === void 0 ? void 0 : getContainer();
        getLevelDom(props);
        if (open) {
          if (container && container.parentNode === document.body) {
            currentDrawer[drawerId] = open;
          }
          nextTick(function () {
            if (autofocus) {
              domFocus();
            }
          });
          if (showMask) {
            (_a = props.scrollLocker) === null || _a === void 0 ? void 0 : _a.lock();
          }
        }
      });
    });
    watch(function () {
      return props.level;
    }, function () {
      getLevelDom(props);
    }, {
      flush: 'post'
    });
    watch(function () {
      return props.open;
    }, function () {
      var open = props.open,
        getContainer = props.getContainer,
        scrollLocker = props.scrollLocker,
        showMask = props.showMask,
        autofocus = props.autofocus;
      var container = getContainer === null || getContainer === void 0 ? void 0 : getContainer();
      if (container && container.parentNode === document.body) {
        currentDrawer[drawerId] = !!open;
      }
      if (open) {
        if (autofocus) {
          domFocus();
        }
        if (showMask) {
          scrollLocker === null || scrollLocker === void 0 ? void 0 : scrollLocker.lock();
        }
      } else {
        scrollLocker === null || scrollLocker === void 0 ? void 0 : scrollLocker.unLock();
      }
    }, {
      flush: 'post'
    });
    onUnmounted(function () {
      var _a;
      var open = props.open;
      delete currentDrawer[drawerId];
      if (open) {
        document.body.style.touchAction = '';
      }
      (_a = props.scrollLocker) === null || _a === void 0 ? void 0 : _a.unLock();
    });
    watch(function () {
      return props.placement;
    }, function (val) {
      if (val) {
        // test 的 bug, 有动画过场，删除 dom
        contentDom.value = null;
      }
    });
    var domFocus = function domFocus() {
      var _a, _b;
      (_b = (_a = dom.value) === null || _a === void 0 ? void 0 : _a.focus) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    var onClose = function onClose(e) {
      emit('close', e);
    };
    var onKeyDown = function onKeyDown(e) {
      if (e.keyCode === KeyCode.ESC) {
        e.stopPropagation();
        onClose(e);
      }
    };
    var onAfterVisibleChange = function onAfterVisibleChange() {
      var open = props.open,
        afterVisibleChange = props.afterVisibleChange;
      if (afterVisibleChange) {
        afterVisibleChange(!!open);
      }
    };
    var getLevelDom = function getLevelDom(_ref2) {
      var level = _ref2.level,
        getContainer = _ref2.getContainer;
      if (windowIsUndefined) {
        return;
      }
      var container = getContainer === null || getContainer === void 0 ? void 0 : getContainer();
      var parent = container ? container.parentNode : null;
      levelDom = [];
      if (level === 'all') {
        var children = parent ? Array.prototype.slice.call(parent.children) : [];
        children.forEach(function (child) {
          if (child.nodeName !== 'SCRIPT' && child.nodeName !== 'STYLE' && child.nodeName !== 'LINK' && child !== container) {
            levelDom.push(child);
          }
        });
      } else if (level) {
        dataToArray(level).forEach(function (key) {
          document.querySelectorAll(key).forEach(function (item) {
            levelDom.push(item);
          });
        });
      }
    };
    var onHandleClick = function onHandleClick(e) {
      emit('handleClick', e);
    };
    var canOpen = shallowRef(false);
    watch(dom, function () {
      nextTick(function () {
        canOpen.value = true;
      });
    });
    return function () {
      var _classnames;
      var _a, _b;
      var width = props.width,
        height = props.height,
        $open = props.open,
        prefixCls = props.prefixCls,
        placement = props.placement,
        level = props.level,
        levelMove = props.levelMove,
        ease = props.ease,
        duration = props.duration,
        getContainer = props.getContainer,
        onChange = props.onChange,
        afterVisibleChange = props.afterVisibleChange,
        showMask = props.showMask,
        maskClosable = props.maskClosable,
        maskStyle = props.maskStyle,
        keyboard = props.keyboard,
        getOpenCount = props.getOpenCount,
        scrollLocker = props.scrollLocker,
        contentWrapperStyle = props.contentWrapperStyle,
        style = props.style,
        className = props.class,
        rootClassName = props.rootClassName,
        rootStyle = props.rootStyle,
        maskMotion = props.maskMotion,
        motion = props.motion,
        inline = props.inline,
        otherProps = __rest(props, ["width", "height", "open", "prefixCls", "placement", "level", "levelMove", "ease", "duration", "getContainer", "onChange", "afterVisibleChange", "showMask", "maskClosable", "maskStyle", "keyboard", "getOpenCount", "scrollLocker", "contentWrapperStyle", "style", "class", "rootClassName", "rootStyle", "maskMotion", "motion", "inline"]);
      // 首次渲染都将是关闭状态。
      var open = $open && canOpen.value;
      var wrapperClassName = classnames(prefixCls, (_classnames = {}, _defineProperty(_classnames, "".concat(prefixCls, "-").concat(placement), true), _defineProperty(_classnames, "".concat(prefixCls, "-open"), open), _defineProperty(_classnames, "".concat(prefixCls, "-inline"), inline), _defineProperty(_classnames, 'no-mask', !showMask), _defineProperty(_classnames, rootClassName, true), _classnames));
      var motionProps = typeof motion === 'function' ? motion(placement) : motion;
      return _createVNode("div", _objectSpread(_objectSpread({}, omit(otherProps, ['switchScrollingEffect', 'autofocus'])), {}, {
        "tabindex": -1,
        "class": wrapperClassName,
        "style": rootStyle,
        "ref": dom,
        "onKeydown": open && keyboard ? onKeyDown : undefined
      }), [_createVNode(Transition, maskMotion, {
        default: function _default() {
          return [showMask && _withDirectives(_createVNode("div", {
            "class": "".concat(prefixCls, "-mask"),
            "onClick": maskClosable ? onClose : undefined,
            "style": maskStyle,
            "ref": maskDom
          }, null), [[_vShow, open]])];
        }
      }), _createVNode(Transition, _objectSpread(_objectSpread({}, motionProps), {}, {
        "onAfterEnter": onAfterVisibleChange,
        "onAfterLeave": onAfterVisibleChange
      }), {
        default: function _default() {
          return [_withDirectives(_createVNode("div", {
            "class": "".concat(prefixCls, "-content-wrapper"),
            "style": [contentWrapperStyle],
            "ref": contentWrapper
          }, [_createVNode("div", {
            "class": ["".concat(prefixCls, "-content"), className],
            "style": style,
            "ref": contentDom
          }, [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]), slots.handler ? _createVNode("div", {
            "onClick": onHandleClick,
            "ref": handlerDom
          }, [(_b = slots.handler) === null || _b === void 0 ? void 0 : _b.call(slots)]) : null]), [[_vShow, open]])];
        }
      })]);
    };
  }
});
export default DrawerChild;