import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _typeof from "@babel/runtime/helpers/esm/typeof";
import _toConsumableArray from "@babel/runtime/helpers/esm/toConsumableArray";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import _extends from "@babel/runtime/helpers/esm/extends";
import { resolveDirective as _resolveDirective, Fragment as _Fragment, createVNode as _createVNode } from "vue";
var __rest = this && this.__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
import { onMounted, defineComponent, getCurrentInstance, nextTick, shallowRef, watch, withDirectives } from 'vue';
import classNames from '../_util/classNames';
import omit from '../_util/omit';
import { inputProps } from './inputProps';
import { fixControlledValue, hasAddon, hasPrefixSuffix, resolveOnChange, triggerFocus } from './utils/commonUtils';
import antInputDirective from '../_util/antInputDirective';
import BaseInput from './BaseInput';
export default defineComponent({
  name: 'VCInput',
  inheritAttrs: false,
  props: inputProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      expose = _ref.expose,
      emit = _ref.emit;
    var stateValue = shallowRef(props.value === undefined ? props.defaultValue : props.value);
    var focused = shallowRef(false);
    var inputRef = shallowRef();
    watch(function () {
      return props.value;
    }, function () {
      stateValue.value = props.value;
    });
    watch(function () {
      return props.disabled;
    }, function () {
      if (props.disabled) {
        focused.value = false;
      }
    });
    var focus = function focus(option) {
      if (inputRef.value) {
        triggerFocus(inputRef.value, option);
      }
    };
    var blur = function blur() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var setSelectionRange = function setSelectionRange(start, end, direction) {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.setSelectionRange(start, end, direction);
    };
    var select = function select() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.select();
    };
    expose({
      focus: focus,
      blur: blur,
      input: inputRef,
      stateValue: stateValue,
      setSelectionRange: setSelectionRange,
      select: select
    });
    var triggerChange = function triggerChange(e) {
      emit('change', e);
    };
    var instance = getCurrentInstance();
    var setValue = function setValue(value, callback) {
      if (stateValue.value === value) {
        return;
      }
      if (props.value === undefined) {
        stateValue.value = value;
      } else {
        nextTick(function () {
          if (inputRef.value.value !== stateValue.value) {
            instance.update();
          }
        });
      }
      nextTick(function () {
        callback && callback();
      });
    };
    var handleChange = function handleChange(e) {
      var _e$target = e.target,
        value = _e$target.value,
        composing = _e$target.composing;
      // https://github.com/vueComponent/ant-design-vue/issues/2203
      if ((e.isComposing || composing) && props.lazy || stateValue.value === value) return;
      var newVal = e.target.value;
      resolveOnChange(inputRef.value, e, triggerChange);
      setValue(newVal);
    };
    var handleKeyDown = function handleKeyDown(e) {
      if (e.keyCode === 13) {
        emit('pressEnter', e);
      }
      emit('keydown', e);
    };
    var handleFocus = function handleFocus(e) {
      focused.value = true;
      emit('focus', e);
    };
    var handleBlur = function handleBlur(e) {
      focused.value = false;
      emit('blur', e);
    };
    var handleReset = function handleReset(e) {
      resolveOnChange(inputRef.value, e, triggerChange);
      setValue('', function () {
        focus();
      });
    };
    var getInputElement = function getInputElement() {
      var _a, _b;
      var _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? slots.addonBefore : _props$addonBefore,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? slots.addonAfter : _props$addonAfter,
        disabled = props.disabled,
        _props$valueModifiers = props.valueModifiers,
        valueModifiers = _props$valueModifiers === void 0 ? {} : _props$valueModifiers,
        htmlSize = props.htmlSize,
        autocomplete = props.autocomplete,
        prefixCls = props.prefixCls,
        inputClassName = props.inputClassName,
        _props$prefix = props.prefix,
        prefix = _props$prefix === void 0 ? (_a = slots.prefix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$prefix,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? (_b = slots.suffix) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$suffix,
        allowClear = props.allowClear,
        _props$type = props.type,
        type = _props$type === void 0 ? 'text' : _props$type;
      var otherProps = omit(props, ['prefixCls', 'onPressEnter', 'addonBefore', 'addonAfter', 'prefix', 'suffix', 'allowClear',
      // Input elements must be either controlled or uncontrolled,
      // specify either the value prop, or the defaultValue prop, but not both.
      'defaultValue', 'size', 'bordered', 'htmlSize', 'lazy', 'showCount', 'valueModifiers', 'showCount', 'affixWrapperClassName', 'groupClassName', 'inputClassName', 'wrapperClassName']);
      var inputProps = _extends(_extends(_extends({}, otherProps), attrs), {
        autocomplete: autocomplete,
        onChange: handleChange,
        onInput: handleChange,
        onFocus: handleFocus,
        onBlur: handleBlur,
        onKeydown: handleKeyDown,
        class: classNames(prefixCls, _defineProperty({}, "".concat(prefixCls, "-disabled"), disabled), inputClassName, !hasAddon({
          addonAfter: addonAfter,
          addonBefore: addonBefore
        }) && !hasPrefixSuffix({
          prefix: prefix,
          suffix: suffix,
          allowClear: allowClear
        }) && attrs.class),
        ref: inputRef,
        key: 'ant-input',
        size: htmlSize,
        type: type
      });
      if (valueModifiers.lazy) {
        delete inputProps.onInput;
      }
      if (!inputProps.autofocus) {
        delete inputProps.autofocus;
      }
      var inputNode = _createVNode("input", omit(inputProps, ['size']), null);
      return withDirectives(inputNode, [[antInputDirective]]);
    };
    var getSuffix = function getSuffix() {
      var _a;
      var maxlength = props.maxlength,
        _props$suffix2 = props.suffix,
        suffix = _props$suffix2 === void 0 ? (_a = slots.suffix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$suffix2,
        showCount = props.showCount,
        prefixCls = props.prefixCls;
      // Max length value
      var hasMaxLength = Number(maxlength) > 0;
      if (suffix || showCount) {
        var valueLength = _toConsumableArray(fixControlledValue(stateValue.value)).length;
        var dataCount = _typeof(showCount) === 'object' ? showCount.formatter({
          count: valueLength,
          maxlength: maxlength
        }) : "".concat(valueLength).concat(hasMaxLength ? " / ".concat(maxlength) : '');
        return _createVNode(_Fragment, null, [!!showCount && _createVNode("span", {
          "class": classNames("".concat(prefixCls, "-show-count-suffix"), _defineProperty({}, "".concat(prefixCls, "-show-count-has-suffix"), !!suffix))
        }, [dataCount]), suffix]);
      }
      return null;
    };
    onMounted(function () {
      if (process.env.NODE_ENV === 'test') {
        if (props.autofocus) {
          focus();
        }
      }
    });
    return function () {
      var prefixCls = props.prefixCls,
        disabled = props.disabled,
        rest = __rest(props, ["prefixCls", "disabled"]);
      return _createVNode(BaseInput, _objectSpread(_objectSpread(_objectSpread({}, rest), attrs), {}, {
        "prefixCls": prefixCls,
        "inputElement": getInputElement(),
        "handleReset": handleReset,
        "value": fixControlledValue(stateValue.value),
        "focused": focused.value,
        "triggerFocus": focus,
        "suffix": getSuffix(),
        "disabled": disabled
      }), slots);
    };
  }
});