import _objectSpread from "@babel/runtime/helpers/esm/objectSpread2";
import _defineProperty from "@babel/runtime/helpers/esm/defineProperty";
import { createVNode as _createVNode } from "vue";
import PropTypes, { withUndefined } from '../_util/vue-types';
import { defineComponent } from 'vue';
import classNames from '../_util/classNames';
import warning from '../_util/warning';
import { booleanType, stringType, functionType } from '../_util/type';
import omit from '../_util/omit';
function isString(str) {
  return typeof str === 'string';
}
function noop() {}
export var VcStepProps = function VcStepProps() {
  return {
    prefixCls: String,
    itemWidth: String,
    active: {
      type: Boolean,
      default: undefined
    },
    disabled: {
      type: Boolean,
      default: undefined
    },
    status: stringType(),
    iconPrefix: String,
    icon: PropTypes.any,
    adjustMarginRight: String,
    stepNumber: Number,
    stepIndex: Number,
    description: PropTypes.any,
    title: PropTypes.any,
    subTitle: PropTypes.any,
    progressDot: withUndefined(PropTypes.oneOfType([PropTypes.looseBool, PropTypes.func])),
    tailContent: PropTypes.any,
    icons: PropTypes.shape({
      finish: PropTypes.any,
      error: PropTypes.any
    }).loose,
    onClick: functionType(),
    onStepClick: functionType(),
    stepIcon: functionType(),
    itemRender: functionType(),
    __legacy: booleanType()
  };
};
export default defineComponent({
  compatConfig: {
    MODE: 3
  },
  name: 'Step',
  inheritAttrs: false,
  props: VcStepProps(),
  slots: ['title', 'subTitle', 'description', 'tailContent', 'stepIcon', 'progressDot'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var onItemClick = function onItemClick(e) {
      emit('click', e);
      emit('stepClick', props.stepIndex);
    };
    if (props.__legacy !== false) {
      warning(false, 'Steps', 'Step is deprecated, and not support inline type. Please use `items` directly. ');
    }
    var renderIconNode = function renderIconNode(_ref2) {
      var _classNames;
      var icon = _ref2.icon,
        title = _ref2.title,
        description = _ref2.description;
      var prefixCls = props.prefixCls,
        stepNumber = props.stepNumber,
        status = props.status,
        iconPrefix = props.iconPrefix,
        icons = props.icons,
        _props$progressDot = props.progressDot,
        progressDot = _props$progressDot === void 0 ? slots.progressDot : _props$progressDot,
        _props$stepIcon = props.stepIcon,
        stepIcon = _props$stepIcon === void 0 ? slots.stepIcon : _props$stepIcon;
      var iconNode;
      var iconClassName = classNames("".concat(prefixCls, "-icon"), "".concat(iconPrefix, "icon"), (_classNames = {}, _defineProperty(_classNames, "".concat(iconPrefix, "icon-").concat(icon), icon && isString(icon)), _defineProperty(_classNames, "".concat(iconPrefix, "icon-check"), !icon && status === 'finish' && (icons && !icons.finish || !icons)), _defineProperty(_classNames, "".concat(iconPrefix, "icon-cross"), !icon && status === 'error' && (icons && !icons.error || !icons)), _classNames));
      var iconDot = _createVNode("span", {
        "class": "".concat(prefixCls, "-icon-dot")
      }, null);
      // `progressDot` enjoy the highest priority
      if (progressDot) {
        if (typeof progressDot === 'function') {
          iconNode = _createVNode("span", {
            "class": "".concat(prefixCls, "-icon")
          }, [progressDot({
            iconDot: iconDot,
            index: stepNumber - 1,
            status: status,
            title: title,
            description: description,
            prefixCls: prefixCls
          })]);
        } else {
          iconNode = _createVNode("span", {
            "class": "".concat(prefixCls, "-icon")
          }, [iconDot]);
        }
      } else if (icon && !isString(icon)) {
        iconNode = _createVNode("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [icon]);
      } else if (icons && icons.finish && status === 'finish') {
        iconNode = _createVNode("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [icons.finish]);
      } else if (icons && icons.error && status === 'error') {
        iconNode = _createVNode("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [icons.error]);
      } else if (icon || status === 'finish' || status === 'error') {
        iconNode = _createVNode("span", {
          "class": iconClassName
        }, null);
      } else {
        iconNode = _createVNode("span", {
          "class": "".concat(prefixCls, "-icon")
        }, [stepNumber]);
      }
      if (stepIcon) {
        iconNode = stepIcon({
          index: stepNumber - 1,
          status: status,
          title: title,
          description: description,
          node: iconNode
        });
      }
      return iconNode;
    };
    return function () {
      var _classNames2;
      var _a, _b, _c, _d;
      var prefixCls = props.prefixCls,
        itemWidth = props.itemWidth,
        active = props.active,
        _props$status = props.status,
        status = _props$status === void 0 ? 'wait' : _props$status,
        tailContent = props.tailContent,
        adjustMarginRight = props.adjustMarginRight,
        disabled = props.disabled,
        _props$title = props.title,
        title = _props$title === void 0 ? (_a = slots.title) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$title,
        _props$description = props.description,
        description = _props$description === void 0 ? (_b = slots.description) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$description,
        _props$subTitle = props.subTitle,
        subTitle = _props$subTitle === void 0 ? (_c = slots.subTitle) === null || _c === void 0 ? void 0 : _c.call(slots) : _props$subTitle,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? (_d = slots.icon) === null || _d === void 0 ? void 0 : _d.call(slots) : _props$icon,
        onClick = props.onClick,
        onStepClick = props.onStepClick;
      var mergedStatus = status || 'wait';
      var classString = classNames("".concat(prefixCls, "-item"), "".concat(prefixCls, "-item-").concat(mergedStatus), (_classNames2 = {}, _defineProperty(_classNames2, "".concat(prefixCls, "-item-custom"), icon), _defineProperty(_classNames2, "".concat(prefixCls, "-item-active"), active), _defineProperty(_classNames2, "".concat(prefixCls, "-item-disabled"), disabled === true), _classNames2));
      var stepItemStyle = {};
      if (itemWidth) {
        stepItemStyle.width = itemWidth;
      }
      if (adjustMarginRight) {
        stepItemStyle.marginRight = adjustMarginRight;
      }
      var accessibilityProps = {
        onClick: onClick || noop
      };
      if (onStepClick && !disabled) {
        accessibilityProps.role = 'button';
        accessibilityProps.tabindex = 0;
        accessibilityProps.onClick = onItemClick;
      }
      var stepNode = _createVNode("div", _objectSpread(_objectSpread({}, omit(attrs, ['__legacy'])), {}, {
        "class": [classString, attrs.class],
        "style": [attrs.style, stepItemStyle]
      }), [_createVNode("div", _objectSpread(_objectSpread({}, accessibilityProps), {}, {
        "class": "".concat(prefixCls, "-item-container")
      }), [_createVNode("div", {
        "class": "".concat(prefixCls, "-item-tail")
      }, [tailContent]), _createVNode("div", {
        "class": "".concat(prefixCls, "-item-icon")
      }, [renderIconNode({
        icon: icon,
        title: title,
        description: description
      })]), _createVNode("div", {
        "class": "".concat(prefixCls, "-item-content")
      }, [_createVNode("div", {
        "class": "".concat(prefixCls, "-item-title")
      }, [title, subTitle && _createVNode("div", {
        "title": typeof subTitle === 'string' ? subTitle : undefined,
        "class": "".concat(prefixCls, "-item-subtitle")
      }, [subTitle])]), description && _createVNode("div", {
        "class": "".concat(prefixCls, "-item-description")
      }, [description])])])]);
      if (props.itemRender) {
        return props.itemRender(stepNode);
      }
      return stepNode;
    };
  }
});