"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMutationObserver = useMutationObserver;
var _tryOnScopeDispose = require("./tryOnScopeDispose");
var _vue = require("vue");
var _unrefElement = require("./unrefElement");
var _useSupported = require("./useSupported");
var _configurable = require("./_configurable");
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
/**
 * Watch for changes being made to the DOM tree.
 *
 * @see https://vueuse.org/useMutationObserver
 * @see https://developer.mozilla.org/en-US/docs/Web/API/MutationObserver MutationObserver MDN
 * @param target
 * @param callback
 * @param options
 */
function useMutationObserver(target, callback) {
  var options = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {};
  var _options$window = options.window,
    window = _options$window === void 0 ? _configurable.defaultWindow : _options$window,
    mutationOptions = __rest(options, ["window"]);
  var observer;
  var isSupported = (0, _useSupported.useSupported)(function () {
    return window && 'MutationObserver' in window;
  });
  var cleanup = function cleanup() {
    if (observer) {
      observer.disconnect();
      observer = undefined;
    }
  };
  var stopWatch = (0, _vue.watch)(function () {
    return (0, _unrefElement.unrefElement)(target);
  }, function (el) {
    cleanup();
    if (isSupported.value && window && el) {
      observer = new MutationObserver(callback);
      observer.observe(el, mutationOptions);
    }
  }, {
    immediate: true
  });
  var stop = function stop() {
    cleanup();
    stopWatch();
  };
  (0, _tryOnScopeDispose.tryOnScopeDispose)(stop);
  return {
    isSupported: isSupported,
    stop: stop
  };
}