"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
var genWaveStyle = function genWaveStyle(token) {
  var componentCls = token.componentCls,
    colorPrimary = token.colorPrimary;
  return (0, _defineProperty2.default)({}, componentCls, {
    position: 'absolute',
    background: 'transparent',
    pointerEvents: 'none',
    boxSizing: 'border-box',
    color: "var(--wave-color, ".concat(colorPrimary, ")"),
    boxShadow: "0 0 0 0 currentcolor",
    opacity: 0.2,
    // =================== Motion ===================
    '&.wave-motion-appear': {
      transition: ["box-shadow 0.4s ".concat(token.motionEaseOutCirc), "opacity 2s ".concat(token.motionEaseOutCirc)].join(','),
      '&-active': {
        boxShadow: "0 0 0 6px currentcolor",
        opacity: 0
      }
    }
  });
};
var _default = (0, _internal.genComponentStyleHook)('Wave', function (token) {
  return [genWaveStyle(token)];
});
exports.default = _default;