"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genTypeStyle = exports.genBaseStyle = exports.genAlertStyle = exports.genActionStyle = exports.default = void 0;
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _internal = require("../../theme/internal");
var _style = require("../../style");
var genAlertTypeStyle = function genAlertTypeStyle(bgColor, borderColor, iconColor, token, alertCls) {
  return (0, _defineProperty2.default)({
    backgroundColor: bgColor,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(borderColor)
  }, "".concat(alertCls, "-icon"), {
    color: iconColor
  });
};
var genBaseStyle = function genBaseStyle(token) {
  var _extends2, _$concat, _ref2;
  var componentCls = token.componentCls,
    duration = token.motionDurationSlow,
    marginXS = token.marginXS,
    marginSM = token.marginSM,
    fontSize = token.fontSize,
    fontSizeLG = token.fontSizeLG,
    lineHeight = token.lineHeight,
    borderRadius = token.borderRadiusLG,
    motionEaseInOutCirc = token.motionEaseInOutCirc,
    alertIconSizeLG = token.alertIconSizeLG,
    colorText = token.colorText,
    paddingContentVerticalSM = token.paddingContentVerticalSM,
    alertPaddingHorizontal = token.alertPaddingHorizontal,
    paddingMD = token.paddingMD,
    paddingContentHorizontalLG = token.paddingContentHorizontalLG;
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, componentCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    padding: "".concat(paddingContentVerticalSM, "px ").concat(alertPaddingHorizontal, "px"),
    wordWrap: 'break-word',
    borderRadius: borderRadius
  }, (0, _defineProperty2.default)(_extends2, "&".concat(componentCls, "-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-content"), {
    flex: 1,
    minWidth: 0
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-icon"), {
    marginInlineEnd: marginXS,
    lineHeight: 0
  }), (0, _defineProperty2.default)(_extends2, "&-description", {
    display: 'none',
    fontSize: fontSize,
    lineHeight: lineHeight
  }), (0, _defineProperty2.default)(_extends2, '&-message', {
    color: colorText
  }), (0, _defineProperty2.default)(_extends2, "&".concat(componentCls, "-motion-leave"), {
    overflow: 'hidden',
    opacity: 1,
    transition: "max-height ".concat(duration, " ").concat(motionEaseInOutCirc, ", opacity ").concat(duration, " ").concat(motionEaseInOutCirc, ",\n        padding-top ").concat(duration, " ").concat(motionEaseInOutCirc, ", padding-bottom ").concat(duration, " ").concat(motionEaseInOutCirc, ",\n        margin-bottom ").concat(duration, " ").concat(motionEaseInOutCirc)
  }), (0, _defineProperty2.default)(_extends2, "&".concat(componentCls, "-motion-leave-active"), {
    maxHeight: 0,
    marginBottom: '0 !important',
    paddingTop: 0,
    paddingBottom: 0,
    opacity: 0
  }), _extends2))), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-with-description"), (_$concat = {
    alignItems: 'flex-start',
    paddingInline: paddingContentHorizontalLG,
    paddingBlock: paddingMD
  }, (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-icon"), {
    marginInlineEnd: marginSM,
    fontSize: alertIconSizeLG,
    lineHeight: 0
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-message"), {
    display: 'block',
    marginBottom: marginXS,
    color: colorText,
    fontSize: fontSizeLG
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-description"), {
    display: 'block'
  }), _$concat)), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-banner"), {
    marginBottom: 0,
    border: '0 !important',
    borderRadius: 0
  }), _ref2;
};
exports.genBaseStyle = genBaseStyle;
var genTypeStyle = function genTypeStyle(token) {
  var componentCls = token.componentCls,
    colorSuccess = token.colorSuccess,
    colorSuccessBorder = token.colorSuccessBorder,
    colorSuccessBg = token.colorSuccessBg,
    colorWarning = token.colorWarning,
    colorWarningBorder = token.colorWarningBorder,
    colorWarningBg = token.colorWarningBg,
    colorError = token.colorError,
    colorErrorBorder = token.colorErrorBorder,
    colorErrorBg = token.colorErrorBg,
    colorInfo = token.colorInfo,
    colorInfoBorder = token.colorInfoBorder,
    colorInfoBg = token.colorInfoBg;
  return (0, _defineProperty2.default)({}, componentCls, {
    '&-success': genAlertTypeStyle(colorSuccessBg, colorSuccessBorder, colorSuccess, token, componentCls),
    '&-info': genAlertTypeStyle(colorInfoBg, colorInfoBorder, colorInfo, token, componentCls),
    '&-warning': genAlertTypeStyle(colorWarningBg, colorWarningBorder, colorWarning, token, componentCls),
    '&-error': (0, _extends4.default)((0, _extends4.default)({}, genAlertTypeStyle(colorErrorBg, colorErrorBorder, colorError, token, componentCls)), (0, _defineProperty2.default)({}, "".concat(componentCls, "-description > pre"), {
      margin: 0,
      padding: 0
    }))
  });
};
exports.genTypeStyle = genTypeStyle;
var genActionStyle = function genActionStyle(token) {
  var _componentCls;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    motionDurationMid = token.motionDurationMid,
    marginXS = token.marginXS,
    fontSizeIcon = token.fontSizeIcon,
    colorIcon = token.colorIcon,
    colorIconHover = token.colorIconHover;
  return (0, _defineProperty2.default)({}, componentCls, (_componentCls = {}, (0, _defineProperty2.default)(_componentCls, "&-action", {
    marginInlineStart: marginXS
  }), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-close-icon"), (0, _defineProperty2.default)({
    marginInlineStart: marginXS,
    padding: 0,
    overflow: 'hidden',
    fontSize: fontSizeIcon,
    lineHeight: "".concat(fontSizeIcon, "px"),
    backgroundColor: 'transparent',
    border: 'none',
    outline: 'none',
    cursor: 'pointer'
  }, "".concat(iconCls, "-close"), {
    color: colorIcon,
    transition: "color ".concat(motionDurationMid),
    '&:hover': {
      color: colorIconHover
    }
  })), (0, _defineProperty2.default)(_componentCls, '&-close-text', {
    color: colorIcon,
    transition: "color ".concat(motionDurationMid),
    '&:hover': {
      color: colorIconHover
    }
  }), _componentCls));
};
exports.genActionStyle = genActionStyle;
var genAlertStyle = function genAlertStyle(token) {
  return [genBaseStyle(token), genTypeStyle(token), genActionStyle(token)];
};
exports.genAlertStyle = genAlertStyle;
var _default = (0, _internal.genComponentStyleHook)('Alert', function (token) {
  var fontSizeHeading3 = token.fontSizeHeading3;
  var alertToken = (0, _internal.mergeToken)(token, {
    alertIconSizeLG: fontSizeHeading3,
    alertPaddingHorizontal: 12 // Fixed value here.
  });

  return [genAlertStyle(alertToken)];
});
exports.default = _default;