"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.anchorProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _scrollIntoViewIfNeeded = _interopRequireDefault(require("scroll-into-view-if-needed"));
var _classNames4 = _interopRequireDefault(require("../_util/classNames"));
var _addEventListener = _interopRequireDefault(require("../vc-util/Dom/addEventListener"));
var _affix = _interopRequireDefault(require("../affix"));
var _scrollTo = _interopRequireDefault(require("../_util/scrollTo"));
var _getScroll = _interopRequireDefault(require("../_util/getScroll"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _context = _interopRequireDefault(require("./context"));
var _style = _interopRequireDefault(require("./style"));
var _AnchorLink = _interopRequireDefault(require("./AnchorLink"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _type = require("../_util/type");
function getDefaultContainer() {
  return window;
}
function getOffsetTop(element, container) {
  if (!element.getClientRects().length) {
    return 0;
  }
  var rect = element.getBoundingClientRect();
  if (rect.width || rect.height) {
    if (container === window) {
      container = element.ownerDocument.documentElement;
      return rect.top - container.clientTop;
    }
    return rect.top - container.getBoundingClientRect().top;
  }
  return rect.top;
}
var sharpMatcherRegx = /#([\S ]+)$/;
var anchorProps = function anchorProps() {
  return {
    prefixCls: String,
    offsetTop: Number,
    bounds: Number,
    affix: {
      type: Boolean,
      default: true
    },
    showInkInFixed: {
      type: Boolean,
      default: false
    },
    getContainer: Function,
    wrapperClass: String,
    wrapperStyle: {
      type: Object,
      default: undefined
    },
    getCurrentAnchor: Function,
    targetOffset: Number,
    items: (0, _type.arrayType)(),
    direction: _vueTypes.default.oneOf(['vertical', 'horizontal']).def('vertical'),
    onChange: Function,
    onClick: Function
  };
};
exports.anchorProps = anchorProps;
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AAnchor',
  inheritAttrs: false,
  props: anchorProps(),
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      attrs = _ref.attrs,
      slots = _ref.slots,
      expose = _ref.expose;
    var _a;
    var _useConfigInject = (0, _useConfigInject2.default)('anchor', props),
      prefixCls = _useConfigInject.prefixCls,
      getTargetContainer = _useConfigInject.getTargetContainer,
      direction = _useConfigInject.direction;
    var anchorDirection = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.direction) !== null && _a !== void 0 ? _a : 'vertical';
    });
    if (process.env.NODE_ENV !== 'production') {
      (0, _devWarning.default)(props.items && typeof slots.default !== 'function', 'Anchor', '`Anchor children` is deprecated. Please use `items` instead.');
    }
    if (process.env.NODE_ENV !== 'production') {
      (0, _devWarning.default)(!(anchorDirection.value === 'horizontal' && ((_a = props.items) === null || _a === void 0 ? void 0 : _a.some(function (n) {
        return 'children' in n;
      }))), 'Anchor', '`Anchor items#children` is not supported when `Anchor` direction is horizontal.');
    }
    var spanLinkNode = (0, _vue.ref)(null);
    var anchorRef = (0, _vue.ref)();
    var state = (0, _vue.reactive)({
      links: [],
      scrollContainer: null,
      scrollEvent: null,
      animating: false
    });
    var activeLink = (0, _vue.ref)(null);
    var getContainer = (0, _vue.computed)(function () {
      var getContainer = props.getContainer;
      return getContainer || (getTargetContainer === null || getTargetContainer === void 0 ? void 0 : getTargetContainer.value) || getDefaultContainer;
    });
    // func...
    var getCurrentAnchor = function getCurrentAnchor() {
      var offsetTop = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 0;
      var bounds = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 5;
      var linkSections = [];
      var container = getContainer.value();
      state.links.forEach(function (link) {
        var sharpLinkMatch = sharpMatcherRegx.exec(link.toString());
        if (!sharpLinkMatch) {
          return;
        }
        var target = document.getElementById(sharpLinkMatch[1]);
        if (target) {
          var top = getOffsetTop(target, container);
          if (top < offsetTop + bounds) {
            linkSections.push({
              link: link,
              top: top
            });
          }
        }
      });
      if (linkSections.length) {
        var maxSection = linkSections.reduce(function (prev, curr) {
          return curr.top > prev.top ? curr : prev;
        });
        return maxSection.link;
      }
      return '';
    };
    var setCurrentActiveLink = function setCurrentActiveLink(link) {
      var getCurrentAnchor = props.getCurrentAnchor;
      if (activeLink.value === link) {
        return;
      }
      activeLink.value = typeof getCurrentAnchor === 'function' ? getCurrentAnchor(link) : link;
      emit('change', link);
    };
    var handleScrollTo = function handleScrollTo(link) {
      var offsetTop = props.offsetTop,
        targetOffset = props.targetOffset;
      setCurrentActiveLink(link);
      var sharpLinkMatch = sharpMatcherRegx.exec(link);
      if (!sharpLinkMatch) {
        return;
      }
      var targetElement = document.getElementById(sharpLinkMatch[1]);
      if (!targetElement) {
        return;
      }
      var container = getContainer.value();
      var scrollTop = (0, _getScroll.default)(container, true);
      var eleOffsetTop = getOffsetTop(targetElement, container);
      var y = scrollTop + eleOffsetTop;
      y -= targetOffset !== undefined ? targetOffset : offsetTop || 0;
      state.animating = true;
      (0, _scrollTo.default)(y, {
        callback: function callback() {
          state.animating = false;
        },
        getContainer: getContainer.value
      });
    };
    expose({
      scrollTo: handleScrollTo
    });
    var handleScroll = function handleScroll() {
      if (state.animating) {
        return;
      }
      var offsetTop = props.offsetTop,
        bounds = props.bounds,
        targetOffset = props.targetOffset;
      var currentActiveLink = getCurrentAnchor(targetOffset !== undefined ? targetOffset : offsetTop || 0, bounds);
      setCurrentActiveLink(currentActiveLink);
    };
    var updateInk = function updateInk() {
      var linkNode = anchorRef.value.querySelector(".".concat(prefixCls.value, "-link-title-active"));
      if (linkNode && spanLinkNode.value) {
        var horizontalAnchor = anchorDirection.value === 'horizontal';
        spanLinkNode.value.style.top = horizontalAnchor ? '' : "".concat(linkNode.offsetTop + linkNode.clientHeight / 2, "px");
        spanLinkNode.value.style.height = horizontalAnchor ? '' : "".concat(linkNode.clientHeight, "px");
        spanLinkNode.value.style.left = horizontalAnchor ? "".concat(linkNode.offsetLeft, "px") : '';
        spanLinkNode.value.style.width = horizontalAnchor ? "".concat(linkNode.clientWidth, "px") : '';
        if (horizontalAnchor) {
          (0, _scrollIntoViewIfNeeded.default)(linkNode, {
            scrollMode: 'if-needed',
            block: 'nearest'
          });
        }
      }
    };
    (0, _context.default)({
      registerLink: function registerLink(link) {
        if (!state.links.includes(link)) {
          state.links.push(link);
        }
      },
      unregisterLink: function unregisterLink(link) {
        var index = state.links.indexOf(link);
        if (index !== -1) {
          state.links.splice(index, 1);
        }
      },
      activeLink: activeLink,
      scrollTo: handleScrollTo,
      handleClick: function handleClick(e, info) {
        emit('click', e, info);
      },
      direction: anchorDirection
    });
    (0, _vue.onMounted)(function () {
      (0, _vue.nextTick)(function () {
        var container = getContainer.value();
        state.scrollContainer = container;
        state.scrollEvent = (0, _addEventListener.default)(state.scrollContainer, 'scroll', handleScroll);
        handleScroll();
      });
    });
    (0, _vue.onBeforeUnmount)(function () {
      if (state.scrollEvent) {
        state.scrollEvent.remove();
      }
    });
    (0, _vue.onUpdated)(function () {
      if (state.scrollEvent) {
        var currentContainer = getContainer.value();
        if (state.scrollContainer !== currentContainer) {
          state.scrollContainer = currentContainer;
          state.scrollEvent.remove();
          state.scrollEvent = (0, _addEventListener.default)(state.scrollContainer, 'scroll', handleScroll);
          handleScroll();
        }
      }
      updateInk();
    });
    var createNestedLink = function createNestedLink(options) {
      return Array.isArray(options) ? options.map(function (option) {
        var children = option.children,
          key = option.key,
          href = option.href,
          target = option.target,
          cls = option.class,
          style = option.style,
          title = option.title;
        return (0, _vue.createVNode)(_AnchorLink.default, {
          "key": key,
          "href": href,
          "target": target,
          "class": cls,
          "style": style,
          "title": title,
          "customTitleProps": option
        }, {
          default: function _default() {
            return [anchorDirection.value === 'vertical' ? createNestedLink(children) : null];
          },
          customTitle: slots.customTitle
        });
      }) : null;
    };
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _classNames2;
      var _a;
      var offsetTop = props.offsetTop,
        affix = props.affix,
        showInkInFixed = props.showInkInFixed;
      var pre = prefixCls.value;
      var inkClass = (0, _classNames4.default)("".concat(pre, "-ink"), (0, _defineProperty2.default)({}, "".concat(pre, "-ink-visible"), activeLink.value));
      var wrapperClass = (0, _classNames4.default)(hashId.value, props.wrapperClass, "".concat(pre, "-wrapper"), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-wrapper-horizontal"), anchorDirection.value === 'horizontal'), (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _classNames2));
      var anchorClass = (0, _classNames4.default)(pre, (0, _defineProperty2.default)({}, "".concat(pre, "-fixed"), !affix && !showInkInFixed));
      var wrapperStyle = (0, _extends2.default)({
        maxHeight: offsetTop ? "calc(100vh - ".concat(offsetTop, "px)") : '100vh'
      }, props.wrapperStyle);
      var anchorContent = (0, _vue.createVNode)("div", {
        "class": wrapperClass,
        "style": wrapperStyle,
        "ref": anchorRef
      }, [(0, _vue.createVNode)("div", {
        "class": anchorClass
      }, [(0, _vue.createVNode)("span", {
        "class": inkClass,
        "ref": spanLinkNode
      }, null), Array.isArray(props.items) ? createNestedLink(props.items) : (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)])]);
      return wrapSSR(!affix ? anchorContent : (0, _vue.createVNode)(_affix.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "offsetTop": offsetTop,
        "target": getContainer.value
      }), {
        default: function _default() {
          return [anchorContent];
        }
      }));
    };
  }
});
exports.default = _default2;