"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useProviderSize = exports.useInjectSize = void 0;
var _vue = require("vue");
var SizeContextKey = Symbol('SizeContextKey');
var useInjectSize = function useInjectSize() {
  return (0, _vue.inject)(SizeContextKey, (0, _vue.ref)('default'));
};
exports.useInjectSize = useInjectSize;
var useProviderSize = function useProviderSize(size) {
  var parentSize = useInjectSize();
  (0, _vue.provide)(SizeContextKey, (0, _vue.computed)(function () {
    return size.value || parentSize.value;
  }));
  return size;
};
exports.useProviderSize = useProviderSize;