import type { GenerateConfig } from '../vc-picker/generate';
import type { PickerPanelBaseProps as RCPickerPanelBaseProps, PickerPanelDateProps as RCPickerPanelDateProps, PickerPanelTimeProps as RCPickerPanelTimeProps } from '../vc-picker/PickerPanel';
import enUS from './locale/en_US';
import type { VueNode } from '../_util/type';
type InjectDefaultProps<Props> = Omit<Props, 'locale' | 'generateConfig' | 'prevIcon' | 'nextIcon' | 'superPrevIcon' | 'superNextIcon'> & {
    locale?: typeof enUS;
    size?: 'large' | 'default' | 'small';
};
export type PickerPanelBaseProps<DateType> = InjectDefaultProps<RCPickerPanelBaseProps<DateType>>;
export type PickerPanelDateProps<DateType> = InjectDefaultProps<RCPickerPanelDateProps<DateType>>;
export type PickerPanelTimeProps<DateType> = InjectDefaultProps<RCPickerPanelTimeProps<DateType>>;
export type PickerProps<DateType> = PickerPanelBaseProps<DateType> | PickerPanelDateProps<DateType> | PickerPanelTimeProps<DateType>;
export type CalendarMode = 'year' | 'month';
export type HeaderRender<DateType> = (config: {
    value: DateType;
    type: CalendarMode;
    onChange: (date: DateType) => void;
    onTypeChange: (type: CalendarMode) => void;
}) => VueNode;
type CustomRenderType<DateType> = (config: {
    current: DateType;
}) => VueNode;
export interface CalendarProps<DateType> {
    prefixCls?: string;
    locale?: typeof enUS;
    validRange?: [DateType, DateType];
    disabledDate?: (date: DateType) => boolean;
    dateFullCellRender?: CustomRenderType<DateType>;
    dateCellRender?: CustomRenderType<DateType>;
    monthFullCellRender?: CustomRenderType<DateType>;
    monthCellRender?: CustomRenderType<DateType>;
    headerRender?: HeaderRender<DateType>;
    value?: DateType | string;
    defaultValue?: DateType | string;
    mode?: CalendarMode;
    fullscreen?: boolean;
    onChange?: (date: DateType | string) => void;
    'onUpdate:value'?: (date: DateType | string) => void;
    onPanelChange?: (date: DateType | string, mode: CalendarMode) => void;
    onSelect?: (date: DateType | string) => void;
    valueFormat?: string;
}
declare function generateCalendar<DateType, Props extends CalendarProps<DateType> = CalendarProps<DateType>>(generateConfig: GenerateConfig<DateType>): import("vue").DefineComponent<Props, {}, {}, {}, {}, import("vue").ComponentOptionsMixin, import("vue").ComponentOptionsMixin, {}, string, import("vue").VNodeProps & import("vue").AllowedComponentProps & import("vue").ComponentCustomProps, Readonly<Props extends import("vue").ComponentPropsOptions<{
    [x: string]: unknown;
}> ? import("vue").ExtractPropTypes<Props> : Props>, import("vue").ExtractDefaultPropTypes<Props>>;
export default generateCalendar;
