"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.cardProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _tabs = _interopRequireDefault(require("../tabs"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _propsUtil = require("../_util/props-util");
var _isPlainObject = _interopRequireDefault(require("lodash/isPlainObject"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var _style = _interopRequireDefault(require("./style"));
var _skeleton = _interopRequireDefault(require("../skeleton"));
var TabPane = _tabs.default.TabPane;
var cardProps = function cardProps() {
  return {
    prefixCls: String,
    title: _vueTypes.default.any,
    extra: _vueTypes.default.any,
    bordered: {
      type: Boolean,
      default: true
    },
    bodyStyle: {
      type: Object,
      default: undefined
    },
    headStyle: {
      type: Object,
      default: undefined
    },
    loading: {
      type: Boolean,
      default: false
    },
    hoverable: {
      type: Boolean,
      default: false
    },
    type: {
      type: String
    },
    size: {
      type: String
    },
    actions: _vueTypes.default.any,
    tabList: {
      type: Array
    },
    tabBarExtraContent: _vueTypes.default.any,
    activeTabKey: String,
    defaultActiveTabKey: String,
    cover: _vueTypes.default.any,
    onTabChange: {
      type: Function
    }
  };
};
exports.cardProps = cardProps;
var Card = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ACard',
  inheritAttrs: false,
  props: cardProps(),
  slots: ['title', 'extra', 'tabBarExtraContent', 'actions', 'cover', 'customTab'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('card', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var getAction = function getAction(actions) {
      var actionList = actions.map(function (action, index) {
        return (0, _vue.isVNode)(action) && !(0, _propsUtil.isEmptyElement)(action) || !(0, _vue.isVNode)(action) ? (0, _vue.createVNode)("li", {
          "style": {
            width: "".concat(100 / actions.length, "%")
          },
          "key": "action-".concat(index)
        }, [(0, _vue.createVNode)("span", null, [action])]) : null;
      });
      return actionList;
    };
    var triggerTabChange = function triggerTabChange(key) {
      var _a;
      (_a = props.onTabChange) === null || _a === void 0 ? void 0 : _a.call(props, key);
    };
    var isContainGrid = function isContainGrid() {
      var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var containGrid;
      obj.forEach(function (element) {
        if (element && (0, _isPlainObject.default)(element.type) && element.type.__ANT_CARD_GRID) {
          containGrid = true;
        }
      });
      return containGrid;
    };
    return function () {
      var _classString, _tabsProps;
      var _a, _b, _c, _d, _e, _f;
      var _props$headStyle = props.headStyle,
        headStyle = _props$headStyle === void 0 ? {} : _props$headStyle,
        _props$bodyStyle = props.bodyStyle,
        bodyStyle = _props$bodyStyle === void 0 ? {} : _props$bodyStyle,
        loading = props.loading,
        _props$bordered = props.bordered,
        bordered = _props$bordered === void 0 ? true : _props$bordered,
        type = props.type,
        tabList = props.tabList,
        hoverable = props.hoverable,
        activeTabKey = props.activeTabKey,
        defaultActiveTabKey = props.defaultActiveTabKey,
        _props$tabBarExtraCon = props.tabBarExtraContent,
        tabBarExtraContent = _props$tabBarExtraCon === void 0 ? (0, _propsUtil.filterEmptyWithUndefined)((_a = slots.tabBarExtraContent) === null || _a === void 0 ? void 0 : _a.call(slots)) : _props$tabBarExtraCon,
        _props$title = props.title,
        title = _props$title === void 0 ? (0, _propsUtil.filterEmptyWithUndefined)((_b = slots.title) === null || _b === void 0 ? void 0 : _b.call(slots)) : _props$title,
        _props$extra = props.extra,
        extra = _props$extra === void 0 ? (0, _propsUtil.filterEmptyWithUndefined)((_c = slots.extra) === null || _c === void 0 ? void 0 : _c.call(slots)) : _props$extra,
        _props$actions = props.actions,
        actions = _props$actions === void 0 ? (0, _propsUtil.filterEmptyWithUndefined)((_d = slots.actions) === null || _d === void 0 ? void 0 : _d.call(slots)) : _props$actions,
        _props$cover = props.cover,
        cover = _props$cover === void 0 ? (0, _propsUtil.filterEmptyWithUndefined)((_e = slots.cover) === null || _e === void 0 ? void 0 : _e.call(slots)) : _props$cover;
      var children = (0, _propsUtil.flattenChildren)((_f = slots.default) === null || _f === void 0 ? void 0 : _f.call(slots));
      var pre = prefixCls.value;
      var classString = (_classString = {}, (0, _defineProperty2.default)(_classString, "".concat(pre), true), (0, _defineProperty2.default)(_classString, hashId.value, true), (0, _defineProperty2.default)(_classString, "".concat(pre, "-loading"), loading), (0, _defineProperty2.default)(_classString, "".concat(pre, "-bordered"), bordered), (0, _defineProperty2.default)(_classString, "".concat(pre, "-hoverable"), !!hoverable), (0, _defineProperty2.default)(_classString, "".concat(pre, "-contain-grid"), isContainGrid(children)), (0, _defineProperty2.default)(_classString, "".concat(pre, "-contain-tabs"), tabList && tabList.length), (0, _defineProperty2.default)(_classString, "".concat(pre, "-").concat(size.value), size.value), (0, _defineProperty2.default)(_classString, "".concat(pre, "-type-").concat(type), !!type), (0, _defineProperty2.default)(_classString, "".concat(pre, "-rtl"), direction.value === 'rtl'), _classString);
      var loadingBlock = (0, _vue.createVNode)(_skeleton.default, {
        "loading": true,
        "active": true,
        "paragraph": {
          rows: 4
        },
        "title": false
      }, {
        default: function _default() {
          return [children];
        }
      });
      var hasActiveTabKey = activeTabKey !== undefined;
      var tabsProps = (_tabsProps = {
        size: 'large'
      }, (0, _defineProperty2.default)(_tabsProps, hasActiveTabKey ? 'activeKey' : 'defaultActiveKey', hasActiveTabKey ? activeTabKey : defaultActiveTabKey), (0, _defineProperty2.default)(_tabsProps, "onChange", triggerTabChange), (0, _defineProperty2.default)(_tabsProps, "class", "".concat(pre, "-head-tabs")), _tabsProps);
      var head;
      var tabs = tabList && tabList.length ? (0, _vue.createVNode)(_tabs.default, tabsProps, {
        default: function _default() {
          return [tabList.map(function (item) {
            var temp = item.tab,
              itemSlots = item.slots;
            var name = itemSlots === null || itemSlots === void 0 ? void 0 : itemSlots.tab;
            (0, _devWarning.default)(!itemSlots, 'Card', "tabList slots is deprecated, Please use `customTab` instead.");
            var tab = temp !== undefined ? temp : slots[name] ? slots[name](item) : null;
            tab = (0, _vue.renderSlot)(slots, 'customTab', item, function () {
              return [tab];
            });
            return (0, _vue.createVNode)(TabPane, {
              "tab": tab,
              "key": item.key,
              "disabled": item.disabled
            }, null);
          })];
        },
        rightExtra: tabBarExtraContent ? function () {
          return tabBarExtraContent;
        } : null
      }) : null;
      if (title || extra || tabs) {
        head = (0, _vue.createVNode)("div", {
          "class": "".concat(pre, "-head"),
          "style": headStyle
        }, [(0, _vue.createVNode)("div", {
          "class": "".concat(pre, "-head-wrapper")
        }, [title && (0, _vue.createVNode)("div", {
          "class": "".concat(pre, "-head-title")
        }, [title]), extra && (0, _vue.createVNode)("div", {
          "class": "".concat(pre, "-extra")
        }, [extra])]), tabs]);
      }
      var coverDom = cover ? (0, _vue.createVNode)("div", {
        "class": "".concat(pre, "-cover")
      }, [cover]) : null;
      var body = (0, _vue.createVNode)("div", {
        "class": "".concat(pre, "-body"),
        "style": bodyStyle
      }, [loading ? loadingBlock : children]);
      var actionDom = actions && actions.length ? (0, _vue.createVNode)("ul", {
        "class": "".concat(pre, "-actions")
      }, [getAction(actions)]) : null;
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({
        "ref": "cardContainerRef"
      }, attrs), {}, {
        "class": [classString, attrs.class]
      }), [head, coverDom, children && children.length ? body : null, actionDom]));
    };
  }
});
var _default2 = Card;
exports.default = _default2;