"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.genBaseStyle = exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var genBaseStyle = function genBaseStyle(token) {
  var _$concat, _$concat2, _$concat5, _$concat6, _extends2;
  var componentCls = token.componentCls,
    collapseContentBg = token.collapseContentBg,
    padding = token.padding,
    collapseContentPaddingHorizontal = token.collapseContentPaddingHorizontal,
    collapseHeaderBg = token.collapseHeaderBg,
    collapseHeaderPadding = token.collapseHeaderPadding,
    collapsePanelBorderRadius = token.collapsePanelBorderRadius,
    lineWidth = token.lineWidth,
    lineType = token.lineType,
    colorBorder = token.colorBorder,
    colorText = token.colorText,
    colorTextHeading = token.colorTextHeading,
    colorTextDisabled = token.colorTextDisabled,
    fontSize = token.fontSize,
    lineHeight = token.lineHeight,
    marginSM = token.marginSM,
    paddingSM = token.paddingSM,
    motionDurationSlow = token.motionDurationSlow,
    fontSizeIcon = token.fontSizeIcon;
  var borderBase = "".concat(lineWidth, "px ").concat(lineType, " ").concat(colorBorder);
  return (0, _defineProperty2.default)({}, componentCls, (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    backgroundColor: collapseHeaderBg,
    border: borderBase,
    borderBottom: 0,
    borderRadius: "".concat(collapsePanelBorderRadius, "px")
  }, (0, _defineProperty2.default)(_extends2, "&-rtl", {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends2, "& > ".concat(componentCls, "-item"), (_$concat5 = {
    borderBottom: borderBase
  }, (0, _defineProperty2.default)(_$concat5, "&:last-child", (0, _defineProperty2.default)({}, "\n            &,\n            & > ".concat(componentCls, "-header"), {
    borderRadius: "0 0 ".concat(collapsePanelBorderRadius, "px ").concat(collapsePanelBorderRadius, "px")
  })), (0, _defineProperty2.default)(_$concat5, "> ".concat(componentCls, "-header"), (_$concat = {
    position: 'relative',
    display: 'flex',
    flexWrap: 'nowrap',
    alignItems: 'flex-start',
    padding: collapseHeaderPadding,
    color: colorTextHeading,
    lineHeight: lineHeight,
    cursor: 'pointer',
    transition: "all ".concat(motionDurationSlow, ", visibility 0s")
  }, (0, _defineProperty2.default)(_$concat, "> ".concat(componentCls, "-header-text"), {
    flex: 'auto'
  }), (0, _defineProperty2.default)(_$concat, '&:focus', {
    outline: 'none'
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-expand-icon"), {
    height: fontSize * lineHeight,
    display: 'flex',
    alignItems: 'center',
    paddingInlineEnd: marginSM
  }), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-arrow"), (0, _extends3.default)((0, _extends3.default)({}, (0, _style.resetIcon)()), {
    fontSize: fontSizeIcon,
    svg: {
      transition: "transform ".concat(motionDurationSlow)
    }
  })), (0, _defineProperty2.default)(_$concat, "".concat(componentCls, "-header-text"), {
    marginInlineEnd: 'auto'
  }), _$concat)), (0, _defineProperty2.default)(_$concat5, "".concat(componentCls, "-header-collapsible-only"), (_$concat2 = {
    cursor: 'default'
  }, (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-header-text"), {
    flex: 'none',
    cursor: 'pointer'
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-expand-icon"), {
    cursor: 'pointer'
  }), _$concat2)), (0, _defineProperty2.default)(_$concat5, "".concat(componentCls, "-icon-collapsible-only"), (0, _defineProperty2.default)({
    cursor: 'default'
  }, "".concat(componentCls, "-expand-icon"), {
    cursor: 'pointer'
  })), (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-no-arrow"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-header"), {
    paddingInlineStart: paddingSM
  })), _$concat5)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-content"), (_$concat6 = {
    color: colorText,
    backgroundColor: collapseContentBg,
    borderTop: borderBase
  }, (0, _defineProperty2.default)(_$concat6, "& > ".concat(componentCls, "-content-box"), {
    padding: "".concat(padding, "px ").concat(collapseContentPaddingHorizontal, "px")
  }), (0, _defineProperty2.default)(_$concat6, "&-hidden", {
    display: 'none'
  }), _$concat6)), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item:last-child"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-content"), {
    borderRadius: "0 0 ".concat(collapsePanelBorderRadius, "px ").concat(collapsePanelBorderRadius, "px")
  })), (0, _defineProperty2.default)(_extends2, "& ".concat(componentCls, "-item-disabled > ").concat(componentCls, "-header"), (0, _defineProperty2.default)({}, "\n          &,\n          & > .arrow\n        ", {
    color: colorTextDisabled,
    cursor: 'not-allowed'
  })), (0, _defineProperty2.default)(_extends2, "&".concat(componentCls, "-icon-position-end"), (0, _defineProperty2.default)({}, "& > ".concat(componentCls, "-item"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-header"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-expand-icon"), {
    order: 1,
    paddingInlineEnd: 0,
    paddingInlineStart: marginSM
  })))), _extends2)));
};
exports.genBaseStyle = genBaseStyle;
var genArrowStyle = function genArrowStyle(token) {
  var componentCls = token.componentCls;
  var fixedSelector = "> ".concat(componentCls, "-item > ").concat(componentCls, "-header ").concat(componentCls, "-arrow svg");
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-rtl"), (0, _defineProperty2.default)({}, fixedSelector, {
    transform: "rotate(180deg)"
  }));
};
var genBorderlessStyle = function genBorderlessStyle(token) {
  var _$concat12;
  var componentCls = token.componentCls,
    collapseHeaderBg = token.collapseHeaderBg,
    paddingXXS = token.paddingXXS,
    colorBorder = token.colorBorder;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-borderless"), (_$concat12 = {
    backgroundColor: collapseHeaderBg,
    border: 0
  }, (0, _defineProperty2.default)(_$concat12, "> ".concat(componentCls, "-item"), {
    borderBottom: "1px solid ".concat(colorBorder)
  }), (0, _defineProperty2.default)(_$concat12, "\n        > ".concat(componentCls, "-item:last-child,\n        > ").concat(componentCls, "-item:last-child ").concat(componentCls, "-header\n      "), {
    borderRadius: 0
  }), (0, _defineProperty2.default)(_$concat12, "> ".concat(componentCls, "-item:last-child"), {
    borderBottom: 0
  }), (0, _defineProperty2.default)(_$concat12, "> ".concat(componentCls, "-item > ").concat(componentCls, "-content"), {
    backgroundColor: 'transparent',
    borderTop: 0
  }), (0, _defineProperty2.default)(_$concat12, "> ".concat(componentCls, "-item > ").concat(componentCls, "-content > ").concat(componentCls, "-content-box"), {
    paddingTop: paddingXXS
  }), _$concat12));
};
var genGhostStyle = function genGhostStyle(token) {
  var componentCls = token.componentCls,
    paddingSM = token.paddingSM;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-ghost"), (0, _defineProperty2.default)({
    backgroundColor: 'transparent',
    border: 0
  }, "> ".concat(componentCls, "-item"), (0, _defineProperty2.default)({
    borderBottom: 0
  }, "> ".concat(componentCls, "-content"), (0, _defineProperty2.default)({
    backgroundColor: 'transparent',
    border: 0
  }, "> ".concat(componentCls, "-content-box"), {
    paddingBlock: paddingSM
  }))));
};
var _default = (0, _internal.genComponentStyleHook)('Collapse', function (token) {
  var collapseToken = (0, _internal.mergeToken)(token, {
    collapseContentBg: token.colorBgContainer,
    collapseHeaderBg: token.colorFillAlter,
    collapseHeaderPadding: "".concat(token.paddingSM, "px ").concat(token.padding, "px"),
    collapsePanelBorderRadius: token.borderRadiusLG,
    collapseContentPaddingHorizontal: 16 // Fixed value
  });

  return [genBaseStyle(collapseToken), genBorderlessStyle(collapseToken), genGhostStyle(collapseToken), genArrowStyle(collapseToken), (0, _motion.genCollapseMotion)(collapseToken)];
});
exports.default = _default;