"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.configConsumerProps = void 0;
Object.defineProperty(exports, "defaultIconPrefixCls", {
  enumerable: true,
  get: function get() {
    return _context.defaultIconPrefixCls;
  }
});
exports.globalConfigForApi = exports.globalConfig = exports.defaultPrefixCls = void 0;
var _vue = require("vue");
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _renderEmpty = _interopRequireDefault(require("./renderEmpty"));
var _localeProvider = _interopRequireWildcard(require("../locale-provider"));
var _LocaleReceiver = _interopRequireDefault(require("../locale-provider/LocaleReceiver"));
var _message = _interopRequireDefault(require("../message"));
var _notification = _interopRequireDefault(require("../notification"));
var _cssVariables = require("./cssVariables");
var _en_US = _interopRequireDefault(require("../locale/en_US"));
var _style = _interopRequireDefault(require("./style"));
var _useTheme = _interopRequireDefault(require("./hooks/useTheme"));
var _seed = _interopRequireDefault(require("../theme/themes/seed"));
var _context = require("./context");
var _SizeContext = require("./SizeContext");
var _DisabledContext = require("./DisabledContext");
var _cssinjs = require("../_util/cssinjs");
var _internal = require("../theme/internal");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var defaultPrefixCls = 'ant';
exports.defaultPrefixCls = defaultPrefixCls;
function getGlobalPrefixCls() {
  return globalConfigForApi.prefixCls || defaultPrefixCls;
}
function getGlobalIconPrefixCls() {
  return globalConfigForApi.iconPrefixCls || _context.defaultIconPrefixCls;
}
var globalConfigBySet = (0, _vue.reactive)({}); // 权重最大
var globalConfigForApi = (0, _vue.reactive)({});
exports.globalConfigForApi = globalConfigForApi;
var configConsumerProps = ['getTargetContainer', 'getPopupContainer', 'rootPrefixCls', 'getPrefixCls', 'renderEmpty', 'csp', 'autoInsertSpaceInButton', 'locale', 'pageHeader'];
exports.configConsumerProps = configConsumerProps;
(0, _vue.watchEffect)(function () {
  (0, _extends2.default)(globalConfigForApi, globalConfigBySet);
  globalConfigForApi.prefixCls = getGlobalPrefixCls();
  globalConfigForApi.iconPrefixCls = getGlobalIconPrefixCls();
  globalConfigForApi.getPrefixCls = function (suffixCls, customizePrefixCls) {
    if (customizePrefixCls) return customizePrefixCls;
    return suffixCls ? "".concat(globalConfigForApi.prefixCls, "-").concat(suffixCls) : globalConfigForApi.prefixCls;
  };
  globalConfigForApi.getRootPrefixCls = function () {
    // If Global prefixCls provided, use this
    if (globalConfigForApi.prefixCls) {
      return globalConfigForApi.prefixCls;
    }
    // Fallback to default prefixCls
    return getGlobalPrefixCls();
  };
});
var stopWatchEffect;
var setGlobalConfig = function setGlobalConfig(params) {
  if (stopWatchEffect) {
    stopWatchEffect();
  }
  stopWatchEffect = (0, _vue.watchEffect)(function () {
    (0, _extends2.default)(globalConfigBySet, (0, _vue.reactive)(params));
    (0, _extends2.default)(globalConfigForApi, (0, _vue.reactive)(params));
  });
  if (params.theme) {
    (0, _cssVariables.registerTheme)(getGlobalPrefixCls(), params.theme);
  }
};
var globalConfig = function globalConfig() {
  return {
    getPrefixCls: function getPrefixCls(suffixCls, customizePrefixCls) {
      if (customizePrefixCls) return customizePrefixCls;
      return suffixCls ? "".concat(getGlobalPrefixCls(), "-").concat(suffixCls) : getGlobalPrefixCls();
    },
    getIconPrefixCls: getGlobalIconPrefixCls,
    getRootPrefixCls: function getRootPrefixCls() {
      // If Global prefixCls provided, use this
      if (globalConfigForApi.prefixCls) {
        return globalConfigForApi.prefixCls;
      }
      // Fallback to default prefixCls
      return getGlobalPrefixCls();
    }
  };
};
exports.globalConfig = globalConfig;
var ConfigProvider = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AConfigProvider',
  inheritAttrs: false,
  props: (0, _context.configProviderProps)(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots;
    var parentContext = (0, _context.useConfigContextInject)();
    var getPrefixCls = function getPrefixCls(suffixCls, customizePrefixCls) {
      var _props$prefixCls = props.prefixCls,
        prefixCls = _props$prefixCls === void 0 ? 'ant' : _props$prefixCls;
      if (customizePrefixCls) return customizePrefixCls;
      var mergedPrefixCls = prefixCls || parentContext.getPrefixCls('');
      return suffixCls ? "".concat(mergedPrefixCls, "-").concat(suffixCls) : mergedPrefixCls;
    };
    var iconPrefixCls = (0, _vue.computed)(function () {
      return props.iconPrefixCls || parentContext.iconPrefixCls.value || _context.defaultIconPrefixCls;
    });
    var shouldWrapSSR = (0, _vue.computed)(function () {
      return iconPrefixCls.value !== parentContext.iconPrefixCls.value;
    });
    var csp = (0, _vue.computed)(function () {
      var _a;
      return props.csp || ((_a = parentContext.csp) === null || _a === void 0 ? void 0 : _a.value);
    });
    var wrapSSR = (0, _style.default)(iconPrefixCls);
    var mergedTheme = (0, _useTheme.default)((0, _vue.computed)(function () {
      return props.theme;
    }), (0, _vue.computed)(function () {
      var _a;
      return (_a = parentContext.theme) === null || _a === void 0 ? void 0 : _a.value;
    }));
    var renderEmptyComponent = function renderEmptyComponent(name) {
      var renderEmpty = props.renderEmpty || slots.renderEmpty || parentContext.renderEmpty || _renderEmpty.default;
      return renderEmpty(name);
    };
    var autoInsertSpaceInButton = (0, _vue.computed)(function () {
      var _a, _b;
      return (_a = props.autoInsertSpaceInButton) !== null && _a !== void 0 ? _a : (_b = parentContext.autoInsertSpaceInButton) === null || _b === void 0 ? void 0 : _b.value;
    });
    var locale = (0, _vue.computed)(function () {
      var _a;
      return props.locale || ((_a = parentContext.locale) === null || _a === void 0 ? void 0 : _a.value);
    });
    (0, _vue.watch)(locale, function () {
      globalConfigBySet.locale = locale.value;
    }, {
      immediate: true
    });
    var direction = (0, _vue.computed)(function () {
      var _a;
      return props.direction || ((_a = parentContext.direction) === null || _a === void 0 ? void 0 : _a.value);
    });
    var space = (0, _vue.computed)(function () {
      var _a, _b;
      return (_a = props.space) !== null && _a !== void 0 ? _a : (_b = parentContext.space) === null || _b === void 0 ? void 0 : _b.value;
    });
    var virtual = (0, _vue.computed)(function () {
      var _a, _b;
      return (_a = props.virtual) !== null && _a !== void 0 ? _a : (_b = parentContext.virtual) === null || _b === void 0 ? void 0 : _b.value;
    });
    var dropdownMatchSelectWidth = (0, _vue.computed)(function () {
      var _a, _b;
      return (_a = props.dropdownMatchSelectWidth) !== null && _a !== void 0 ? _a : (_b = parentContext.dropdownMatchSelectWidth) === null || _b === void 0 ? void 0 : _b.value;
    });
    var getTargetContainer = (0, _vue.computed)(function () {
      var _a;
      return props.getTargetContainer !== undefined ? props.getTargetContainer : (_a = parentContext.getTargetContainer) === null || _a === void 0 ? void 0 : _a.value;
    });
    var getPopupContainer = (0, _vue.computed)(function () {
      var _a;
      return props.getPopupContainer !== undefined ? props.getPopupContainer : (_a = parentContext.getPopupContainer) === null || _a === void 0 ? void 0 : _a.value;
    });
    var pageHeader = (0, _vue.computed)(function () {
      var _a;
      return props.pageHeader !== undefined ? props.pageHeader : (_a = parentContext.pageHeader) === null || _a === void 0 ? void 0 : _a.value;
    });
    var input = (0, _vue.computed)(function () {
      var _a;
      return props.input !== undefined ? props.input : (_a = parentContext.input) === null || _a === void 0 ? void 0 : _a.value;
    });
    var pagination = (0, _vue.computed)(function () {
      var _a;
      return props.pagination !== undefined ? props.pagination : (_a = parentContext.pagination) === null || _a === void 0 ? void 0 : _a.value;
    });
    var form = (0, _vue.computed)(function () {
      var _a;
      return props.form !== undefined ? props.form : (_a = parentContext.form) === null || _a === void 0 ? void 0 : _a.value;
    });
    var select = (0, _vue.computed)(function () {
      var _a;
      return props.select !== undefined ? props.select : (_a = parentContext.select) === null || _a === void 0 ? void 0 : _a.value;
    });
    var componentSize = (0, _vue.computed)(function () {
      return props.componentSize;
    });
    var componentDisabled = (0, _vue.computed)(function () {
      return props.componentDisabled;
    });
    var configProvider = {
      csp: csp,
      autoInsertSpaceInButton: autoInsertSpaceInButton,
      locale: locale,
      direction: direction,
      space: space,
      virtual: virtual,
      dropdownMatchSelectWidth: dropdownMatchSelectWidth,
      getPrefixCls: getPrefixCls,
      iconPrefixCls: iconPrefixCls,
      theme: (0, _vue.computed)(function () {
        var _a, _b;
        return (_a = mergedTheme.value) !== null && _a !== void 0 ? _a : (_b = parentContext.theme) === null || _b === void 0 ? void 0 : _b.value;
      }),
      renderEmpty: renderEmptyComponent,
      getTargetContainer: getTargetContainer,
      getPopupContainer: getPopupContainer,
      pageHeader: pageHeader,
      input: input,
      pagination: pagination,
      form: form,
      select: select,
      componentSize: componentSize,
      componentDisabled: componentDisabled,
      transformCellText: (0, _vue.computed)(function () {
        return props.transformCellText;
      })
    };
    // ================================ Dynamic theme ================================
    var memoTheme = (0, _vue.computed)(function () {
      var _a = mergedTheme.value || {},
        algorithm = _a.algorithm,
        token = _a.token,
        rest = __rest(_a, ["algorithm", "token"]);
      var themeObj = algorithm && (!Array.isArray(algorithm) || algorithm.length > 0) ? (0, _cssinjs.createTheme)(algorithm) : undefined;
      return (0, _extends2.default)((0, _extends2.default)({}, rest), {
        theme: themeObj,
        token: (0, _extends2.default)((0, _extends2.default)({}, _seed.default), token)
      });
    });
    var validateMessagesRef = (0, _vue.computed)(function () {
      var _a, _b;
      // Additional Form provider
      var validateMessages = {};
      if (locale.value) {
        validateMessages = ((_a = locale.value.Form) === null || _a === void 0 ? void 0 : _a.defaultValidateMessages) || ((_b = _en_US.default.Form) === null || _b === void 0 ? void 0 : _b.defaultValidateMessages) || {};
      }
      if (props.form && props.form.validateMessages) {
        validateMessages = (0, _extends2.default)((0, _extends2.default)({}, validateMessages), props.form.validateMessages);
      }
      return validateMessages;
    });
    (0, _context.useConfigContextProvider)(configProvider);
    (0, _context.useProvideGlobalForm)({
      validateMessages: validateMessagesRef
    });
    (0, _SizeContext.useProviderSize)(componentSize);
    (0, _DisabledContext.useProviderDisabled)(componentDisabled);
    var renderProvider = function renderProvider(legacyLocale) {
      var _a, _b;
      var childNode = shouldWrapSSR.value ? wrapSSR((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) : (_b = slots.default) === null || _b === void 0 ? void 0 : _b.call(slots);
      if (props.theme) {
        var _childNode = function () {
          return childNode;
        }();
        childNode = (0, _vue.createVNode)(_internal.DesignTokenProvider, {
          "value": memoTheme.value
        }, {
          default: function _default() {
            return [_childNode];
          }
        });
      }
      return (0, _vue.createVNode)(_localeProvider.default, {
        "locale": locale.value || legacyLocale,
        "ANT_MARK__": _localeProvider.ANT_MARK
      }, {
        default: function _default() {
          return [childNode];
        }
      });
    };
    (0, _vue.watchEffect)(function () {
      if (direction.value) {
        _message.default.config({
          rtl: direction.value === 'rtl'
        });
        _notification.default.config({
          rtl: direction.value === 'rtl'
        });
      }
    });
    return function () {
      return (0, _vue.createVNode)(_LocaleReceiver.default, {
        "children": function children(_, __, legacyLocale) {
          return renderProvider(legacyLocale);
        }
      }, null);
    };
  }
});
ConfigProvider.install = function (app) {
  app.component(ConfigProvider.name, ConfigProvider);
};
var _default2 = ConfigProvider;
exports.default = _default2;