"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.dividerProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _propsUtil = require("../_util/props-util");
var _type = require("../_util/type");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
var dividerProps = function dividerProps() {
  return {
    prefixCls: String,
    type: {
      type: String,
      default: 'horizontal'
    },
    dashed: {
      type: Boolean,
      default: false
    },
    orientation: {
      type: String,
      default: 'center'
    },
    plain: {
      type: Boolean,
      default: false
    },
    orientationMargin: [String, Number]
  };
};
exports.dividerProps = dividerProps;
var Divider = (0, _vue.defineComponent)({
  name: 'ADivider',
  inheritAttrs: false,
  compatConfig: {
    MODE: 3
  },
  props: dividerProps(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('divider', props),
      prefixClsRef = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixClsRef),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var hasCustomMarginLeft = (0, _vue.computed)(function () {
      return props.orientation === 'left' && props.orientationMargin != null;
    });
    var hasCustomMarginRight = (0, _vue.computed)(function () {
      return props.orientation === 'right' && props.orientationMargin != null;
    });
    var classString = (0, _vue.computed)(function () {
      var _ref2;
      var type = props.type,
        dashed = props.dashed,
        plain = props.plain;
      var prefixCls = prefixClsRef.value;
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, prefixCls, true), (0, _defineProperty2.default)(_ref2, hashId.value, !!hashId.value), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls, "-").concat(type), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls, "-dashed"), !!dashed), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls, "-plain"), !!plain), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls, "-no-default-orientation-margin-left"), hasCustomMarginLeft.value), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls, "-no-default-orientation-margin-right"), hasCustomMarginRight.value), _ref2;
    });
    var innerStyle = (0, _vue.computed)(function () {
      var marginValue = typeof props.orientationMargin === 'number' ? "".concat(props.orientationMargin, "px") : props.orientationMargin;
      return (0, _extends2.default)((0, _extends2.default)({}, hasCustomMarginLeft.value && {
        marginLeft: marginValue
      }), hasCustomMarginRight.value && {
        marginRight: marginValue
      });
    });
    var orientationPrefix = (0, _vue.computed)(function () {
      return props.orientation.length > 0 ? '-' + props.orientation : props.orientation;
    });
    return function () {
      var _a;
      var children = (0, _propsUtil.flattenChildren)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": [classString.value, children.length ? "".concat(prefixClsRef.value, "-with-text ").concat(prefixClsRef.value, "-with-text").concat(orientationPrefix.value) : '', attrs.class],
        "role": "separator"
      }), [children.length ? (0, _vue.createVNode)("span", {
        "class": "".concat(prefixClsRef.value, "-inner-text"),
        "style": innerStyle.value
      }, [children]) : null]));
    };
  }
});
var _default = (0, _type.withInstall)(Divider);
exports.default = _default;