"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.emptyProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _LocaleReceiver = _interopRequireDefault(require("../locale-provider/LocaleReceiver"));
var _empty = _interopRequireDefault(require("./empty"));
var _simple = _interopRequireDefault(require("./simple"));
var _propsUtil = require("../_util/props-util");
var _type = require("../_util/type");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
var defaultEmptyImg = (0, _vue.createVNode)(_empty.default, null, null);
var simpleEmptyImg = (0, _vue.createVNode)(_simple.default, null, null);
var emptyProps = function emptyProps() {
  return {
    prefixCls: String,
    imageStyle: (0, _type.objectType)(),
    image: (0, _type.anyType)(),
    description: (0, _type.anyType)()
  };
};
exports.emptyProps = emptyProps;
var Empty = (0, _vue.defineComponent)({
  name: 'AEmpty',
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: false,
  props: emptyProps(),
  setup: function setup(props, _ref) {
    var _ref$slots = _ref.slots,
      slots = _ref$slots === void 0 ? {} : _ref$slots,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('empty', props),
      direction = _useConfigInject.direction,
      prefixClsRef = _useConfigInject.prefixCls;
    var _useStyle = (0, _style.default)(prefixClsRef),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    return function () {
      var _a, _b;
      var prefixCls = prefixClsRef.value;
      var _c = (0, _extends2.default)((0, _extends2.default)({}, props), attrs),
        _c$image = _c.image,
        image = _c$image === void 0 ? ((_a = slots.image) === null || _a === void 0 ? void 0 : _a.call(slots)) || defaultEmptyImg : _c$image,
        _c$description = _c.description,
        description = _c$description === void 0 ? ((_b = slots.description) === null || _b === void 0 ? void 0 : _b.call(slots)) || undefined : _c$description,
        imageStyle = _c.imageStyle,
        _c$class = _c.class,
        className = _c$class === void 0 ? '' : _c$class,
        restProps = __rest(_c, ["image", "description", "imageStyle", "class"]);
      return wrapSSR((0, _vue.createVNode)(_LocaleReceiver.default, {
        "componentName": "Empty",
        "children": function children(locale) {
          var _classNames;
          var des = typeof description !== 'undefined' ? description : locale.description;
          var alt = typeof des === 'string' ? des : 'empty';
          var imageNode = null;
          if (typeof image === 'string') {
            imageNode = (0, _vue.createVNode)("img", {
              "alt": alt,
              "src": image
            }, null);
          } else {
            imageNode = image;
          }
          return (0, _vue.createVNode)("div", (0, _objectSpread2.default)({
            "class": (0, _classNames2.default)(prefixCls, className, hashId.value, (_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-normal"), image === simpleEmptyImg), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls, "-rtl"), direction.value === 'rtl'), _classNames))
          }, restProps), [(0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls, "-image"),
            "style": imageStyle
          }, [imageNode]), des && (0, _vue.createVNode)("p", {
            "class": "".concat(prefixCls, "-description")
          }, [des]), slots.default && (0, _vue.createVNode)("div", {
            "class": "".concat(prefixCls, "-footer")
          }, [(0, _propsUtil.filterEmpty)(slots.default())])]);
        }
      }, null));
    };
  }
});
Empty.PRESENTED_IMAGE_DEFAULT = defaultEmptyImg;
Empty.PRESENTED_IMAGE_SIMPLE = simpleEmptyImg;
var _default = (0, _type.withInstall)(Empty);
exports.default = _default;