"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _VerticalAlignTopOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/VerticalAlignTopOutlined"));
var _transition = require("../_util/transition");
var _FloatButton = _interopRequireWildcard(require("./FloatButton"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _getScroll = _interopRequireDefault(require("../_util/getScroll"));
var _scrollTo = _interopRequireDefault(require("../_util/scrollTo"));
var _throttleByAnimationFrame = _interopRequireDefault(require("../_util/throttleByAnimationFrame"));
var _propsUtil = require("../_util/props-util");
var _interface = require("./interface");
var _style = _interopRequireDefault(require("./style"));
var _context = require("./context");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var BackTop = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'ABackTop',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)((0, _interface.backTopProps)(), {
    visibilityHeight: 400,
    target: function target() {
      return window;
    },
    duration: 450,
    type: 'default',
    shape: 'circle'
  }),
  // emits: ['click'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      emit = _ref.emit;
    var _useConfigInject = (0, _useConfigInject2.default)(_FloatButton.floatButtonPrefixCls, props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 1),
      wrapSSR = _useStyle2[0];
    var domRef = (0, _vue.ref)();
    var state = (0, _vue.reactive)({
      visible: props.visibilityHeight === 0,
      scrollEvent: null
    });
    var getDefaultTarget = function getDefaultTarget() {
      return domRef.value && domRef.value.ownerDocument ? domRef.value.ownerDocument : window;
    };
    var scrollToTop = function scrollToTop(e) {
      var _props$target = props.target,
        target = _props$target === void 0 ? getDefaultTarget : _props$target,
        duration = props.duration;
      (0, _scrollTo.default)(0, {
        getContainer: target,
        duration: duration
      });
      emit('click', e);
    };
    var handleScroll = (0, _throttleByAnimationFrame.default)(function (e) {
      var visibilityHeight = props.visibilityHeight;
      var scrollTop = (0, _getScroll.default)(e.target, true);
      state.visible = scrollTop >= visibilityHeight;
    });
    var bindScrollEvent = function bindScrollEvent() {
      var target = props.target;
      var getTarget = target || getDefaultTarget;
      var container = getTarget();
      handleScroll({
        target: container
      });
      container === null || container === void 0 ? void 0 : container.addEventListener('scroll', handleScroll);
    };
    var scrollRemove = function scrollRemove() {
      var target = props.target;
      var getTarget = target || getDefaultTarget;
      var container = getTarget();
      handleScroll.cancel();
      container === null || container === void 0 ? void 0 : container.removeEventListener('scroll', handleScroll);
    };
    (0, _vue.watch)(function () {
      return props.target;
    }, function () {
      scrollRemove();
      (0, _vue.nextTick)(function () {
        bindScrollEvent();
      });
    });
    (0, _vue.onMounted)(function () {
      (0, _vue.nextTick)(function () {
        bindScrollEvent();
      });
    });
    (0, _vue.onActivated)(function () {
      (0, _vue.nextTick)(function () {
        bindScrollEvent();
      });
    });
    (0, _vue.onDeactivated)(function () {
      scrollRemove();
    });
    (0, _vue.onBeforeUnmount)(function () {
      scrollRemove();
    });
    var floatButtonGroupContext = (0, _context.useInjectFloatButtonGroupContext)();
    return function () {
      var _class;
      var defaultElement = (0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-content")
      }, [(0, _vue.createVNode)("div", {
        "class": "".concat(prefixCls.value, "-icon")
      }, [(0, _vue.createVNode)(_VerticalAlignTopOutlined.default, null, null)])]);
      var floatButtonProps = (0, _extends2.default)((0, _extends2.default)({}, attrs), {
        shape: (floatButtonGroupContext === null || floatButtonGroupContext === void 0 ? void 0 : floatButtonGroupContext.shape.value) || props.shape,
        onClick: scrollToTop,
        class: (_class = {}, (0, _defineProperty2.default)(_class, "".concat(prefixCls.value), true), (0, _defineProperty2.default)(_class, "".concat(attrs.class), attrs.class), (0, _defineProperty2.default)(_class, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _class)
      });
      var transitionProps = (0, _transition.getTransitionProps)('fade');
      return wrapSSR((0, _vue.createVNode)(_transition.Transition, transitionProps, {
        default: function _default() {
          return [(0, _vue.withDirectives)((0, _vue.createVNode)(_FloatButton.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, floatButtonProps), {}, {
            "ref": domRef
          }), {
            icon: function icon() {
              return (0, _vue.createVNode)(_VerticalAlignTopOutlined.default, null, null);
            },
            default: function _default() {
              var _a;
              return ((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || defaultElement;
            }
          }), [[_vue.vShow, state.visible]])];
        }
      }));
    };
  }
});
var _default2 = BackTop;
exports.default = _default2;