"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _cssinjs = require("../../_util/cssinjs");
var _internal = require("../../theme/internal");
var _fade = require("../../style/motion/fade");
var _style = require("../../style");
var _motion = require("../../style/motion/motion");
var initFloatButtonGroupMotion = function initFloatButtonGroupMotion(token) {
  var _$concat;
  var componentCls = token.componentCls,
    floatButtonSize = token.floatButtonSize,
    motionDurationSlow = token.motionDurationSlow,
    motionEaseInOutCirc = token.motionEaseInOutCirc;
  var groupPrefixCls = "".concat(componentCls, "-group");
  var moveDownIn = new _cssinjs.Keyframes('antFloatButtonMoveDownIn', {
    '0%': {
      transform: "translate3d(0, ".concat(floatButtonSize, "px, 0)"),
      transformOrigin: '0 0',
      opacity: 0
    },
    '100%': {
      transform: 'translate3d(0, 0, 0)',
      transformOrigin: '0 0',
      opacity: 1
    }
  });
  var moveDownOut = new _cssinjs.Keyframes('antFloatButtonMoveDownOut', {
    '0%': {
      transform: 'translate3d(0, 0, 0)',
      transformOrigin: '0 0',
      opacity: 1
    },
    '100%': {
      transform: "translate3d(0, ".concat(floatButtonSize, "px, 0)"),
      transformOrigin: '0 0',
      opacity: 0
    }
  });
  return [(0, _defineProperty2.default)({}, "".concat(groupPrefixCls, "-wrap"), (0, _extends4.default)({}, (0, _motion.initMotion)("".concat(groupPrefixCls, "-wrap"), moveDownIn, moveDownOut, motionDurationSlow, true))), (0, _defineProperty2.default)({}, "".concat(groupPrefixCls, "-wrap"), (_$concat = {}, (0, _defineProperty2.default)(_$concat, "\n          &".concat(groupPrefixCls, "-wrap-enter,\n          &").concat(groupPrefixCls, "-wrap-appear\n        "), {
    opacity: 0,
    animationTimingFunction: motionEaseInOutCirc
  }), (0, _defineProperty2.default)(_$concat, "&".concat(groupPrefixCls, "-wrap-leave"), {
    animationTimingFunction: motionEaseInOutCirc
  }), _$concat))];
};
// ============================== Group ==============================
var floatButtonGroupStyle = function floatButtonGroupStyle(token) {
  var _extends2, _$concat6, _ref3;
  var componentCls = token.componentCls,
    floatButtonSize = token.floatButtonSize,
    margin = token.margin,
    borderRadiusLG = token.borderRadiusLG;
  var groupPrefixCls = "".concat(componentCls, "-group");
  return _ref3 = {}, (0, _defineProperty2.default)(_ref3, groupPrefixCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends2 = {
    zIndex: 99,
    display: 'block',
    border: 'none',
    position: 'fixed',
    width: floatButtonSize,
    height: 'auto',
    boxShadow: 'none',
    minHeight: floatButtonSize,
    insetInlineEnd: token.floatButtonInsetInlineEnd,
    insetBlockEnd: token.floatButtonInsetBlockEnd,
    borderRadius: borderRadiusLG
  }, (0, _defineProperty2.default)(_extends2, "".concat(groupPrefixCls, "-wrap"), {
    zIndex: -1,
    display: 'block',
    position: 'relative',
    marginBottom: margin
  }), (0, _defineProperty2.default)(_extends2, "&".concat(groupPrefixCls, "-rtl"), {
    direction: 'rtl'
  }), (0, _defineProperty2.default)(_extends2, componentCls, {
    position: 'static'
  }), _extends2))), (0, _defineProperty2.default)(_ref3, "".concat(groupPrefixCls, "-circle"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-circle:not(:last-child)"), (0, _defineProperty2.default)({
    marginBottom: token.margin
  }, "".concat(componentCls, "-body"), {
    width: floatButtonSize,
    height: floatButtonSize
  }))), (0, _defineProperty2.default)(_ref3, "".concat(groupPrefixCls, "-square"), (_$concat6 = {}, (0, _defineProperty2.default)(_$concat6, "".concat(componentCls, "-square"), {
    borderRadius: 0,
    padding: 0,
    '&:first-child': {
      borderStartStartRadius: borderRadiusLG,
      borderStartEndRadius: borderRadiusLG
    },
    '&:last-child': {
      borderEndStartRadius: borderRadiusLG,
      borderEndEndRadius: borderRadiusLG
    },
    '&:not(:last-child)': {
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
    }
  }), (0, _defineProperty2.default)(_$concat6, "".concat(groupPrefixCls, "-wrap"), (0, _defineProperty2.default)({
    display: 'block',
    borderRadius: borderRadiusLG,
    boxShadow: token.boxShadowSecondary,
    overflow: 'hidden'
  }, "".concat(componentCls, "-square"), (0, _defineProperty2.default)({
    boxShadow: 'none',
    marginTop: 0,
    borderRadius: 0,
    padding: token.paddingXXS,
    '&:first-child': {
      borderStartStartRadius: borderRadiusLG,
      borderStartEndRadius: borderRadiusLG
    },
    '&:last-child': {
      borderEndStartRadius: borderRadiusLG,
      borderEndEndRadius: borderRadiusLG
    },
    '&:not(:last-child)': {
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorSplit)
    }
  }, "".concat(componentCls, "-body"), {
    width: floatButtonSize - token.paddingXXS * 2,
    height: floatButtonSize - token.paddingXXS * 2
  }))), _$concat6)), (0, _defineProperty2.default)(_ref3, "".concat(groupPrefixCls, "-circle-shadow"), {
    boxShadow: 'none'
  }), (0, _defineProperty2.default)(_ref3, "".concat(groupPrefixCls, "-square-shadow"), (0, _defineProperty2.default)({
    boxShadow: token.boxShadowSecondary
  }, "".concat(componentCls, "-square"), (0, _defineProperty2.default)({
    boxShadow: 'none',
    padding: token.paddingXXS
  }, "".concat(componentCls, "-body"), {
    width: floatButtonSize - token.paddingXXS * 2,
    height: floatButtonSize - token.paddingXXS * 2
  }))), _ref3;
};
// ============================== Shared ==============================
var sharedFloatButtonStyle = function sharedFloatButtonStyle(token) {
  var _$concat13, _$concat16, _ref4;
  var componentCls = token.componentCls,
    floatButtonIconSize = token.floatButtonIconSize,
    floatButtonSize = token.floatButtonSize,
    borderRadiusLG = token.borderRadiusLG;
  return _ref4 = {}, (0, _defineProperty2.default)(_ref4, componentCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (0, _defineProperty2.default)({
    border: 'none',
    position: 'fixed',
    cursor: 'pointer',
    overflow: 'hidden',
    zIndex: 99,
    display: 'block',
    justifyContent: 'center',
    alignItems: 'center',
    width: floatButtonSize,
    height: floatButtonSize,
    insetInlineEnd: token.floatButtonInsetInlineEnd,
    insetBlockEnd: token.floatButtonInsetBlockEnd,
    boxShadow: token.boxShadowSecondary,
    // Pure Panel
    '&-pure': {
      position: 'relative',
      inset: 'auto'
    },
    '&:empty': {
      display: 'none'
    }
  }, "".concat(componentCls, "-body"), (0, _defineProperty2.default)({
    width: '100%',
    height: '100%',
    display: 'flex',
    justifyContent: 'center',
    alignItems: 'center',
    transition: "all ".concat(token.motionDurationMid)
  }, "".concat(componentCls, "-content"), (0, _defineProperty2.default)({
    overflow: 'hidden',
    textAlign: 'center',
    minHeight: floatButtonSize,
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    alignItems: 'center',
    padding: "2px 4px"
  }, "".concat(componentCls, "-icon"), {
    textAlign: 'center',
    margin: 'auto',
    width: floatButtonIconSize,
    fontSize: floatButtonIconSize,
    lineHeight: 1
  }))))), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-circle"), (0, _defineProperty2.default)({
    height: floatButtonSize,
    borderRadius: '50%'
  }, "".concat(componentCls, "-body"), {
    borderRadius: '50%'
  })), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-square"), (0, _defineProperty2.default)({
    height: 'auto',
    minHeight: floatButtonSize,
    borderRadius: borderRadiusLG
  }, "".concat(componentCls, "-body"), {
    height: 'auto',
    borderRadius: token.borderRadiusSM
  })), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-default"), (0, _defineProperty2.default)({
    backgroundColor: token.floatButtonBackgroundColor,
    transition: "background-color ".concat(token.motionDurationMid)
  }, "".concat(componentCls, "-body"), (0, _defineProperty2.default)({
    backgroundColor: token.floatButtonBackgroundColor,
    transition: "background-color ".concat(token.motionDurationMid),
    '&:hover': {
      backgroundColor: token.colorFillContent
    }
  }, "".concat(componentCls, "-content"), (_$concat13 = {}, (0, _defineProperty2.default)(_$concat13, "".concat(componentCls, "-icon"), {
    color: token.colorText
  }), (0, _defineProperty2.default)(_$concat13, "".concat(componentCls, "-description"), {
    display: 'flex',
    alignItems: 'center',
    lineHeight: "".concat(token.fontSizeLG, "px"),
    color: token.colorText,
    fontSize: token.fontSizeSM
  }), _$concat13)))), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-primary"), (0, _defineProperty2.default)({
    backgroundColor: token.colorPrimary
  }, "".concat(componentCls, "-body"), (0, _defineProperty2.default)({
    backgroundColor: token.colorPrimary,
    transition: "background-color ".concat(token.motionDurationMid),
    '&:hover': {
      backgroundColor: token.colorPrimaryHover
    }
  }, "".concat(componentCls, "-content"), (_$concat16 = {}, (0, _defineProperty2.default)(_$concat16, "".concat(componentCls, "-icon"), {
    color: token.colorTextLightSolid
  }), (0, _defineProperty2.default)(_$concat16, "".concat(componentCls, "-description"), {
    display: 'flex',
    alignItems: 'center',
    lineHeight: "".concat(token.fontSizeLG, "px"),
    color: token.colorTextLightSolid,
    fontSize: token.fontSizeSM
  }), _$concat16)))), _ref4;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('FloatButton', function (token) {
  var colorTextLightSolid = token.colorTextLightSolid,
    colorBgElevated = token.colorBgElevated,
    controlHeightLG = token.controlHeightLG,
    marginXXL = token.marginXXL,
    marginLG = token.marginLG,
    fontSize = token.fontSize,
    fontSizeIcon = token.fontSizeIcon,
    controlItemBgHover = token.controlItemBgHover;
  var floatButtonToken = (0, _internal.mergeToken)(token, {
    floatButtonBackgroundColor: colorBgElevated,
    floatButtonColor: colorTextLightSolid,
    floatButtonHoverBackgroundColor: controlItemBgHover,
    floatButtonFontSize: fontSize,
    floatButtonIconSize: fontSizeIcon * 1.5,
    floatButtonSize: controlHeightLG,
    floatButtonInsetBlockEnd: marginXXL,
    floatButtonInsetInlineEnd: marginLG
  });
  return [floatButtonGroupStyle(floatButtonToken), sharedFloatButtonStyle(floatButtonToken), (0, _fade.initFadeMotion)(token), initFloatButtonGroupMotion(floatButtonToken)];
});
exports.default = _default;