"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends4 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _style = require("../../style");
var _explain = _interopRequireDefault(require("./explain"));
var resetForm = function resetForm(token) {
  var _ref;
  return _ref = {
    legend: {
      display: 'block',
      width: '100%',
      marginBottom: token.marginLG,
      padding: 0,
      color: token.colorTextDescription,
      fontSize: token.fontSizeLG,
      lineHeight: 'inherit',
      border: 0,
      borderBottom: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder)
    },
    label: {
      fontSize: token.fontSize
    },
    'input[type="search"]': {
      boxSizing: 'border-box'
    },
    // Position radios and checkboxes better
    'input[type="radio"], input[type="checkbox"]': {
      lineHeight: 'normal'
    },
    'input[type="file"]': {
      display: 'block'
    },
    // Make range inputs behave like textual form controls
    'input[type="range"]': {
      display: 'block',
      width: '100%'
    },
    // Make multiple select elements height not fixed
    'select[multiple], select[size]': {
      height: 'auto'
    }
  }, (0, _defineProperty2.default)(_ref, "input[type='file']:focus,\n  input[type='radio']:focus,\n  input[type='checkbox']:focus", {
    outline: 0,
    boxShadow: "0 0 0 ".concat(token.controlOutlineWidth, "px ").concat(token.controlOutline)
  }), (0, _defineProperty2.default)(_ref, "output", {
    display: 'block',
    paddingTop: 15,
    color: token.colorText,
    fontSize: token.fontSize,
    lineHeight: token.lineHeight
  }), _ref;
};
var genFormSize = function genFormSize(token, height) {
  var _formItemCls;
  var formItemCls = token.formItemCls;
  return (0, _defineProperty2.default)({}, formItemCls, (_formItemCls = {}, (0, _defineProperty2.default)(_formItemCls, "".concat(formItemCls, "-label > label"), {
    height: height
  }), (0, _defineProperty2.default)(_formItemCls, "".concat(formItemCls, "-control-input"), {
    minHeight: height
  }), _formItemCls));
};
var genFormStyle = function genFormStyle(token) {
  var _extends2;
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, token.componentCls, (0, _extends4.default)((0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), resetForm(token)), (_extends2 = {}, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-text"), {
    display: 'inline-block',
    paddingInlineEnd: token.paddingSM
  }), (0, _defineProperty2.default)(_extends2, '&-small', (0, _extends4.default)({}, genFormSize(token, token.controlHeightSM))), (0, _defineProperty2.default)(_extends2, '&-large', (0, _extends4.default)({}, genFormSize(token, token.controlHeightLG))), _extends2)));
};
var genFormItemStyle = function genFormItemStyle(token) {
  var _label, _$concat2, _extends3;
  var formItemCls = token.formItemCls,
    iconCls = token.iconCls,
    componentCls = token.componentCls,
    rootPrefixCls = token.rootPrefixCls;
  return (0, _defineProperty2.default)({}, formItemCls, (0, _extends4.default)((0, _extends4.default)({}, (0, _style.resetComponent)(token)), (_extends3 = {
    marginBottom: token.marginLG,
    verticalAlign: 'top',
    '&-with-help': {
      transition: 'none'
    }
  }, (0, _defineProperty2.default)(_extends3, "&-hidden,\n        &-hidden.".concat(rootPrefixCls, "-row"), {
    // https://github.com/ant-design/ant-design/issues/26141
    display: 'none'
  }), (0, _defineProperty2.default)(_extends3, '&-has-warning', (0, _defineProperty2.default)({}, "".concat(formItemCls, "-split"), {
    color: token.colorError
  })), (0, _defineProperty2.default)(_extends3, '&-has-error', (0, _defineProperty2.default)({}, "".concat(formItemCls, "-split"), {
    color: token.colorWarning
  })), (0, _defineProperty2.default)(_extends3, "".concat(formItemCls, "-label"), {
    display: 'inline-block',
    flexGrow: 0,
    overflow: 'hidden',
    whiteSpace: 'nowrap',
    textAlign: 'end',
    verticalAlign: 'middle',
    '&-left': {
      textAlign: 'start'
    },
    '&-wrap': {
      overflow: 'unset',
      lineHeight: "".concat(token.lineHeight, " - 0.25em"),
      whiteSpace: 'unset'
    },
    '> label': (_label = {
      position: 'relative',
      display: 'inline-flex',
      alignItems: 'center',
      maxWidth: '100%',
      height: token.controlHeight,
      color: token.colorTextHeading,
      fontSize: token.fontSize
    }, (0, _defineProperty2.default)(_label, "> ".concat(iconCls), {
      fontSize: token.fontSize,
      verticalAlign: 'top'
    }), (0, _defineProperty2.default)(_label, "&".concat(formItemCls, "-required:not(").concat(formItemCls, "-required-mark-optional)::before"), (0, _defineProperty2.default)({
      display: 'inline-block',
      marginInlineEnd: token.marginXXS,
      color: token.colorError,
      fontSize: token.fontSize,
      fontFamily: 'SimSun, sans-serif',
      lineHeight: 1,
      content: '"*"'
    }, "".concat(componentCls, "-hide-required-mark &"), {
      display: 'none'
    })), (0, _defineProperty2.default)(_label, "".concat(formItemCls, "-optional"), (0, _defineProperty2.default)({
      display: 'inline-block',
      marginInlineStart: token.marginXXS,
      color: token.colorTextDescription
    }, "".concat(componentCls, "-hide-required-mark &"), {
      display: 'none'
    })), (0, _defineProperty2.default)(_label, "".concat(formItemCls, "-tooltip"), {
      color: token.colorTextDescription,
      cursor: 'help',
      writingMode: 'horizontal-tb',
      marginInlineStart: token.marginXXS
    }), (0, _defineProperty2.default)(_label, '&::after', {
      content: '":"',
      position: 'relative',
      marginBlock: 0,
      marginInlineStart: token.marginXXS / 2,
      marginInlineEnd: token.marginXS
    }), (0, _defineProperty2.default)(_label, "&".concat(formItemCls, "-no-colon::after"), {
      content: '" "'
    }), _label)
  }), (0, _defineProperty2.default)(_extends3, "".concat(formItemCls, "-control"), (_$concat2 = {
    display: 'flex',
    flexDirection: 'column',
    flexGrow: 1
  }, (0, _defineProperty2.default)(_$concat2, "&:first-child:not([class^=\"'".concat(rootPrefixCls, "-col-'\"]):not([class*=\"' ").concat(rootPrefixCls, "-col-'\"])"), {
    width: '100%'
  }), (0, _defineProperty2.default)(_$concat2, '&-input', {
    position: 'relative',
    display: 'flex',
    alignItems: 'center',
    minHeight: token.controlHeight,
    '&-content': {
      flex: 'auto',
      maxWidth: '100%'
    }
  }), _$concat2)), (0, _defineProperty2.default)(_extends3, formItemCls, {
    '&-explain, &-extra': {
      clear: 'both',
      color: token.colorTextDescription,
      fontSize: token.fontSize,
      lineHeight: token.lineHeight
    },
    '&-explain-connected': {
      width: '100%'
    },
    '&-extra': {
      minHeight: token.controlHeightSM,
      transition: "color ".concat(token.motionDurationMid, " ").concat(token.motionEaseOut) // sync input color transition
    },

    '&-explain': {
      '&-error': {
        color: token.colorError
      },
      '&-warning': {
        color: token.colorWarning
      }
    }
  }), (0, _defineProperty2.default)(_extends3, "&-with-help ".concat(formItemCls, "-explain"), {
    height: 'auto',
    opacity: 1
  }), (0, _defineProperty2.default)(_extends3, "".concat(formItemCls, "-feedback-icon"), {
    fontSize: token.fontSize,
    textAlign: 'center',
    visibility: 'visible',
    animationName: _motion.zoomIn,
    animationDuration: token.motionDurationMid,
    animationTimingFunction: token.motionEaseOutBack,
    pointerEvents: 'none',
    '&-success': {
      color: token.colorSuccess
    },
    '&-error': {
      color: token.colorError
    },
    '&-warning': {
      color: token.colorWarning
    },
    '&-validating': {
      color: token.colorPrimary
    }
  }), _extends3)));
};
var genHorizontalStyle = function genHorizontalStyle(token) {
  var _$concat3;
  var componentCls = token.componentCls,
    formItemCls = token.formItemCls,
    rootPrefixCls = token.rootPrefixCls;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-horizontal"), (_$concat3 = {}, (0, _defineProperty2.default)(_$concat3, "".concat(formItemCls, "-label"), {
    flexGrow: 0
  }), (0, _defineProperty2.default)(_$concat3, "".concat(formItemCls, "-control"), {
    flex: '1 1 0',
    // https://github.com/ant-design/ant-design/issues/32777
    // https://github.com/ant-design/ant-design/issues/33773
    minWidth: 0
  }), (0, _defineProperty2.default)(_$concat3, "".concat(formItemCls, "-label.").concat(rootPrefixCls, "-col-24 + ").concat(formItemCls, "-control"), {
    minWidth: 'unset'
  }), _$concat3));
};
var genInlineStyle = function genInlineStyle(token) {
  var _formItemCls2;
  var componentCls = token.componentCls,
    formItemCls = token.formItemCls;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-inline"), (0, _defineProperty2.default)({
    display: 'flex',
    flexWrap: 'wrap'
  }, formItemCls, (_formItemCls2 = {
    flex: 'none',
    flexWrap: 'nowrap',
    marginInlineEnd: token.margin,
    marginBottom: 0,
    '&-with-help': {
      marginBottom: token.marginLG
    }
  }, (0, _defineProperty2.default)(_formItemCls2, "> ".concat(formItemCls, "-label,\n        > ").concat(formItemCls, "-control"), {
    display: 'inline-block',
    verticalAlign: 'top'
  }), (0, _defineProperty2.default)(_formItemCls2, "> ".concat(formItemCls, "-label"), {
    flex: 'none'
  }), (0, _defineProperty2.default)(_formItemCls2, "".concat(componentCls, "-text"), {
    display: 'inline-block'
  }), (0, _defineProperty2.default)(_formItemCls2, "".concat(formItemCls, "-has-feedback"), {
    display: 'inline-block'
  }), _formItemCls2)));
};
var makeVerticalLayoutLabel = function makeVerticalLayoutLabel(token) {
  return {
    margin: 0,
    padding: "0 0 ".concat(token.paddingXS, "px"),
    whiteSpace: 'initial',
    textAlign: 'start',
    '> label': {
      margin: 0,
      '&::after': {
        display: 'none'
      }
    }
  };
};
var makeVerticalLayout = function makeVerticalLayout(token) {
  var _ref7;
  var componentCls = token.componentCls,
    formItemCls = token.formItemCls;
  return _ref7 = {}, (0, _defineProperty2.default)(_ref7, "".concat(formItemCls, " ").concat(formItemCls, "-label"), makeVerticalLayoutLabel(token)), (0, _defineProperty2.default)(_ref7, componentCls, (0, _defineProperty2.default)({}, formItemCls, (0, _defineProperty2.default)({
    flexWrap: 'wrap'
  }, "".concat(formItemCls, "-label,\n          ").concat(formItemCls, "-control"), {
    flex: '0 0 100%',
    maxWidth: '100%'
  }))), _ref7;
};
var genVerticalStyle = function genVerticalStyle(token) {
  var _ref9;
  var componentCls = token.componentCls,
    formItemCls = token.formItemCls,
    rootPrefixCls = token.rootPrefixCls;
  return _ref9 = {}, (0, _defineProperty2.default)(_ref9, "".concat(componentCls, "-vertical"), (0, _defineProperty2.default)({}, formItemCls, (0, _defineProperty2.default)({
    '&-row': {
      flexDirection: 'column'
    },
    '&-label > label': {
      height: 'auto'
    }
  }, "".concat(componentCls, "-item-control"), {
    width: '100%'
  }))), (0, _defineProperty2.default)(_ref9, "".concat(componentCls, "-vertical ").concat(formItemCls, "-label,\n      .").concat(rootPrefixCls, "-col-24").concat(formItemCls, "-label,\n      .").concat(rootPrefixCls, "-col-xl-24").concat(formItemCls, "-label"), makeVerticalLayoutLabel(token)), (0, _defineProperty2.default)(_ref9, "@media (max-width: ".concat(token.screenXSMax, "px)"), [makeVerticalLayout(token), (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({}, ".".concat(rootPrefixCls, "-col-xs-24").concat(formItemCls, "-label"), makeVerticalLayoutLabel(token)))]), (0, _defineProperty2.default)(_ref9, "@media (max-width: ".concat(token.screenSMMax, "px)"), (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({}, ".".concat(rootPrefixCls, "-col-sm-24").concat(formItemCls, "-label"), makeVerticalLayoutLabel(token)))), (0, _defineProperty2.default)(_ref9, "@media (max-width: ".concat(token.screenMDMax, "px)"), (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({}, ".".concat(rootPrefixCls, "-col-md-24").concat(formItemCls, "-label"), makeVerticalLayoutLabel(token)))), (0, _defineProperty2.default)(_ref9, "@media (max-width: ".concat(token.screenLGMax, "px)"), (0, _defineProperty2.default)({}, componentCls, (0, _defineProperty2.default)({}, ".".concat(rootPrefixCls, "-col-lg-24").concat(formItemCls, "-label"), makeVerticalLayoutLabel(token)))), _ref9;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Form', function (token, _ref10) {
  var rootPrefixCls = _ref10.rootPrefixCls;
  var formToken = (0, _internal.mergeToken)(token, {
    formItemCls: "".concat(token.componentCls, "-item"),
    rootPrefixCls: rootPrefixCls
  });
  return [genFormStyle(formToken), genFormItemStyle(formToken), (0, _explain.default)(formToken), genHorizontalStyle(formToken), genInlineStyle(formToken), genVerticalStyle(formToken), (0, _motion.genCollapseMotion)(formToken), _motion.zoomIn];
});
exports.default = _default;