"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.icons = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _PreviewGroup = _interopRequireDefault(require("../vc-image/src/PreviewGroup"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _RotateLeftOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/RotateLeftOutlined"));
var _RotateRightOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/RotateRightOutlined"));
var _ZoomInOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ZoomInOutlined"));
var _ZoomOutOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ZoomOutOutlined"));
var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseOutlined"));
var _LeftOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/LeftOutlined"));
var _RightOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/RightOutlined"));
var _style = _interopRequireDefault(require("./style"));
var _type = require("../_util/type");
var icons = {
  rotateLeft: (0, _vue.createVNode)(_RotateLeftOutlined.default, null, null),
  rotateRight: (0, _vue.createVNode)(_RotateRightOutlined.default, null, null),
  zoomIn: (0, _vue.createVNode)(_ZoomInOutlined.default, null, null),
  zoomOut: (0, _vue.createVNode)(_ZoomOutOutlined.default, null, null),
  close: (0, _vue.createVNode)(_CloseOutlined.default, null, null),
  left: (0, _vue.createVNode)(_LeftOutlined.default, null, null),
  right: (0, _vue.createVNode)(_RightOutlined.default, null, null)
};
exports.icons = icons;
var InternalPreviewGroup = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AImagePreviewGroup',
  inheritAttrs: false,
  props: {
    previewPrefixCls: String,
    preview: (0, _type.anyType)()
  },
  setup: function setup(props, _ref) {
    var attrs = _ref.attrs,
      slots = _ref.slots;
    var _useConfigInject = (0, _useConfigInject2.default)('image', props),
      prefixCls = _useConfigInject.prefixCls;
    var previewPrefixCls = (0, _vue.computed)(function () {
      return "".concat(prefixCls.value, "-preview");
    });
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var mergedPreview = (0, _vue.computed)(function () {
      var preview = props.preview;
      if (preview === false) {
        return preview;
      }
      var _preview = (0, _typeof2.default)(preview) === 'object' ? preview : {};
      return (0, _extends2.default)((0, _extends2.default)({}, _preview), {
        rootClassName: hashId.value
      });
    });
    return function () {
      return wrapSSR((0, _vue.createVNode)(_PreviewGroup.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, (0, _extends2.default)((0, _extends2.default)({}, attrs), props)), {}, {
        "preview": mergedPreview.value,
        "icons": icons,
        "previewPrefixCls": previewPrefixCls.value
      }), slots));
    };
  }
});
var _default = InternalPreviewGroup;
exports.default = _default;