"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.inputNumberProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classNames5 = _interopRequireDefault(require("../_util/classNames"));
var _UpOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/UpOutlined"));
var _DownOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/DownOutlined"));
var _InputNumber = _interopRequireWildcard(require("./src/InputNumber"));
var _FormItemContext = require("../form/FormItemContext");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _vnode = require("../_util/vnode");
var _omit = _interopRequireDefault(require("../_util/omit"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _isValidValue = _interopRequireDefault(require("../_util/isValidValue"));
var _statusUtils = require("../_util/statusUtils");
var _type = require("../_util/type");
var _style = _interopRequireDefault(require("./style"));
var _Compact = require("../space/Compact");
var _DisabledContext = require("../config-provider/DisabledContext");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// CSSINJS

var baseProps = (0, _InputNumber.inputNumberProps)();
var inputNumberProps = function inputNumberProps() {
  return (0, _extends2.default)((0, _extends2.default)({}, baseProps), {
    size: (0, _type.stringType)(),
    bordered: (0, _type.booleanType)(true),
    placeholder: String,
    name: String,
    id: String,
    type: String,
    addonBefore: _vueTypes.default.any,
    addonAfter: _vueTypes.default.any,
    prefix: _vueTypes.default.any,
    'onUpdate:value': baseProps.onChange,
    valueModifiers: Object,
    status: (0, _type.stringType)()
  });
};
exports.inputNumberProps = inputNumberProps;
var InputNumber = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AInputNumber',
  inheritAttrs: false,
  props: inputNumberProps(),
  // emits: ['focus', 'blur', 'change', 'input', 'update:value'],
  slots: ['addonBefore', 'addonAfter', 'prefix'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      expose = _ref.expose,
      attrs = _ref.attrs,
      slots = _ref.slots;
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var formItemInputContext = _FormItemContext.FormItemInputContext.useInject();
    var mergedStatus = (0, _vue.computed)(function () {
      return (0, _statusUtils.getMergedStatus)(formItemInputContext.status, props.status);
    });
    var _useConfigInject = (0, _useConfigInject2.default)('input-number', props),
      prefixCls = _useConfigInject.prefixCls,
      size = _useConfigInject.size,
      direction = _useConfigInject.direction,
      disabled = _useConfigInject.disabled;
    var _useCompactItemContex = (0, _Compact.useCompactItemContext)(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    // Style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var mergedSize = (0, _vue.computed)(function () {
      return compactSize.value || size.value;
    });
    var disabledContext = (0, _DisabledContext.useInjectDisabled)();
    var mergedDisabled = (0, _vue.computed)(function () {
      var _a;
      return (_a = disabled.value) !== null && _a !== void 0 ? _a : disabledContext.value;
    });
    var mergedValue = (0, _vue.shallowRef)(props.value === undefined ? props.defaultValue : props.value);
    var focused = (0, _vue.shallowRef)(false);
    (0, _vue.watch)(function () {
      return props.value;
    }, function () {
      mergedValue.value = props.value;
    });
    var inputNumberRef = (0, _vue.shallowRef)(null);
    var focus = function focus() {
      var _a;
      (_a = inputNumberRef.value) === null || _a === void 0 ? void 0 : _a.focus();
    };
    var blur = function blur() {
      var _a;
      (_a = inputNumberRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    var handleChange = function handleChange(val) {
      if (props.value === undefined) {
        mergedValue.value = val;
      }
      emit('update:value', val);
      emit('change', val);
      formItemContext.onFieldChange();
    };
    var handleBlur = function handleBlur(e) {
      focused.value = false;
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    var handleFocus = function handleFocus(e) {
      focused.value = true;
      emit('focus', e);
    };
    return function () {
      var _classNames;
      var _a, _b, _c, _d;
      var hasFeedback = formItemInputContext.hasFeedback,
        isFormItemInput = formItemInputContext.isFormItemInput,
        feedbackIcon = formItemInputContext.feedbackIcon;
      var id = (_a = props.id) !== null && _a !== void 0 ? _a : formItemContext.id.value;
      var _e = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, attrs), props), {
          id: id
        }),
        className = _e.class,
        bordered = _e.bordered,
        readonly = _e.readonly,
        style = _e.style,
        _e$addonBefore = _e.addonBefore,
        addonBefore = _e$addonBefore === void 0 ? (_b = slots.addonBefore) === null || _b === void 0 ? void 0 : _b.call(slots) : _e$addonBefore,
        _e$addonAfter = _e.addonAfter,
        addonAfter = _e$addonAfter === void 0 ? (_c = slots.addonAfter) === null || _c === void 0 ? void 0 : _c.call(slots) : _e$addonAfter,
        _e$prefix = _e.prefix,
        prefix = _e$prefix === void 0 ? (_d = slots.prefix) === null || _d === void 0 ? void 0 : _d.call(slots) : _e$prefix,
        _e$valueModifiers = _e.valueModifiers,
        valueModifiers = _e$valueModifiers === void 0 ? {} : _e$valueModifiers,
        others = __rest(_e, ["class", "bordered", "readonly", "style", "addonBefore", "addonAfter", "prefix", "valueModifiers"]);
      var preCls = prefixCls.value;
      var inputNumberClass = (0, _classNames5.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(preCls, "-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames, "".concat(preCls, "-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames, "".concat(preCls, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames, "".concat(preCls, "-readonly"), readonly), (0, _defineProperty2.default)(_classNames, "".concat(preCls, "-borderless"), !bordered), (0, _defineProperty2.default)(_classNames, "".concat(preCls, "-in-form-item"), isFormItemInput), _classNames), (0, _statusUtils.getStatusClassNames)(preCls, mergedStatus.value), className, compactItemClassnames.value, hashId.value);
      var element = (0, _vue.createVNode)(_InputNumber.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, (0, _omit.default)(others, ['size', 'defaultValue'])), {}, {
        "ref": inputNumberRef,
        "lazy": !!valueModifiers.lazy,
        "value": mergedValue.value,
        "class": inputNumberClass,
        "prefixCls": preCls,
        "readonly": readonly,
        "onChange": handleChange,
        "onBlur": handleBlur,
        "onFocus": handleFocus
      }), {
        upHandler: slots.upIcon ? function () {
          return (0, _vue.createVNode)("span", {
            "class": "".concat(preCls, "-handler-up-inner")
          }, [slots.upIcon()]);
        } : function () {
          return (0, _vue.createVNode)(_UpOutlined.default, {
            "class": "".concat(preCls, "-handler-up-inner")
          }, null);
        },
        downHandler: slots.downIcon ? function () {
          return (0, _vue.createVNode)("span", {
            "class": "".concat(preCls, "-handler-down-inner")
          }, [slots.downIcon()]);
        } : function () {
          return (0, _vue.createVNode)(_DownOutlined.default, {
            "class": "".concat(preCls, "-handler-down-inner")
          }, null);
        }
      });
      var hasAddon = (0, _isValidValue.default)(addonBefore) || (0, _isValidValue.default)(addonAfter);
      var hasPrefix = (0, _isValidValue.default)(prefix);
      if (hasPrefix || hasFeedback) {
        var _classNames2;
        var affixWrapperCls = (0, _classNames5.default)("".concat(preCls, "-affix-wrapper"), (0, _statusUtils.getStatusClassNames)("".concat(preCls, "-affix-wrapper"), mergedStatus.value, hasFeedback), (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-focused"), focused.value), (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-disabled"), mergedDisabled.value), (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-readonly"), readonly), (0, _defineProperty2.default)(_classNames2, "".concat(preCls, "-affix-wrapper-borderless"), !bordered), (0, _defineProperty2.default)(_classNames2, "".concat(className), !hasAddon && className), _classNames2), hashId.value);
        element = (0, _vue.createVNode)("div", {
          "class": affixWrapperCls,
          "style": style,
          "onMouseup": function onMouseup() {
            return inputNumberRef.value.focus();
          }
        }, [hasPrefix && (0, _vue.createVNode)("span", {
          "class": "".concat(preCls, "-prefix")
        }, [prefix]), element, hasFeedback && (0, _vue.createVNode)("span", {
          "class": "".concat(preCls, "-suffix")
        }, [feedbackIcon])]);
      }
      if (hasAddon) {
        var _classNames4;
        var wrapperClassName = "".concat(preCls, "-group");
        var addonClassName = "".concat(wrapperClassName, "-addon");
        var addonBeforeNode = addonBefore ? (0, _vue.createVNode)("div", {
          "class": addonClassName
        }, [addonBefore]) : null;
        var addonAfterNode = addonAfter ? (0, _vue.createVNode)("div", {
          "class": addonClassName
        }, [addonAfter]) : null;
        var mergedWrapperClassName = (0, _classNames5.default)("".concat(preCls, "-wrapper"), wrapperClassName, (0, _defineProperty2.default)({}, "".concat(wrapperClassName, "-rtl"), direction.value === 'rtl'), hashId.value);
        var mergedGroupClassName = (0, _classNames5.default)("".concat(preCls, "-group-wrapper"), (_classNames4 = {}, (0, _defineProperty2.default)(_classNames4, "".concat(preCls, "-group-wrapper-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames4, "".concat(preCls, "-group-wrapper-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames4, "".concat(preCls, "-group-wrapper-rtl"), direction.value === 'rtl'), _classNames4), (0, _statusUtils.getStatusClassNames)("".concat(prefixCls, "-group-wrapper"), mergedStatus.value, hasFeedback), className, hashId.value);
        element = (0, _vue.createVNode)("div", {
          "class": mergedGroupClassName,
          "style": style
        }, [(0, _vue.createVNode)("div", {
          "class": mergedWrapperClassName
        }, [addonBeforeNode && (0, _vue.createVNode)(_Compact.NoCompactStyle, null, {
          default: function _default() {
            return [(0, _vue.createVNode)(_FormItemContext.NoFormStatus, null, {
              default: function _default() {
                return [addonBeforeNode];
              }
            })];
          }
        }), element, addonAfterNode && (0, _vue.createVNode)(_Compact.NoCompactStyle, null, {
          default: function _default() {
            return [(0, _vue.createVNode)(_FormItemContext.NoFormStatus, null, {
              default: function _default() {
                return [addonAfterNode];
              }
            })];
          }
        })])]);
      }
      return wrapSSR((0, _vnode.cloneElement)(element, {
        style: style
      }));
    };
  }
});
var _default2 = (0, _extends2.default)(InputNumber, {
  install: function install(app) {
    app.component(InputNumber.name, InputNumber);
    return app;
  }
});
exports.default = _default2;