"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _FormItemContext = require("../form/FormItemContext");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _classNames = _interopRequireDefault(require("../_util/classNames"));
var _style = _interopRequireDefault(require("./style"));
// CSSINJS
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AInputGroup',
  inheritAttrs: false,
  props: {
    prefixCls: String,
    size: {
      type: String
    },
    compact: {
      type: Boolean,
      default: undefined
    }
  },
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('input-group', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      getPrefixCls = _useConfigInject.getPrefixCls;
    var formItemInputContext = _FormItemContext.FormItemInputContext.useInject();
    _FormItemContext.FormItemInputContext.useProvide(formItemInputContext, {
      isFormItemInput: false
    });
    // style
    var inputPrefixCls = (0, _vue.computed)(function () {
      return getPrefixCls('input');
    });
    var _useStyle = (0, _style.default)(inputPrefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var cls = (0, _vue.computed)(function () {
      var _ref2;
      var pre = prefixCls.value;
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(pre), true), (0, _defineProperty2.default)(_ref2, hashId.value, true), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-lg"), props.size === 'large'), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-sm"), props.size === 'small'), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-compact"), props.compact), (0, _defineProperty2.default)(_ref2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _ref2;
    });
    return function () {
      var _a;
      return wrapSSR((0, _vue.createVNode)("span", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": (0, _classNames.default)(cls.value, attrs.class)
      }), [(_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)]));
    };
  }
});
exports.default = _default;