"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _classNames5 = _interopRequireDefault(require("../_util/classNames"));
var _FormItemContext = require("../form/FormItemContext");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _statusUtils = require("../_util/statusUtils");
var _commonUtils = require("../vc-input/utils/commonUtils");
var _Input = _interopRequireDefault(require("../vc-input/Input"));
var _inputProps = _interopRequireDefault(require("./inputProps"));
var _omit = _interopRequireDefault(require("../_util/omit"));
var _CloseCircleFilled = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseCircleFilled"));
var _Compact = require("../space/Compact");
var _style = _interopRequireDefault(require("./style"));
var _DisabledContext = require("../config-provider/DisabledContext");
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// CSSINJS
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AInput',
  inheritAttrs: false,
  props: (0, _inputProps.default)(),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs,
      expose = _ref.expose,
      emit = _ref.emit;
    var inputRef = (0, _vue.ref)();
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var formItemInputContext = _FormItemContext.FormItemInputContext.useInject();
    var mergedStatus = (0, _vue.computed)(function () {
      return (0, _statusUtils.getMergedStatus)(formItemInputContext.status, props.status);
    });
    var _useConfigInject = (0, _useConfigInject2.default)('input', props),
      direction = _useConfigInject.direction,
      prefixCls = _useConfigInject.prefixCls,
      size = _useConfigInject.size,
      autocomplete = _useConfigInject.autocomplete;
    // ===================== Compact Item =====================
    var _useCompactItemContex = (0, _Compact.useCompactItemContext)(prefixCls, direction),
      compactSize = _useCompactItemContex.compactSize,
      compactItemClassnames = _useCompactItemContex.compactItemClassnames;
    var mergedSize = (0, _vue.computed)(function () {
      return compactSize.value || size.value;
    });
    // Style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var disabled = (0, _DisabledContext.useInjectDisabled)();
    var focus = function focus(option) {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.focus(option);
    };
    var blur = function blur() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.blur();
    };
    var setSelectionRange = function setSelectionRange(start, end, direction) {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.setSelectionRange(start, end, direction);
    };
    var select = function select() {
      var _a;
      (_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.select();
    };
    expose({
      focus: focus,
      blur: blur,
      input: inputRef,
      setSelectionRange: setSelectionRange,
      select: select
    });
    // ===================== Remove Password value =====================
    var removePasswordTimeoutRef = (0, _vue.ref)([]);
    var removePasswordTimeout = function removePasswordTimeout() {
      removePasswordTimeoutRef.value.push(setTimeout(function () {
        var _a, _b, _c, _d;
        if (((_a = inputRef.value) === null || _a === void 0 ? void 0 : _a.input) && ((_b = inputRef.value) === null || _b === void 0 ? void 0 : _b.input.getAttribute('type')) === 'password' && ((_c = inputRef.value) === null || _c === void 0 ? void 0 : _c.input.hasAttribute('value'))) {
          (_d = inputRef.value) === null || _d === void 0 ? void 0 : _d.input.removeAttribute('value');
        }
      }));
    };
    (0, _vue.onMounted)(function () {
      removePasswordTimeout();
    });
    (0, _vue.onBeforeUpdate)(function () {
      removePasswordTimeoutRef.value.forEach(function (item) {
        return clearTimeout(item);
      });
    });
    (0, _vue.onBeforeUnmount)(function () {
      removePasswordTimeoutRef.value.forEach(function (item) {
        return clearTimeout(item);
      });
    });
    var handleBlur = function handleBlur(e) {
      removePasswordTimeout();
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    var handleFocus = function handleFocus(e) {
      removePasswordTimeout();
      emit('focus', e);
    };
    var triggerChange = function triggerChange(e) {
      emit('update:value', e.target.value);
      emit('change', e);
      emit('input', e);
      formItemContext.onFieldChange();
    };
    return function () {
      var _classNames, _classNames2, _classNames4;
      var _a, _b, _c, _d, _e, _f;
      var hasFeedback = formItemInputContext.hasFeedback,
        feedbackIcon = formItemInputContext.feedbackIcon;
      var allowClear = props.allowClear,
        _props$bordered = props.bordered,
        bordered = _props$bordered === void 0 ? true : _props$bordered,
        _props$prefix = props.prefix,
        prefix = _props$prefix === void 0 ? (_a = slots.prefix) === null || _a === void 0 ? void 0 : _a.call(slots) : _props$prefix,
        _props$suffix = props.suffix,
        suffix = _props$suffix === void 0 ? (_b = slots.suffix) === null || _b === void 0 ? void 0 : _b.call(slots) : _props$suffix,
        _props$addonAfter = props.addonAfter,
        addonAfter = _props$addonAfter === void 0 ? (_c = slots.addonAfter) === null || _c === void 0 ? void 0 : _c.call(slots) : _props$addonAfter,
        _props$addonBefore = props.addonBefore,
        addonBefore = _props$addonBefore === void 0 ? (_d = slots.addonBefore) === null || _d === void 0 ? void 0 : _d.call(slots) : _props$addonBefore,
        _props$id = props.id,
        id = _props$id === void 0 ? (_e = formItemContext.id) === null || _e === void 0 ? void 0 : _e.value : _props$id,
        rest = __rest(props, ["allowClear", "bordered", "prefix", "suffix", "addonAfter", "addonBefore", "id"]);
      var suffixNode = (hasFeedback || suffix) && (0, _vue.createVNode)(_vue.Fragment, null, [suffix, hasFeedback && feedbackIcon]);
      var prefixClsValue = prefixCls.value;
      var inputHasPrefixSuffix = (0, _commonUtils.hasPrefixSuffix)({
        prefix: prefix,
        suffix: suffix
      }) || !!hasFeedback;
      var clearIcon = slots.clearIcon || function () {
        return (0, _vue.createVNode)(_CloseCircleFilled.default, null, null);
      };
      return wrapSSR((0, _vue.createVNode)(_Input.default, (0, _objectSpread2.default)((0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), (0, _omit.default)(rest, ['onUpdate:value', 'onChange', 'onInput'])), {}, {
        "onChange": triggerChange,
        "id": id,
        "disabled": (_f = props.disabled) !== null && _f !== void 0 ? _f : disabled.value,
        "ref": inputRef,
        "prefixCls": prefixClsValue,
        "autocomplete": autocomplete.value,
        "onBlur": handleBlur,
        "onFocus": handleFocus,
        "suffix": suffixNode,
        "allowClear": allowClear,
        "addonAfter": addonAfter && (0, _vue.createVNode)(_Compact.NoCompactStyle, null, {
          default: function _default() {
            return [(0, _vue.createVNode)(_FormItemContext.NoFormStatus, null, {
              default: function _default() {
                return [addonAfter];
              }
            })];
          }
        }),
        "addonBefore": addonBefore && (0, _vue.createVNode)(_Compact.NoCompactStyle, null, {
          default: function _default() {
            return [(0, _vue.createVNode)(_FormItemContext.NoFormStatus, null, {
              default: function _default() {
                return [addonBefore];
              }
            })];
          }
        }),
        "class": [attrs.class, compactItemClassnames.value],
        "inputClassName": (0, _classNames5.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames, "".concat(prefixClsValue, "-borderless"), !bordered), _classNames), !inputHasPrefixSuffix && (0, _statusUtils.getStatusClassNames)(prefixClsValue, mergedStatus.value), hashId.value),
        "affixWrapperClassName": (0, _classNames5.default)((_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-rtl"), direction.value === 'rtl'), (0, _defineProperty2.default)(_classNames2, "".concat(prefixClsValue, "-affix-wrapper-borderless"), !bordered), _classNames2), (0, _statusUtils.getStatusClassNames)("".concat(prefixClsValue, "-affix-wrapper"), mergedStatus.value, hasFeedback), hashId.value),
        "wrapperClassName": (0, _classNames5.default)((0, _defineProperty2.default)({}, "".concat(prefixClsValue, "-group-rtl"), direction.value === 'rtl'), hashId.value),
        "groupClassName": (0, _classNames5.default)((_classNames4 = {}, (0, _defineProperty2.default)(_classNames4, "".concat(prefixClsValue, "-group-wrapper-sm"), mergedSize.value === 'small'), (0, _defineProperty2.default)(_classNames4, "".concat(prefixClsValue, "-group-wrapper-lg"), mergedSize.value === 'large'), (0, _defineProperty2.default)(_classNames4, "".concat(prefixClsValue, "-group-wrapper-rtl"), direction.value === 'rtl'), _classNames4), (0, _statusUtils.getStatusClassNames)("".concat(prefixClsValue, "-group-wrapper"), mergedStatus.value, hasFeedback), hashId.value)
      }), (0, _extends2.default)((0, _extends2.default)({}, slots), {
        clearIcon: clearIcon
      })));
    };
  }
});
exports.default = _default2;