"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.basicProps = exports.Header = exports.Footer = exports.Content = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _useConfigInject3 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _injectionKey = require("./injectionKey");
var _style = _interopRequireDefault(require("./style"));
var basicProps = function basicProps() {
  return {
    prefixCls: String,
    hasSider: {
      type: Boolean,
      default: undefined
    },
    tagName: String
  };
};
exports.basicProps = basicProps;
function generator(_ref) {
  var suffixCls = _ref.suffixCls,
    tagName = _ref.tagName,
    name = _ref.name;
  return function (BasicComponent) {
    var Adapter = (0, _vue.defineComponent)({
      compatConfig: {
        MODE: 3
      },
      name: name,
      props: basicProps(),
      setup: function setup(props, _ref2) {
        var slots = _ref2.slots;
        var _useConfigInject = (0, _useConfigInject3.default)(suffixCls, props),
          prefixCls = _useConfigInject.prefixCls;
        return function () {
          var basicComponentProps = (0, _extends2.default)((0, _extends2.default)({}, props), {
            prefixCls: prefixCls.value,
            tagName: tagName
          });
          return (0, _vue.createVNode)(BasicComponent, basicComponentProps, slots);
        };
      }
    });
    return Adapter;
  };
}
var Basic = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  props: basicProps(),
  setup: function setup(props, _ref3) {
    var slots = _ref3.slots;
    return function () {
      return (0, _vue.createVNode)(props.tagName, {
        class: props.prefixCls
      }, slots);
    };
  }
});
var BasicLayout = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  inheritAttrs: false,
  props: basicProps(),
  setup: function setup(props, _ref4) {
    var slots = _ref4.slots,
      attrs = _ref4.attrs;
    var _useConfigInject2 = (0, _useConfigInject3.default)('', props),
      prefixCls = _useConfigInject2.prefixCls,
      direction = _useConfigInject2.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var siders = (0, _vue.ref)([]);
    var siderHookProvider = {
      addSider: function addSider(id) {
        siders.value = [].concat((0, _toConsumableArray2.default)(siders.value), [id]);
      },
      removeSider: function removeSider(id) {
        siders.value = siders.value.filter(function (currentId) {
          return currentId !== id;
        });
      }
    };
    (0, _vue.provide)(_injectionKey.SiderHookProviderKey, siderHookProvider);
    var divCls = (0, _vue.computed)(function () {
      var _ref5;
      var prefixCls = props.prefixCls,
        hasSider = props.hasSider;
      return _ref5 = {}, (0, _defineProperty2.default)(_ref5, hashId.value, true), (0, _defineProperty2.default)(_ref5, "".concat(prefixCls), true), (0, _defineProperty2.default)(_ref5, "".concat(prefixCls, "-has-sider"), typeof hasSider === 'boolean' ? hasSider : siders.value.length > 0), (0, _defineProperty2.default)(_ref5, "".concat(prefixCls, "-rtl"), direction.value === 'rtl'), _ref5;
    });
    return function () {
      var tagName = props.tagName;
      return wrapSSR((0, _vue.createVNode)(tagName, (0, _extends2.default)((0, _extends2.default)({}, attrs), {
        class: [divCls.value, attrs.class]
      }), slots));
    };
  }
});
var Layout = generator({
  suffixCls: 'layout',
  tagName: 'section',
  name: 'ALayout'
})(BasicLayout);
var Header = generator({
  suffixCls: 'layout-header',
  tagName: 'header',
  name: 'ALayoutHeader'
})(Basic);
exports.Header = Header;
var Footer = generator({
  suffixCls: 'layout-footer',
  tagName: 'footer',
  name: 'ALayoutFooter'
})(Basic);
exports.Footer = Footer;
var Content = generator({
  suffixCls: 'layout-content',
  tagName: 'main',
  name: 'ALayoutContent'
})(Basic);
exports.Content = Content;
var _default = Layout;
exports.default = _default;