"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mentionsProps = exports.default = exports.MentionsOption = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _vueTypes = _interopRequireDefault(require("../_util/vue-types"));
var _vcMentions = _interopRequireDefault(require("../vc-mentions"));
var _mentionsProps = require("../vc-mentions/src/mentionsProps");
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _propsUtil = require("../_util/props-util");
var _FormItemContext = require("../form/FormItemContext");
var _omit = _interopRequireDefault(require("../_util/omit"));
var _Option = require("../vc-mentions/src/Option");
var _statusUtils = require("../_util/statusUtils");
var _style = _interopRequireDefault(require("./style"));
var _OverrideContext = require("../menu/src/OverrideContext");
var _warning = _interopRequireDefault(require("../_util/warning"));
var _spin = _interopRequireDefault(require("../spin"));
var _devWarning = _interopRequireDefault(require("../vc-util/devWarning"));
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};
function loadingFilterOption() {
  return true;
}
var getMentions = function getMentions() {
  var value = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
  var config = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
  var _config$prefix = config.prefix,
    prefix = _config$prefix === void 0 ? '@' : _config$prefix,
    _config$split = config.split,
    split = _config$split === void 0 ? ' ' : _config$split;
  var prefixList = Array.isArray(prefix) ? prefix : [prefix];
  return value.split(split).map(function () {
    var str = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    var hitPrefix = null;
    prefixList.some(function (prefixStr) {
      var startStr = str.slice(0, prefixStr.length);
      if (startStr === prefixStr) {
        hitPrefix = prefixStr;
        return true;
      }
      return false;
    });
    if (hitPrefix !== null) {
      return {
        prefix: hitPrefix,
        value: str.slice(hitPrefix.length)
      };
    }
    return null;
  }).filter(function (entity) {
    return !!entity && !!entity.value;
  });
};
var mentionsProps = function mentionsProps() {
  return (0, _extends2.default)((0, _extends2.default)({}, _mentionsProps.mentionsProps), {
    loading: {
      type: Boolean,
      default: undefined
    },
    onFocus: {
      type: Function
    },
    onBlur: {
      type: Function
    },
    onSelect: {
      type: Function
    },
    onChange: {
      type: Function
    },
    onPressenter: {
      type: Function
    },
    'onUpdate:value': {
      type: Function
    },
    notFoundContent: _vueTypes.default.any,
    defaultValue: String,
    id: String,
    status: String
  });
};
exports.mentionsProps = mentionsProps;
var Mentions = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AMentions',
  inheritAttrs: false,
  props: mentionsProps(),
  slots: ['notFoundContent', 'option'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    var _a, _b, _c;
    // =================== Warning =====================
    if (process.env.NODE_ENV !== 'production') {
      (0, _devWarning.default)(!(0, _propsUtil.flattenChildren)(((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || []).length, 'Mentions', '`Mentions.Option` is deprecated. Please use `options` instead.');
    }
    var _useConfigInject = (0, _useConfigInject2.default)('mentions', props),
      prefixCls = _useConfigInject.prefixCls,
      renderEmpty = _useConfigInject.renderEmpty,
      direction = _useConfigInject.direction;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var focused = (0, _vue.shallowRef)(false);
    var vcMentions = (0, _vue.shallowRef)(null);
    var value = (0, _vue.shallowRef)((_c = (_b = props.value) !== null && _b !== void 0 ? _b : props.defaultValue) !== null && _c !== void 0 ? _c : '');
    var formItemContext = (0, _FormItemContext.useInjectFormItemContext)();
    var formItemInputContext = _FormItemContext.FormItemInputContext.useInject();
    var mergedStatus = (0, _vue.computed)(function () {
      return (0, _statusUtils.getMergedStatus)(formItemInputContext.status, props.status);
    });
    (0, _OverrideContext.useProvideOverride)({
      prefixCls: (0, _vue.computed)(function () {
        return "".concat(prefixCls.value, "-menu");
      }),
      mode: (0, _vue.computed)(function () {
        return 'vertical';
      }),
      selectable: (0, _vue.computed)(function () {
        return false;
      }),
      onClick: function onClick() {},
      validator: function validator(_ref2) {
        var mode = _ref2.mode;
        // Warning if use other mode
        (0, _warning.default)(!mode || mode === 'vertical', 'Mentions', "mode=\"".concat(mode, "\" is not supported for Mentions's Menu."));
      }
    });
    (0, _vue.watch)(function () {
      return props.value;
    }, function (val) {
      value.value = val;
    });
    var handleFocus = function handleFocus(e) {
      focused.value = true;
      emit('focus', e);
    };
    var handleBlur = function handleBlur(e) {
      focused.value = false;
      emit('blur', e);
      formItemContext.onFieldBlur();
    };
    var handleSelect = function handleSelect() {
      for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
        args[_key] = arguments[_key];
      }
      emit.apply(void 0, ['select'].concat(args));
      focused.value = true;
    };
    var handleChange = function handleChange(val) {
      if (props.value === undefined) {
        value.value = val;
      }
      emit('update:value', val);
      emit('change', val);
      formItemContext.onFieldChange();
    };
    var getNotFoundContent = function getNotFoundContent() {
      var notFoundContent = props.notFoundContent;
      if (notFoundContent !== undefined) {
        return notFoundContent;
      }
      if (slots.notFoundContent) {
        return slots.notFoundContent();
      }
      return renderEmpty('Select');
    };
    var getOptions = function getOptions() {
      var _a;
      return (0, _propsUtil.flattenChildren)(((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)) || []).map(function (item) {
        var _a, _b;
        return (0, _extends2.default)((0, _extends2.default)({}, (0, _propsUtil.getOptionProps)(item)), {
          label: (_b = (_a = item.children) === null || _a === void 0 ? void 0 : _a.default) === null || _b === void 0 ? void 0 : _b.call(_a)
        });
      });
    };
    var focus = function focus() {
      vcMentions.value.focus();
    };
    var blur = function blur() {
      vcMentions.value.blur();
    };
    expose({
      focus: focus,
      blur: blur
    });
    var mentionsfilterOption = (0, _vue.computed)(function () {
      return props.loading ? loadingFilterOption : props.filterOption;
    });
    return function () {
      var _classNames;
      var disabled = props.disabled,
        getPopupContainer = props.getPopupContainer,
        _props$rows = props.rows,
        rows = _props$rows === void 0 ? 1 : _props$rows,
        _props$id = props.id,
        id = _props$id === void 0 ? formItemContext.id.value : _props$id,
        restProps = __rest(props, ["disabled", "getPopupContainer", "rows", "id"]);
      var hasFeedback = formItemInputContext.hasFeedback,
        feedbackIcon = formItemInputContext.feedbackIcon;
      var className = attrs.class,
        otherAttrs = __rest(attrs, ["class"]);
      var otherProps = (0, _omit.default)(restProps, ['defaultValue', 'onUpdate:value', 'prefixCls']);
      var mergedClassName = (0, _classNames2.default)((_classNames = {}, (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-disabled"), disabled), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-focused"), focused.value), (0, _defineProperty2.default)(_classNames, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), _classNames), (0, _statusUtils.getStatusClassNames)(prefixCls.value, mergedStatus.value), !hasFeedback && className, hashId.value);
      var mentionsProps = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({
        prefixCls: prefixCls.value
      }, otherProps), {
        disabled: disabled,
        direction: direction.value,
        filterOption: mentionsfilterOption.value,
        getPopupContainer: getPopupContainer,
        options: props.loading ? [{
          value: 'ANTDV_SEARCHING',
          disabled: true,
          label: (0, _vue.createVNode)(_spin.default, {
            "size": "small"
          }, null)
        }] : props.options || getOptions(),
        class: mergedClassName
      }), otherAttrs), {
        rows: rows,
        onChange: handleChange,
        onSelect: handleSelect,
        onFocus: handleFocus,
        onBlur: handleBlur,
        ref: vcMentions,
        value: value.value,
        id: id
      });
      var mentions = (0, _vue.createVNode)(_vcMentions.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, mentionsProps), {}, {
        "dropdownClassName": hashId.value
      }), {
        notFoundContent: getNotFoundContent,
        option: slots.option
      });
      if (hasFeedback) {
        return wrapSSR((0, _vue.createVNode)("div", {
          "class": (0, _classNames2.default)("".concat(prefixCls.value, "-affix-wrapper"), (0, _statusUtils.getStatusClassNames)("".concat(prefixCls.value, "-affix-wrapper"), mergedStatus.value, hasFeedback), className, hashId.value)
        }, [mentions, (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls.value, "-suffix")
        }, [feedbackIcon])]));
      }
      return wrapSSR(mentions);
    };
  }
});
/* istanbul ignore next */
var MentionsOption = (0, _vue.defineComponent)((0, _extends2.default)((0, _extends2.default)({
  compatConfig: {
    MODE: 3
  }
}, _Option.optionOptions), {
  name: 'AMentionsOption',
  props: _Option.optionProps
}));
exports.MentionsOption = MentionsOption;
var _default = (0, _extends2.default)(Mentions, {
  Option: MentionsOption,
  getMentions: getMentions,
  install: function install(app) {
    app.component(Mentions.name, Mentions);
    app.component(MentionsOption.name, MentionsOption);
    return app;
  }
});
exports.default = _default;