"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.menuProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _createForOfIteratorHelper2 = _interopRequireDefault(require("@babel/runtime/helpers/createForOfIteratorHelper"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _shallowequal = _interopRequireDefault(require("../../_util/shallowequal"));
var _useMenuContext = _interopRequireWildcard(require("./hooks/useMenuContext"));
var _useConfigInject2 = _interopRequireDefault(require("../../config-provider/hooks/useConfigInject"));
var _devWarning = _interopRequireDefault(require("../../vc-util/devWarning"));
var _uniq = _interopRequireDefault(require("lodash/uniq"));
var _injectionKey = require("../../layout/injectionKey");
var _propsUtil = require("../../_util/props-util");
var _vcOverflow = _interopRequireDefault(require("../../vc-overflow"));
var _MenuItem = _interopRequireDefault(require("./MenuItem"));
var _SubMenu = _interopRequireDefault(require("./SubMenu"));
var _EllipsisOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/EllipsisOutlined"));
var _vnode = require("../../_util/vnode");
var _useKeyPath = require("./hooks/useKeyPath");
var _collapseMotion = _interopRequireDefault(require("../../_util/collapseMotion"));
var _useItems2 = _interopRequireDefault(require("./hooks/useItems"));
var _style = _interopRequireDefault(require("../style"));
var _OverrideContext = require("./OverrideContext");
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var menuProps = function menuProps() {
  return {
    id: String,
    prefixCls: String,
    // donot use items, now only support inner use
    items: Array,
    disabled: Boolean,
    inlineCollapsed: Boolean,
    disabledOverflow: Boolean,
    forceSubMenuRender: Boolean,
    openKeys: Array,
    selectedKeys: Array,
    activeKey: String,
    selectable: {
      type: Boolean,
      default: true
    },
    multiple: {
      type: Boolean,
      default: false
    },
    motion: Object,
    theme: {
      type: String,
      default: 'light'
    },
    mode: {
      type: String,
      default: 'vertical'
    },
    inlineIndent: {
      type: Number,
      default: 24
    },
    subMenuOpenDelay: {
      type: Number,
      default: 0
    },
    subMenuCloseDelay: {
      type: Number,
      default: 0.1
    },
    builtinPlacements: {
      type: Object
    },
    triggerSubMenuAction: {
      type: String,
      default: 'hover'
    },
    getPopupContainer: Function,
    expandIcon: Function,
    onOpenChange: Function,
    onSelect: Function,
    onDeselect: Function,
    onClick: [Function, Array],
    onFocus: Function,
    onBlur: Function,
    onMousedown: Function,
    'onUpdate:openKeys': Function,
    'onUpdate:selectedKeys': Function,
    'onUpdate:activeKey': Function
  };
};
exports.menuProps = menuProps;
var EMPTY_LIST = [];
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'AMenu',
  inheritAttrs: false,
  props: menuProps(),
  slots: ['expandIcon', 'overflowedIndicator'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      emit = _ref.emit,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('menu', props),
      direction = _useConfigInject.direction,
      getPrefixCls = _useConfigInject.getPrefixCls;
    var override = (0, _OverrideContext.useInjectOverride)();
    var prefixCls = (0, _vue.computed)(function () {
      var _a;
      return getPrefixCls('menu', props.prefixCls || ((_a = override === null || override === void 0 ? void 0 : override.prefixCls) === null || _a === void 0 ? void 0 : _a.value));
    });
    var _useStyle = (0, _style.default)(prefixCls, (0, _vue.computed)(function () {
        return !override;
      })),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var store = (0, _vue.shallowRef)(new Map());
    var siderCollapsed = (0, _vue.inject)(_injectionKey.SiderCollapsedKey, (0, _vue.ref)(undefined));
    var inlineCollapsed = (0, _vue.computed)(function () {
      if (siderCollapsed.value !== undefined) {
        return siderCollapsed.value;
      }
      return props.inlineCollapsed;
    });
    var _useItems = (0, _useItems2.default)(props),
      itemsNodes = _useItems.itemsNodes;
    var isMounted = (0, _vue.shallowRef)(false);
    (0, _vue.onMounted)(function () {
      isMounted.value = true;
    });
    (0, _vue.watchEffect)(function () {
      (0, _devWarning.default)(!(props.inlineCollapsed === true && props.mode !== 'inline'), 'Menu', '`inlineCollapsed` should only be used when `mode` is inline.');
      (0, _devWarning.default)(!(siderCollapsed.value !== undefined && props.inlineCollapsed === true), 'Menu', '`inlineCollapsed` not control Menu under Sider. Should set `collapsed` on Sider instead.');
      // devWarning(
      //   !!props.items && !slots.default,
      //   'Menu',
      //   '`children` will be removed in next major version. Please use `items` instead.',
      // );
    });

    var activeKeys = (0, _vue.ref)([]);
    var mergedSelectedKeys = (0, _vue.ref)([]);
    var keyMapStore = (0, _vue.ref)({});
    (0, _vue.watch)(store, function () {
      var newKeyMapStore = {};
      var _iterator = (0, _createForOfIteratorHelper2.default)(store.value.values()),
        _step;
      try {
        for (_iterator.s(); !(_step = _iterator.n()).done;) {
          var menuInfo = _step.value;
          newKeyMapStore[menuInfo.key] = menuInfo;
        }
      } catch (err) {
        _iterator.e(err);
      } finally {
        _iterator.f();
      }
      keyMapStore.value = newKeyMapStore;
    }, {
      flush: 'post'
    });
    (0, _vue.watchEffect)(function () {
      if (props.activeKey !== undefined) {
        var keys = [];
        var menuInfo = props.activeKey ? keyMapStore.value[props.activeKey] : undefined;
        if (menuInfo && props.activeKey !== undefined) {
          keys = (0, _uniq.default)([].concat((0, _vue.unref)(menuInfo.parentKeys), props.activeKey));
        } else {
          keys = [];
        }
        if (!(0, _shallowequal.default)(activeKeys.value, keys)) {
          activeKeys.value = keys;
        }
      }
    });
    (0, _vue.watch)(function () {
      return props.selectedKeys;
    }, function (selectedKeys) {
      if (selectedKeys) {
        mergedSelectedKeys.value = selectedKeys.slice();
      }
    }, {
      immediate: true,
      deep: true
    });
    var selectedSubMenuKeys = (0, _vue.ref)([]);
    (0, _vue.watch)([keyMapStore, mergedSelectedKeys], function () {
      var subMenuParentKeys = [];
      mergedSelectedKeys.value.forEach(function (key) {
        var menuInfo = keyMapStore.value[key];
        if (menuInfo) {
          subMenuParentKeys = subMenuParentKeys.concat((0, _vue.unref)(menuInfo.parentKeys));
        }
      });
      subMenuParentKeys = (0, _uniq.default)(subMenuParentKeys);
      if (!(0, _shallowequal.default)(selectedSubMenuKeys.value, subMenuParentKeys)) {
        selectedSubMenuKeys.value = subMenuParentKeys;
      }
    }, {
      immediate: true
    });
    // >>>>> Trigger select
    var triggerSelection = function triggerSelection(info) {
      if (props.selectable) {
        // Insert or Remove
        var targetKey = info.key;
        var exist = mergedSelectedKeys.value.includes(targetKey);
        var newSelectedKeys;
        if (props.multiple) {
          if (exist) {
            newSelectedKeys = mergedSelectedKeys.value.filter(function (key) {
              return key !== targetKey;
            });
          } else {
            newSelectedKeys = [].concat((0, _toConsumableArray2.default)(mergedSelectedKeys.value), [targetKey]);
          }
        } else {
          newSelectedKeys = [targetKey];
        }
        // Trigger event
        var selectInfo = (0, _extends2.default)((0, _extends2.default)({}, info), {
          selectedKeys: newSelectedKeys
        });
        if (!(0, _shallowequal.default)(newSelectedKeys, mergedSelectedKeys.value)) {
          if (props.selectedKeys === undefined) {
            mergedSelectedKeys.value = newSelectedKeys;
          }
          emit('update:selectedKeys', newSelectedKeys);
          if (exist && props.multiple) {
            emit('deselect', selectInfo);
          } else {
            emit('select', selectInfo);
          }
        }
      }
      // Whatever selectable, always close it
      if (mergedMode.value !== 'inline' && !props.multiple && mergedOpenKeys.value.length) {
        triggerOpenKeys(EMPTY_LIST);
      }
    };
    var mergedOpenKeys = (0, _vue.ref)([]);
    (0, _vue.watch)(function () {
      return props.openKeys;
    }, function () {
      var openKeys = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : mergedOpenKeys.value;
      if (!(0, _shallowequal.default)(mergedOpenKeys.value, openKeys)) {
        mergedOpenKeys.value = openKeys.slice();
      }
    }, {
      immediate: true,
      deep: true
    });
    var timeout;
    var changeActiveKeys = function changeActiveKeys(keys) {
      clearTimeout(timeout);
      timeout = setTimeout(function () {
        if (props.activeKey === undefined) {
          activeKeys.value = keys;
        }
        emit('update:activeKey', keys[keys.length - 1]);
      });
    };
    var disabled = (0, _vue.computed)(function () {
      return !!props.disabled;
    });
    var isRtl = (0, _vue.computed)(function () {
      return direction.value === 'rtl';
    });
    var mergedMode = (0, _vue.ref)('vertical');
    var mergedInlineCollapsed = (0, _vue.shallowRef)(false);
    (0, _vue.watchEffect)(function () {
      var _a;
      if ((props.mode === 'inline' || props.mode === 'vertical') && inlineCollapsed.value) {
        mergedMode.value = 'vertical';
        mergedInlineCollapsed.value = inlineCollapsed.value;
      } else {
        mergedMode.value = props.mode;
        mergedInlineCollapsed.value = false;
      }
      if ((_a = override === null || override === void 0 ? void 0 : override.mode) === null || _a === void 0 ? void 0 : _a.value) {
        mergedMode.value = override.mode.value;
      }
    });
    var isInlineMode = (0, _vue.computed)(function () {
      return mergedMode.value === 'inline';
    });
    var triggerOpenKeys = function triggerOpenKeys(keys) {
      mergedOpenKeys.value = keys;
      emit('update:openKeys', keys);
      emit('openChange', keys);
    };
    // >>>>> Cache & Reset open keys when inlineCollapsed changed
    var inlineCacheOpenKeys = (0, _vue.ref)(mergedOpenKeys.value);
    var mountRef = (0, _vue.shallowRef)(false);
    // Cache
    (0, _vue.watch)(mergedOpenKeys, function () {
      if (isInlineMode.value) {
        inlineCacheOpenKeys.value = mergedOpenKeys.value;
      }
    }, {
      immediate: true
    });
    // Restore
    (0, _vue.watch)(isInlineMode, function () {
      if (!mountRef.value) {
        mountRef.value = true;
        return;
      }
      if (isInlineMode.value) {
        mergedOpenKeys.value = inlineCacheOpenKeys.value;
      } else {
        // Trigger open event in case its in control
        triggerOpenKeys(EMPTY_LIST);
      }
    }, {
      immediate: true
    });
    var className = (0, _vue.computed)(function () {
      var _ref2;
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-root"), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-").concat(mergedMode.value), true), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-inline-collapsed"), mergedInlineCollapsed.value), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-rtl"), isRtl.value), (0, _defineProperty2.default)(_ref2, "".concat(prefixCls.value, "-").concat(props.theme), true), _ref2;
    });
    var rootPrefixCls = (0, _vue.computed)(function () {
      return getPrefixCls();
    });
    var defaultMotions = (0, _vue.computed)(function () {
      return {
        horizontal: {
          name: "".concat(rootPrefixCls.value, "-slide-up")
        },
        inline: _collapseMotion.default,
        other: {
          name: "".concat(rootPrefixCls.value, "-zoom-big")
        }
      };
    });
    (0, _useMenuContext.useProvideFirstLevel)(true);
    var getChildrenKeys = function getChildrenKeys() {
      var eventKeys = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : [];
      var keys = [];
      var storeValue = store.value;
      eventKeys.forEach(function (eventKey) {
        var _storeValue$get = storeValue.get(eventKey),
          key = _storeValue$get.key,
          childrenEventKeys = _storeValue$get.childrenEventKeys;
        keys.push.apply(keys, [key].concat((0, _toConsumableArray2.default)(getChildrenKeys((0, _vue.unref)(childrenEventKeys)))));
      });
      return keys;
    };
    // ========================= Open =========================
    /**
     * Click for item. SubMenu do not have selection status
     */
    var onInternalClick = function onInternalClick(info) {
      var _a;
      emit('click', info);
      triggerSelection(info);
      (_a = override === null || override === void 0 ? void 0 : override.onClick) === null || _a === void 0 ? void 0 : _a.call(override);
    };
    var onInternalOpenChange = function onInternalOpenChange(key, open) {
      var _a;
      var childrenEventKeys = ((_a = keyMapStore.value[key]) === null || _a === void 0 ? void 0 : _a.childrenEventKeys) || [];
      var newOpenKeys = mergedOpenKeys.value.filter(function (k) {
        return k !== key;
      });
      if (open) {
        newOpenKeys.push(key);
      } else if (mergedMode.value !== 'inline') {
        // We need find all related popup to close
        var subPathKeys = getChildrenKeys((0, _vue.unref)(childrenEventKeys));
        newOpenKeys = (0, _uniq.default)(newOpenKeys.filter(function (k) {
          return !subPathKeys.includes(k);
        }));
      }
      if (!(0, _shallowequal.default)(mergedOpenKeys, newOpenKeys)) {
        triggerOpenKeys(newOpenKeys);
      }
    };
    var registerMenuInfo = function registerMenuInfo(key, info) {
      store.value.set(key, info);
      store.value = new Map(store.value);
    };
    var unRegisterMenuInfo = function unRegisterMenuInfo(key) {
      store.value.delete(key);
      store.value = new Map(store.value);
    };
    var lastVisibleIndex = (0, _vue.ref)(0);
    var expandIcon = (0, _vue.computed)(function () {
      var _a;
      return props.expandIcon || slots.expandIcon || ((_a = override === null || override === void 0 ? void 0 : override.expandIcon) === null || _a === void 0 ? void 0 : _a.value) ? function (opt) {
        var icon = props.expandIcon || slots.expandIcon;
        icon = typeof icon === 'function' ? icon(opt) : icon;
        return (0, _vnode.cloneElement)(icon, {
          class: "".concat(prefixCls.value, "-submenu-expand-icon")
        }, false);
      } : null;
    });
    (0, _useMenuContext.default)({
      prefixCls: prefixCls,
      activeKeys: activeKeys,
      openKeys: mergedOpenKeys,
      selectedKeys: mergedSelectedKeys,
      changeActiveKeys: changeActiveKeys,
      disabled: disabled,
      rtl: isRtl,
      mode: mergedMode,
      inlineIndent: (0, _vue.computed)(function () {
        return props.inlineIndent;
      }),
      subMenuCloseDelay: (0, _vue.computed)(function () {
        return props.subMenuCloseDelay;
      }),
      subMenuOpenDelay: (0, _vue.computed)(function () {
        return props.subMenuOpenDelay;
      }),
      builtinPlacements: (0, _vue.computed)(function () {
        return props.builtinPlacements;
      }),
      triggerSubMenuAction: (0, _vue.computed)(function () {
        return props.triggerSubMenuAction;
      }),
      getPopupContainer: (0, _vue.computed)(function () {
        return props.getPopupContainer;
      }),
      inlineCollapsed: mergedInlineCollapsed,
      theme: (0, _vue.computed)(function () {
        return props.theme;
      }),
      siderCollapsed: siderCollapsed,
      defaultMotions: (0, _vue.computed)(function () {
        return isMounted.value ? defaultMotions.value : null;
      }),
      motion: (0, _vue.computed)(function () {
        return isMounted.value ? props.motion : null;
      }),
      overflowDisabled: (0, _vue.shallowRef)(undefined),
      onOpenChange: onInternalOpenChange,
      onItemClick: onInternalClick,
      registerMenuInfo: registerMenuInfo,
      unRegisterMenuInfo: unRegisterMenuInfo,
      selectedSubMenuKeys: selectedSubMenuKeys,
      expandIcon: expandIcon,
      forceSubMenuRender: (0, _vue.computed)(function () {
        return props.forceSubMenuRender;
      }),
      rootClassName: hashId
    });
    return function () {
      var _a, _b;
      var childList = itemsNodes.value || (0, _propsUtil.flattenChildren)((_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots));
      var allVisible = lastVisibleIndex.value >= childList.length - 1 || mergedMode.value !== 'horizontal' || props.disabledOverflow;
      // >>>>> Children
      var wrappedChildList = mergedMode.value !== 'horizontal' || props.disabledOverflow ? childList :
      // Need wrap for overflow dropdown that do not response for open
      childList.map(function (child, index) {
        return (// Always wrap provider to avoid sub node re-mount
          (0, _vue.createVNode)(_useMenuContext.MenuContextProvider, {
            "key": child.key,
            "overflowDisabled": index > lastVisibleIndex.value
          }, {
            default: function _default() {
              return child;
            }
          })
        );
      });
      var overflowedIndicator = ((_b = slots.overflowedIndicator) === null || _b === void 0 ? void 0 : _b.call(slots)) || (0, _vue.createVNode)(_EllipsisOutlined.default, null, null);
      return wrapSSR((0, _vue.createVNode)(_vcOverflow.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "onMousedown": props.onMousedown,
        "prefixCls": "".concat(prefixCls.value, "-overflow"),
        "component": "ul",
        "itemComponent": _MenuItem.default,
        "class": [className.value, attrs.class, hashId.value],
        "role": "menu",
        "id": props.id,
        "data": wrappedChildList,
        "renderRawItem": function renderRawItem(node) {
          return node;
        },
        "renderRawRest": function renderRawRest(omitItems) {
          // We use origin list since wrapped list use context to prevent open
          var len = omitItems.length;
          var originOmitItems = len ? childList.slice(-len) : null;
          return (0, _vue.createVNode)(_vue.Fragment, null, [(0, _vue.createVNode)(_SubMenu.default, {
            "eventKey": _useKeyPath.OVERFLOW_KEY,
            "key": _useKeyPath.OVERFLOW_KEY,
            "title": overflowedIndicator,
            "disabled": allVisible,
            "internalPopupClose": len === 0
          }, {
            default: function _default() {
              return originOmitItems;
            }
          }), (0, _vue.createVNode)(_useKeyPath.PathContext, null, {
            default: function _default() {
              return [(0, _vue.createVNode)(_SubMenu.default, {
                "eventKey": _useKeyPath.OVERFLOW_KEY,
                "key": _useKeyPath.OVERFLOW_KEY,
                "title": overflowedIndicator,
                "disabled": allVisible,
                "internalPopupClose": len === 0
              }, {
                default: function _default() {
                  return originOmitItems;
                }
              })];
            }
          })]);
        },
        "maxCount": mergedMode.value !== 'horizontal' || props.disabledOverflow ? _vcOverflow.default.INVALIDATE : _vcOverflow.default.RESPONSIVE,
        "ssr": "full",
        "data-menu-list": true,
        "onVisibleChange": function onVisibleChange(newLastIndex) {
          lastVisibleIndex.value = newLastIndex;
        }
      }), {
        default: function _default() {
          return [(0, _vue.createVNode)(_vue.Teleport, {
            "to": "body"
          }, {
            default: function _default() {
              return [(0, _vue.createVNode)("div", {
                "style": {
                  display: 'none'
                },
                "aria-hidden": true
              }, [(0, _vue.createVNode)(_useKeyPath.PathContext, null, {
                default: function _default() {
                  return [wrappedChildList];
                }
              })])];
            }
          })];
        }
      }));
    };
  }
});
exports.default = _default2;