"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends7 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _tinycolor = require("@ctrl/tinycolor");
var _motion = require("../../style/motion");
var _internal = require("../../theme/internal");
var _horizontal = _interopRequireDefault(require("./horizontal"));
var _rtl = _interopRequireDefault(require("./rtl"));
var _theme = _interopRequireDefault(require("./theme"));
var _vertical = _interopRequireDefault(require("./vertical"));
var _style = require("../../style");
require("vue");
var genMenuItemStyle = function genMenuItemStyle(token) {
  var _$concat$concat, _ref;
  var componentCls = token.componentCls,
    fontSize = token.fontSize,
    motionDurationSlow = token.motionDurationSlow,
    motionDurationMid = token.motionDurationMid,
    motionEaseInOut = token.motionEaseInOut,
    motionEaseOut = token.motionEaseOut,
    iconCls = token.iconCls,
    controlHeightSM = token.controlHeightSM;
  return _ref = {}, (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu-title"), (_$concat$concat = {
    position: 'relative',
    display: 'block',
    margin: 0,
    whiteSpace: 'nowrap',
    cursor: 'pointer',
    transition: ["border-color ".concat(motionDurationSlow), "background ".concat(motionDurationSlow), "padding ".concat(motionDurationSlow, " ").concat(motionEaseInOut)].join(',')
  }, (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    minWidth: fontSize,
    fontSize: fontSize,
    transition: ["font-size ".concat(motionDurationMid, " ").concat(motionEaseOut), "margin ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "color ".concat(motionDurationSlow)].join(','),
    '+ span': {
      marginInlineStart: controlHeightSM - fontSize,
      opacity: 1,
      transition: ["opacity ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "margin ".concat(motionDurationSlow), "color ".concat(motionDurationSlow)].join(',')
    }
  }), (0, _defineProperty2.default)(_$concat$concat, "".concat(componentCls, "-item-icon"), (0, _extends7.default)({}, (0, _style.resetIcon)())), (0, _defineProperty2.default)(_$concat$concat, "&".concat(componentCls, "-item-only-child"), (0, _defineProperty2.default)({}, "> ".concat(iconCls, ", > ").concat(componentCls, "-item-icon"), {
    marginInlineEnd: 0
  })), _$concat$concat)), (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-item-disabled, ").concat(componentCls, "-submenu-disabled"), (0, _defineProperty2.default)({
    background: 'none !important',
    cursor: 'not-allowed',
    '&::after': {
      borderColor: 'transparent !important'
    },
    a: {
      color: 'inherit !important'
    }
  }, "> ".concat(componentCls, "-submenu-title"), {
    color: 'inherit !important',
    cursor: 'not-allowed'
  })), _ref;
};
var genSubMenuArrowStyle = function genSubMenuArrowStyle(token) {
  var _$concat2;
  var componentCls = token.componentCls,
    motionDurationSlow = token.motionDurationSlow,
    motionEaseInOut = token.motionEaseInOut,
    borderRadius = token.borderRadius,
    menuArrowSize = token.menuArrowSize,
    menuArrowOffset = token.menuArrowOffset;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-submenu"), (_$concat2 = {}, (0, _defineProperty2.default)(_$concat2, "&-expand-icon, &-arrow", {
    position: 'absolute',
    top: '50%',
    insetInlineEnd: token.margin,
    width: menuArrowSize,
    color: 'currentcolor',
    transform: 'translateY(-50%)',
    transition: "transform ".concat(motionDurationSlow, " ").concat(motionEaseInOut, ", opacity ").concat(motionDurationSlow)
  }), (0, _defineProperty2.default)(_$concat2, '&-arrow', {
    // →
    '&::before, &::after': {
      position: 'absolute',
      width: menuArrowSize * 0.6,
      height: menuArrowSize * 0.15,
      backgroundColor: 'currentcolor',
      borderRadius: borderRadius,
      transition: ["background ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "transform ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "top ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "color ".concat(motionDurationSlow, " ").concat(motionEaseInOut)].join(','),
      content: '""'
    },
    '&::before': {
      transform: "rotate(45deg) translateY(-".concat(menuArrowOffset, ")")
    },
    '&::after': {
      transform: "rotate(-45deg) translateY(".concat(menuArrowOffset, ")")
    }
  }), _$concat2));
};
// =============================== Base ===============================
var getBaseStyle = function getBaseStyle(token) {
  var _extends3, _extends4, _extends5, _extends6;
  var antCls = token.antCls,
    componentCls = token.componentCls,
    fontSize = token.fontSize,
    motionDurationSlow = token.motionDurationSlow,
    motionDurationMid = token.motionDurationMid,
    motionEaseInOut = token.motionEaseInOut,
    lineHeight = token.lineHeight,
    paddingXS = token.paddingXS,
    padding = token.padding,
    colorSplit = token.colorSplit,
    lineWidth = token.lineWidth,
    zIndexPopup = token.zIndexPopup,
    borderRadiusLG = token.borderRadiusLG,
    radiusSubMenuItem = token.radiusSubMenuItem,
    menuArrowSize = token.menuArrowSize,
    menuArrowOffset = token.menuArrowOffset,
    lineType = token.lineType,
    menuPanelMaskInset = token.menuPanelMaskInset;
  return [// Misc
  (0, _defineProperty2.default)({
    '': (0, _defineProperty2.default)({}, "".concat(componentCls), (0, _extends7.default)((0, _extends7.default)({}, (0, _style.clearFix)()), (0, _defineProperty2.default)({}, "&-hidden", {
      display: 'none'
    })))
  }, "".concat(componentCls, "-submenu-hidden"), {
    display: 'none'
  }), (0, _defineProperty2.default)({}, componentCls, (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({}, (0, _style.resetComponent)(token)), (0, _style.clearFix)()), (_extends3 = {
    marginBottom: 0,
    paddingInlineStart: 0,
    // Override default ul/ol
    fontSize: fontSize,
    lineHeight: 0,
    listStyle: 'none',
    outline: 'none',
    transition: ["background ".concat(motionDurationSlow), // Magic cubic here but smooth transition
    "width ".concat(motionDurationSlow, " cubic-bezier(0.2, 0, 0, 1) 0s")].join(',')
  }, (0, _defineProperty2.default)(_extends3, "ul, ol", {
    margin: 0,
    padding: 0,
    listStyle: 'none'
  }), (0, _defineProperty2.default)(_extends3, "&-overflow", (0, _defineProperty2.default)({
    display: 'flex'
  }, "".concat(componentCls, "-item"), {
    flex: 'none'
  })), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu, ").concat(componentCls, "-submenu-title"), {
    borderRadius: token.radiusItem
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item-group-title"), {
    padding: "".concat(paddingXS, "px ").concat(padding, "px"),
    fontSize: fontSize,
    lineHeight: lineHeight,
    transition: "all ".concat(motionDurationSlow)
  }), (0, _defineProperty2.default)(_extends3, "&-horizontal ".concat(componentCls, "-submenu"), {
    transition: ["border-color ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "background ".concat(motionDurationSlow, " ").concat(motionEaseInOut)].join(',')
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-submenu, ").concat(componentCls, "-submenu-inline"), {
    transition: ["border-color ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "background ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "padding ".concat(motionDurationMid, " ").concat(motionEaseInOut)].join(',')
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-submenu ").concat(componentCls, "-sub"), {
    cursor: 'initial',
    transition: ["background ".concat(motionDurationSlow, " ").concat(motionEaseInOut), "padding ".concat(motionDurationSlow, " ").concat(motionEaseInOut)].join(',')
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-title-content"), {
    transition: "color ".concat(motionDurationSlow)
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item a"), {
    '&::before': {
      position: 'absolute',
      inset: 0,
      backgroundColor: 'transparent',
      content: '""'
    }
  }), (0, _defineProperty2.default)(_extends3, "".concat(componentCls, "-item-divider"), {
    overflow: 'hidden',
    lineHeight: 0,
    borderColor: colorSplit,
    borderStyle: lineType,
    borderWidth: 0,
    borderTopWidth: lineWidth,
    marginBlock: lineWidth,
    padding: 0,
    '&-dashed': {
      borderStyle: 'dashed'
    }
  }), _extends3)), genMenuItemStyle(token)), (_extends5 = {}, (0, _defineProperty2.default)(_extends5, "".concat(componentCls, "-item-group"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-group-list"), (0, _defineProperty2.default)({
    margin: 0,
    padding: 0
  }, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu-title"), {
    paddingInline: "".concat(fontSize * 2, "px ").concat(padding, "px")
  }))), (0, _defineProperty2.default)(_extends5, '&-submenu', (0, _defineProperty2.default)({
    '&-popup': {
      position: 'absolute',
      zIndex: zIndexPopup,
      background: 'transparent',
      borderRadius: borderRadiusLG,
      boxShadow: 'none',
      transformOrigin: '0 0',
      // https://github.com/ant-design/ant-design/issues/13955
      '&::before': {
        position: 'absolute',
        inset: "".concat(menuPanelMaskInset, "px 0 0"),
        zIndex: -1,
        width: '100%',
        height: '100%',
        opacity: 0,
        content: '""'
      }
    },
    // https://github.com/ant-design/ant-design/issues/13955
    '&-placement-rightTop::before': {
      top: 0,
      insetInlineStart: menuPanelMaskInset
    }
  }, "> ".concat(componentCls), (0, _extends7.default)((0, _extends7.default)((0, _extends7.default)({
    borderRadius: borderRadiusLG
  }, genMenuItemStyle(token)), genSubMenuArrowStyle(token)), (_extends4 = {}, (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), {
    borderRadius: radiusSubMenuItem
  }), (0, _defineProperty2.default)(_extends4, "".concat(componentCls, "-submenu-title::after"), {
    transition: "transform ".concat(motionDurationSlow, " ").concat(motionEaseInOut)
  }), _extends4)))), _extends5)), genSubMenuArrowStyle(token)), (_extends6 = {}, (0, _defineProperty2.default)(_extends6, "&-inline-collapsed ".concat(componentCls, "-submenu-arrow,\n        &-inline ").concat(componentCls, "-submenu-arrow"), {
    // ↓
    '&::before': {
      transform: "rotate(-45deg) translateX(".concat(menuArrowOffset, ")")
    },
    '&::after': {
      transform: "rotate(45deg) translateX(-".concat(menuArrowOffset, ")")
    }
  }), (0, _defineProperty2.default)(_extends6, "".concat(componentCls, "-submenu-open").concat(componentCls, "-submenu-inline > ").concat(componentCls, "-submenu-title > ").concat(componentCls, "-submenu-arrow"), {
    // ↑
    transform: "translateY(-".concat(menuArrowSize * 0.2, "px)"),
    '&::after': {
      transform: "rotate(-45deg) translateX(-".concat(menuArrowOffset, ")")
    },
    '&::before': {
      transform: "rotate(45deg) translateX(".concat(menuArrowOffset, ")")
    }
  }), _extends6))), // Integration with header element so menu items have the same height
  (0, _defineProperty2.default)({}, "".concat(antCls, "-layout-header"), (0, _defineProperty2.default)({}, componentCls, {
    lineHeight: 'inherit'
  }))];
};
// ============================== Export ==============================
var _default = function _default(prefixCls, injectStyle) {
  var useOriginHook = (0, _internal.genComponentStyleHook)('Menu', function (token, _ref7) {
    var overrideComponentToken = _ref7.overrideComponentToken;
    // Dropdown will handle menu style self. We do not need to handle this.
    if ((injectStyle === null || injectStyle === void 0 ? void 0 : injectStyle.value) === false) {
      return [];
    }
    var colorBgElevated = token.colorBgElevated,
      colorPrimary = token.colorPrimary,
      colorError = token.colorError,
      colorErrorHover = token.colorErrorHover,
      colorTextLightSolid = token.colorTextLightSolid;
    var controlHeightLG = token.controlHeightLG,
      fontSize = token.fontSize;
    var menuArrowSize = fontSize / 7 * 5;
    // Menu Token
    var menuToken = (0, _internal.mergeToken)(token, {
      menuItemHeight: controlHeightLG,
      menuItemPaddingInline: token.margin,
      menuArrowSize: menuArrowSize,
      menuHorizontalHeight: controlHeightLG * 1.15,
      menuArrowOffset: "".concat(menuArrowSize * 0.25, "px"),
      menuPanelMaskInset: -7,
      menuSubMenuBg: colorBgElevated
    });
    var colorTextDark = new _tinycolor.TinyColor(colorTextLightSolid).setAlpha(0.65).toRgbString();
    var menuDarkToken = (0, _internal.mergeToken)(menuToken, {
      colorItemText: colorTextDark,
      colorItemTextHover: colorTextLightSolid,
      colorGroupTitle: colorTextDark,
      colorItemTextSelected: colorTextLightSolid,
      colorItemBg: '#001529',
      colorSubItemBg: '#000c17',
      colorItemBgActive: 'transparent',
      colorItemBgSelected: colorPrimary,
      colorActiveBarWidth: 0,
      colorActiveBarHeight: 0,
      colorActiveBarBorderSize: 0,
      // Disabled
      colorItemTextDisabled: new _tinycolor.TinyColor(colorTextLightSolid).setAlpha(0.25).toRgbString(),
      // Danger
      colorDangerItemText: colorError,
      colorDangerItemTextHover: colorErrorHover,
      colorDangerItemTextSelected: colorTextLightSolid,
      colorDangerItemBgActive: colorError,
      colorDangerItemBgSelected: colorError,
      menuSubMenuBg: '#001529',
      // Horizontal
      colorItemTextSelectedHorizontal: colorTextLightSolid,
      colorItemBgSelectedHorizontal: colorPrimary
    }, (0, _extends7.default)({}, overrideComponentToken));
    return [
    // Basic
    getBaseStyle(menuToken),
    // Horizontal
    (0, _horizontal.default)(menuToken),
    // Vertical
    (0, _vertical.default)(menuToken),
    // Theme
    (0, _theme.default)(menuToken, 'light'), (0, _theme.default)(menuDarkToken, 'dark'),
    // RTL
    (0, _rtl.default)(menuToken),
    // Motion
    (0, _motion.genCollapseMotion)(menuToken), (0, _motion.initSlideMotion)(menuToken, 'slide-up'), (0, _motion.initSlideMotion)(menuToken, 'slide-down'), (0, _motion.initZoomMotion)(menuToken, 'zoom-big')];
  }, function (token) {
    var colorPrimary = token.colorPrimary,
      colorError = token.colorError,
      colorTextDisabled = token.colorTextDisabled,
      colorErrorBg = token.colorErrorBg,
      colorText = token.colorText,
      colorTextDescription = token.colorTextDescription,
      colorBgContainer = token.colorBgContainer,
      colorFillAlter = token.colorFillAlter,
      colorFillContent = token.colorFillContent,
      lineWidth = token.lineWidth,
      lineWidthBold = token.lineWidthBold,
      controlItemBgActive = token.controlItemBgActive,
      colorBgTextHover = token.colorBgTextHover;
    return {
      dropdownWidth: 160,
      zIndexPopup: token.zIndexPopupBase + 50,
      radiusItem: token.borderRadiusLG,
      radiusSubMenuItem: token.borderRadiusSM,
      colorItemText: colorText,
      colorItemTextHover: colorText,
      colorItemTextHoverHorizontal: colorPrimary,
      colorGroupTitle: colorTextDescription,
      colorItemTextSelected: colorPrimary,
      colorItemTextSelectedHorizontal: colorPrimary,
      colorItemBg: colorBgContainer,
      colorItemBgHover: colorBgTextHover,
      colorItemBgActive: colorFillContent,
      colorSubItemBg: colorFillAlter,
      colorItemBgSelected: controlItemBgActive,
      colorItemBgSelectedHorizontal: 'transparent',
      colorActiveBarWidth: 0,
      colorActiveBarHeight: lineWidthBold,
      colorActiveBarBorderSize: lineWidth,
      // Disabled
      colorItemTextDisabled: colorTextDisabled,
      // Danger
      colorDangerItemText: colorError,
      colorDangerItemTextHover: colorError,
      colorDangerItemTextSelected: colorError,
      colorDangerItemBgActive: colorErrorBg,
      colorDangerItemBgSelected: colorErrorBg,
      itemMarginInline: token.marginXXS
    };
  });
  return useOriginHook(prefixCls);
};
exports.default = _default;