"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends3 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _style = require("../../style");
var getVerticalInlineStyle = function getVerticalInlineStyle(token) {
  var _ref;
  var componentCls = token.componentCls,
    menuItemHeight = token.menuItemHeight,
    itemMarginInline = token.itemMarginInline,
    padding = token.padding,
    menuArrowSize = token.menuArrowSize,
    marginXS = token.marginXS,
    marginXXS = token.marginXXS;
  var paddingWithArrow = padding + menuArrowSize + marginXS;
  return _ref = {}, (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-item"), {
    position: 'relative'
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu-title"), {
    height: menuItemHeight,
    lineHeight: "".concat(menuItemHeight, "px"),
    paddingInline: padding,
    overflow: 'hidden',
    textOverflow: 'ellipsis',
    marginInline: itemMarginInline,
    marginBlock: marginXXS,
    width: "calc(100% - ".concat(itemMarginInline * 2, "px)")
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-submenu"), {
    paddingBottom: 0.02
  }), (0, _defineProperty2.default)(_ref, "> ".concat(componentCls, "-item,\n            > ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), {
    height: menuItemHeight,
    lineHeight: "".concat(menuItemHeight, "px")
  }), (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-item-group-list ").concat(componentCls, "-submenu-title,\n            ").concat(componentCls, "-submenu-title"), {
    paddingInlineEnd: paddingWithArrow
  }), _ref;
};
var getVerticalStyle = function getVerticalStyle(token) {
  var _ref2, _$concat$concat, _$concat$concat2, _$concat3, _$concat$concat$con, _tooltip, _$concat5;
  var componentCls = token.componentCls,
    iconCls = token.iconCls,
    menuItemHeight = token.menuItemHeight,
    colorTextLightSolid = token.colorTextLightSolid,
    dropdownWidth = token.dropdownWidth,
    controlHeightLG = token.controlHeightLG,
    motionDurationMid = token.motionDurationMid,
    motionEaseOut = token.motionEaseOut,
    paddingXL = token.paddingXL,
    fontSizeSM = token.fontSizeSM,
    fontSizeLG = token.fontSizeLG,
    motionDurationSlow = token.motionDurationSlow,
    paddingXS = token.paddingXS,
    boxShadowSecondary = token.boxShadowSecondary;
  var inlineItemStyle = {
    height: menuItemHeight,
    lineHeight: "".concat(menuItemHeight, "px"),
    listStylePosition: 'inside',
    listStyleType: 'disc'
  };
  return [(_ref2 = {}, (0, _defineProperty2.default)(_ref2, componentCls, (0, _defineProperty2.default)({}, "&-inline, &-vertical", (0, _extends3.default)((0, _defineProperty2.default)({}, "&".concat(componentCls, "-root"), {
    boxShadow: 'none'
  }), getVerticalInlineStyle(token)))), (0, _defineProperty2.default)(_ref2, "".concat(componentCls, "-submenu-popup"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-vertical"), (0, _extends3.default)((0, _extends3.default)({}, getVerticalInlineStyle(token)), {
    boxShadow: boxShadowSecondary
  }))), _ref2), // Vertical only
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-submenu-popup ").concat(componentCls, "-vertical").concat(componentCls, "-sub"), {
    minWidth: dropdownWidth,
    maxHeight: "calc(100vh - ".concat(controlHeightLG * 2.5, "px)"),
    padding: '0',
    overflow: 'hidden',
    borderInlineEnd: 0,
    // https://github.com/ant-design/ant-design/issues/22244
    // https://github.com/ant-design/ant-design/issues/26812
    "&:not([class*='-active'])": {
      overflowX: 'hidden',
      overflowY: 'auto'
    }
  }), // Inline Only
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-inline"), (_$concat3 = {
    width: '100%'
  }, (0, _defineProperty2.default)(_$concat3, "&".concat(componentCls, "-root"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu-title"), (_$concat$concat = {
    display: 'flex',
    alignItems: 'center',
    transition: ["border-color ".concat(motionDurationSlow), "background ".concat(motionDurationSlow), "padding ".concat(motionDurationMid, " ").concat(motionEaseOut)].join(',')
  }, (0, _defineProperty2.default)(_$concat$concat, "> ".concat(componentCls, "-title-content"), {
    flex: 'auto',
    minWidth: 0,
    overflow: 'hidden',
    textOverflow: 'ellipsis'
  }), (0, _defineProperty2.default)(_$concat$concat, '> *', {
    flex: 'none'
  }), _$concat$concat))), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-sub").concat(componentCls, "-inline"), (_$concat$concat2 = {
    padding: 0,
    border: 0,
    borderRadius: 0,
    boxShadow: 'none'
  }, (0, _defineProperty2.default)(_$concat$concat2, "& > ".concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), inlineItemStyle), (0, _defineProperty2.default)(_$concat$concat2, "& ".concat(componentCls, "-item-group-title"), {
    paddingInlineStart: paddingXL
  }), _$concat$concat2)), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item"), inlineItemStyle), _$concat3)), // Inline Collapse Only
  (0, _defineProperty2.default)({}, "".concat(componentCls, "-inline-collapsed"), (_$concat5 = {
    width: menuItemHeight * 2
  }, (0, _defineProperty2.default)(_$concat5, "&".concat(componentCls, "-root"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item, ").concat(componentCls, "-submenu ").concat(componentCls, "-submenu-title"), (0, _defineProperty2.default)({}, "> ".concat(componentCls, "-inline-collapsed-noicon"), {
    fontSize: fontSizeLG,
    textAlign: 'center'
  }))), (0, _defineProperty2.default)(_$concat5, "> ".concat(componentCls, "-item,\n          > ").concat(componentCls, "-item-group > ").concat(componentCls, "-item-group-list > ").concat(componentCls, "-item,\n          > ").concat(componentCls, "-item-group > ").concat(componentCls, "-item-group-list > ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title,\n          > ").concat(componentCls, "-submenu > ").concat(componentCls, "-submenu-title"), (_$concat$concat$con = {
    insetInlineStart: 0,
    paddingInline: "calc(50% - ".concat(fontSizeSM, "px)"),
    textOverflow: 'clip'
  }, (0, _defineProperty2.default)(_$concat$concat$con, "\n            ".concat(componentCls, "-submenu-arrow,\n            ").concat(componentCls, "-submenu-expand-icon\n          "), {
    opacity: 0
  }), (0, _defineProperty2.default)(_$concat$concat$con, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    margin: 0,
    fontSize: fontSizeLG,
    lineHeight: "".concat(menuItemHeight, "px"),
    '+ span': {
      display: 'inline-block',
      opacity: 0
    }
  }), _$concat$concat$con)), (0, _defineProperty2.default)(_$concat5, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    display: 'inline-block'
  }), (0, _defineProperty2.default)(_$concat5, '&-tooltip', (_tooltip = {
    pointerEvents: 'none'
  }, (0, _defineProperty2.default)(_tooltip, "".concat(componentCls, "-item-icon, ").concat(iconCls), {
    display: 'none'
  }), (0, _defineProperty2.default)(_tooltip, 'a, a:hover', {
    color: colorTextLightSolid
  }), _tooltip)), (0, _defineProperty2.default)(_$concat5, "".concat(componentCls, "-item-group-title"), (0, _extends3.default)((0, _extends3.default)({}, _style.textEllipsis), {
    paddingInline: paddingXS
  })), _$concat5))];
};
var _default = getVerticalStyle;
exports.default = _default;