"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _context = require("../../config-provider/context");
var _LocaleReceiver = require("../../locale-provider/LocaleReceiver");
var _en_US = _interopRequireDefault(require("../../locale/en_US"));
var _ConfirmDialog = _interopRequireDefault(require("../ConfirmDialog"));
var _initDefaultProps = _interopRequireDefault(require("../../_util/props-util/initDefaultProps"));
var comfirmFuncProps = function comfirmFuncProps() {
  return {
    config: Object,
    afterClose: Function,
    destroyAction: Function,
    open: Boolean
  };
};
var _default = (0, _vue.defineComponent)({
  name: 'HookModal',
  inheritAttrs: false,
  props: (0, _initDefaultProps.default)(comfirmFuncProps(), {
    config: {
      width: 520,
      okType: 'primary'
    }
  }),
  setup: function setup(props, _ref) {
    var expose = _ref.expose;
    var _a;
    var open = (0, _vue.computed)(function () {
      return props.open;
    });
    var innerConfig = (0, _vue.computed)(function () {
      return props.config;
    });
    var _useConfigContextInje = (0, _context.useConfigContextInject)(),
      direction = _useConfigContextInje.direction,
      getPrefixCls = _useConfigContextInje.getPrefixCls;
    var prefixCls = getPrefixCls('modal');
    var rootPrefixCls = getPrefixCls();
    var afterClose = function afterClose() {
      var _a, _b;
      props === null || props === void 0 ? void 0 : props.afterClose();
      (_b = (_a = innerConfig.value).afterClose) === null || _b === void 0 ? void 0 : _b.call(_a);
    };
    var close = function close() {
      props.destroyAction.apply(props, arguments);
    };
    expose({
      destroy: close
    });
    var mergedOkCancel = (_a = innerConfig.value.okCancel) !== null && _a !== void 0 ? _a : innerConfig.value.type === 'confirm';
    var _useLocaleReceiver = (0, _LocaleReceiver.useLocaleReceiver)('Modal', _en_US.default.Modal),
      _useLocaleReceiver2 = (0, _slicedToArray2.default)(_useLocaleReceiver, 1),
      contextLocale = _useLocaleReceiver2[0];
    return function () {
      return (0, _vue.createVNode)(_ConfirmDialog.default, (0, _objectSpread2.default)((0, _objectSpread2.default)({
        "prefixCls": prefixCls,
        "rootPrefixCls": rootPrefixCls
      }, innerConfig.value), {}, {
        "close": close,
        "open": open.value,
        "afterClose": afterClose,
        "okText": innerConfig.value.okText || (mergedOkCancel ? contextLocale === null || contextLocale === void 0 ? void 0 : contextLocale.value.okText : contextLocale === null || contextLocale === void 0 ? void 0 : contextLocale.value.justOkText),
        "direction": innerConfig.value.direction || direction.value,
        "cancelText": innerConfig.value.cancelText || (contextLocale === null || contextLocale === void 0 ? void 0 : contextLocale.value.cancelText)
      }), null);
    };
  }
});
exports.default = _default;