"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _toConsumableArray2 = _interopRequireDefault(require("@babel/runtime/helpers/toConsumableArray"));
var _confirm = require("../confirm");
var _HookModal = _interopRequireDefault(require("./HookModal"));
var _destroyFns = _interopRequireDefault(require("../destroyFns"));
var uuid = 0;
var ElementsHolder = (0, _vue.defineComponent)({
  name: 'ElementsHolder',
  inheritAttrs: false,
  setup: function setup(_, _ref) {
    var expose = _ref.expose;
    var modals = (0, _vue.shallowRef)([]);
    var addModal = function addModal(modal) {
      modals.value.push(modal);
      modals.value = modals.value.slice();
      return function () {
        modals.value = modals.value.filter(function (currentModal) {
          return currentModal !== modal;
        });
      };
    };
    expose({
      addModal: addModal
    });
    return function () {
      return modals.value.map(function (modal) {
        return modal();
      });
    };
  }
});
function useModal() {
  var holderRef = (0, _vue.shallowRef)(null);
  // ========================== Effect ==========================
  var actionQueue = (0, _vue.shallowRef)([]);
  (0, _vue.watch)(actionQueue, function () {
    if (actionQueue.value.length) {
      var cloneQueue = (0, _toConsumableArray2.default)(actionQueue.value);
      cloneQueue.forEach(function (action) {
        action();
      });
      actionQueue.value = [];
    }
  }, {
    immediate: true
  });
  // =========================== Hook ===========================
  var getConfirmFunc = function getConfirmFunc(withFunc) {
    return function hookConfirm(config) {
      var _a;
      uuid += 1;
      var open = (0, _vue.shallowRef)(true);
      var modalRef = (0, _vue.shallowRef)(null);
      var configRef = (0, _vue.shallowRef)((0, _vue.unref)(config));
      var updateConfig = (0, _vue.shallowRef)({});
      (0, _vue.watch)(function () {
        return config;
      }, function (val) {
        updateAction((0, _extends2.default)((0, _extends2.default)({}, (0, _vue.isRef)(val) ? val.value : val), updateConfig.value));
      });
      var destroyAction = function destroyAction() {
        open.value = false;
        for (var _len = arguments.length, args = new Array(_len), _key = 0; _key < _len; _key++) {
          args[_key] = arguments[_key];
        }
        var triggerCancel = args.some(function (param) {
          return param && param.triggerCancel;
        });
        if (configRef.value.onCancel && triggerCancel) {
          var _configRef$value;
          (_configRef$value = configRef.value).onCancel.apply(_configRef$value, [function () {}].concat((0, _toConsumableArray2.default)(args.slice(1))));
        }
      };
      // eslint-disable-next-line prefer-const
      var closeFunc;
      var modal = function modal() {
        return (0, _vue.createVNode)(_HookModal.default, {
          "key": "modal-".concat(uuid),
          "config": withFunc(configRef.value),
          "ref": modalRef,
          "open": open.value,
          "destroyAction": destroyAction,
          "afterClose": function afterClose() {
            closeFunc === null || closeFunc === void 0 ? void 0 : closeFunc();
          }
        }, null);
      };
      closeFunc = (_a = holderRef.value) === null || _a === void 0 ? void 0 : _a.addModal(modal);
      if (closeFunc) {
        _destroyFns.default.push(closeFunc);
      }
      var updateAction = function updateAction(newConfig) {
        configRef.value = (0, _extends2.default)((0, _extends2.default)({}, configRef.value), newConfig);
      };
      var destroy = function destroy() {
        if (modalRef.value) {
          destroyAction();
        } else {
          actionQueue.value = [].concat((0, _toConsumableArray2.default)(actionQueue.value), [destroyAction]);
        }
      };
      var update = function update(newConfig) {
        updateConfig.value = newConfig;
        if (modalRef.value) {
          updateAction(newConfig);
        } else {
          actionQueue.value = [].concat((0, _toConsumableArray2.default)(actionQueue.value), [function () {
            return updateAction(newConfig);
          }]);
        }
      };
      return {
        destroy: destroy,
        update: update
      };
    };
  };
  var fns = (0, _vue.computed)(function () {
    return {
      info: getConfirmFunc(_confirm.withInfo),
      success: getConfirmFunc(_confirm.withSuccess),
      error: getConfirmFunc(_confirm.withError),
      warning: getConfirmFunc(_confirm.withWarn),
      confirm: getConfirmFunc(_confirm.withConfirm)
    };
  });
  return [fns.value, function () {
    return (0, _vue.createVNode)(ElementsHolder, {
      "key": "modal-holder",
      "ref": holderRef
    }, null);
  }];
}
var _default = useModal;
exports.default = _default;