"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInstance = exports.default = void 0;
var _vue = require("vue");
var _regenerator = _interopRequireDefault(require("@babel/runtime/regenerator"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _vcNotification = _interopRequireDefault(require("../vc-notification"));
var _CheckCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CheckCircleOutlined"));
var _InfoCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/InfoCircleOutlined"));
var _CloseCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseCircleOutlined"));
var _ExclamationCircleOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/ExclamationCircleOutlined"));
var _CloseOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/CloseOutlined"));
var _util = require("../_util/util");
var _configProvider = require("../config-provider");
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _style = _interopRequireDefault(require("./style"));
var __awaiter = void 0 && (void 0).__awaiter || function (thisArg, _arguments, P, generator) {
  function adopt(value) {
    return value instanceof P ? value : new P(function (resolve) {
      resolve(value);
    });
  }
  return new (P || (P = Promise))(function (resolve, reject) {
    function fulfilled(value) {
      try {
        step(generator.next(value));
      } catch (e) {
        reject(e);
      }
    }
    function rejected(value) {
      try {
        step(generator["throw"](value));
      } catch (e) {
        reject(e);
      }
    }
    function step(result) {
      result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected);
    }
    step((generator = generator.apply(thisArg, _arguments || [])).next());
  });
};
var notificationInstance = {};
var defaultDuration = 4.5;
var defaultTop = '24px';
var defaultBottom = '24px';
var defaultPrefixCls = '';
var defaultPlacement = 'topRight';
var defaultGetContainer = function defaultGetContainer() {
  return document.body;
};
var defaultCloseIcon = null;
var rtl = false;
var maxCount;
function setNotificationConfig(options) {
  var duration = options.duration,
    placement = options.placement,
    bottom = options.bottom,
    top = options.top,
    getContainer = options.getContainer,
    closeIcon = options.closeIcon,
    prefixCls = options.prefixCls;
  if (prefixCls !== undefined) {
    defaultPrefixCls = prefixCls;
  }
  if (duration !== undefined) {
    defaultDuration = duration;
  }
  if (placement !== undefined) {
    defaultPlacement = placement;
  }
  if (bottom !== undefined) {
    defaultBottom = typeof bottom === 'number' ? "".concat(bottom, "px") : bottom;
  }
  if (top !== undefined) {
    defaultTop = typeof top === 'number' ? "".concat(top, "px") : top;
  }
  if (getContainer !== undefined) {
    defaultGetContainer = getContainer;
  }
  if (closeIcon !== undefined) {
    defaultCloseIcon = closeIcon;
  }
  if (options.rtl !== undefined) {
    rtl = options.rtl;
  }
  if (options.maxCount !== undefined) {
    maxCount = options.maxCount;
  }
}
function getPlacementStyle(placement) {
  var top = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : defaultTop;
  var bottom = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : defaultBottom;
  var style;
  switch (placement) {
    case 'top':
      style = {
        left: '50%',
        transform: 'translateX(-50%)',
        right: 'auto',
        top: top,
        bottom: 'auto'
      };
      break;
    case 'topLeft':
      style = {
        left: '0px',
        top: top,
        bottom: 'auto'
      };
      break;
    case 'topRight':
      style = {
        right: '0px',
        top: top,
        bottom: 'auto'
      };
      break;
    case 'bottom':
      style = {
        left: '50%',
        transform: 'translateX(-50%)',
        right: 'auto',
        top: 'auto',
        bottom: bottom
      };
      break;
    case 'bottomLeft':
      style = {
        left: '0px',
        top: 'auto',
        bottom: bottom
      };
      break;
    default:
      style = {
        right: '0px',
        top: 'auto',
        bottom: bottom
      };
      break;
  }
  return style;
}
function getNotificationInstance(_ref, callback) {
  var customizePrefixCls = _ref.prefixCls,
    _ref$placement = _ref.placement,
    placement = _ref$placement === void 0 ? defaultPlacement : _ref$placement,
    _ref$getContainer = _ref.getContainer,
    getContainer = _ref$getContainer === void 0 ? defaultGetContainer : _ref$getContainer,
    top = _ref.top,
    bottom = _ref.bottom,
    _ref$closeIcon = _ref.closeIcon,
    _closeIcon = _ref$closeIcon === void 0 ? defaultCloseIcon : _ref$closeIcon,
    appContext = _ref.appContext;
  var _globalConfig = (0, _configProvider.globalConfig)(),
    getPrefixCls = _globalConfig.getPrefixCls;
  var prefixCls = getPrefixCls('notification', customizePrefixCls || defaultPrefixCls);
  var cacheKey = "".concat(prefixCls, "-").concat(placement, "-").concat(rtl);
  var cacheInstance = notificationInstance[cacheKey];
  if (cacheInstance) {
    Promise.resolve(cacheInstance).then(function (instance) {
      callback(instance);
    });
    return;
  }
  var notificationClass = (0, _classNames2.default)("".concat(prefixCls, "-").concat(placement), (0, _defineProperty2.default)({}, "".concat(prefixCls, "-rtl"), rtl === true));
  _vcNotification.default.newInstance({
    name: 'notification',
    prefixCls: customizePrefixCls || defaultPrefixCls,
    useStyle: _style.default,
    class: notificationClass,
    style: getPlacementStyle(placement, top, bottom),
    appContext: appContext,
    getContainer: getContainer,
    closeIcon: function closeIcon(_ref2) {
      var prefixCls = _ref2.prefixCls;
      var closeIconToRender = (0, _vue.createVNode)("span", {
        "class": "".concat(prefixCls, "-close-x")
      }, [(0, _util.renderHelper)(_closeIcon, {}, (0, _vue.createVNode)(_CloseOutlined.default, {
        "class": "".concat(prefixCls, "-close-icon")
      }, null))]);
      return closeIconToRender;
    },
    maxCount: maxCount,
    hasTransitionName: true
  }, function (notification) {
    notificationInstance[cacheKey] = notification;
    callback(notification);
  });
}
var typeToIcon = {
  success: _CheckCircleOutlined.default,
  info: _InfoCircleOutlined.default,
  error: _CloseCircleOutlined.default,
  warning: _ExclamationCircleOutlined.default
};
function notice(args) {
  var icon = args.icon,
    type = args.type,
    description = args.description,
    message = args.message,
    btn = args.btn;
  var duration = args.duration === undefined ? defaultDuration : args.duration;
  getNotificationInstance(args, function (notification) {
    notification.notice({
      content: function content(_ref3) {
        var outerPrefixCls = _ref3.prefixCls;
        var prefixCls = "".concat(outerPrefixCls, "-notice");
        var iconNode = null;
        if (icon) {
          iconNode = function iconNode() {
            return (0, _vue.createVNode)("span", {
              "class": "".concat(prefixCls, "-icon")
            }, [(0, _util.renderHelper)(icon)]);
          };
        } else if (type) {
          var Icon = typeToIcon[type];
          iconNode = function iconNode() {
            return (0, _vue.createVNode)(Icon, {
              "class": "".concat(prefixCls, "-icon ").concat(prefixCls, "-icon-").concat(type)
            }, null);
          };
        }
        return (0, _vue.createVNode)("div", {
          "class": iconNode ? "".concat(prefixCls, "-with-icon") : ''
        }, [iconNode && iconNode(), (0, _vue.createVNode)("div", {
          "class": "".concat(prefixCls, "-message")
        }, [!description && iconNode ? (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-message-single-line-auto-margin")
        }, null) : null, (0, _util.renderHelper)(message)]), (0, _vue.createVNode)("div", {
          "class": "".concat(prefixCls, "-description")
        }, [(0, _util.renderHelper)(description)]), btn ? (0, _vue.createVNode)("span", {
          "class": "".concat(prefixCls, "-btn")
        }, [(0, _util.renderHelper)(btn)]) : null]);
      },
      duration: duration,
      closable: true,
      onClose: args.onClose,
      onClick: args.onClick,
      key: args.key,
      style: args.style || {},
      class: args.class
    });
  });
}
var api = {
  open: notice,
  close: function close(key) {
    Object.keys(notificationInstance).forEach(function (cacheKey) {
      return Promise.resolve(notificationInstance[cacheKey]).then(function (instance) {
        instance.removeNotice(key);
      });
    });
  },
  config: setNotificationConfig,
  destroy: function destroy() {
    Object.keys(notificationInstance).forEach(function (cacheKey) {
      Promise.resolve(notificationInstance[cacheKey]).then(function (instance) {
        instance.destroy();
      });
      delete notificationInstance[cacheKey]; // lgtm[js/missing-await]
    });
  }
};

var iconTypes = ['success', 'info', 'warning', 'error'];
iconTypes.forEach(function (type) {
  api[type] = function (args) {
    return api.open((0, _extends2.default)((0, _extends2.default)({}, args), {
      type: type
    }));
  };
});
api.warn = api.warning;
/** @private test Only function. Not work on production */
var getInstance = function getInstance(cacheKey) {
  return __awaiter(void 0, void 0, void 0, /*#__PURE__*/_regenerator.default.mark(function _callee() {
    return _regenerator.default.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          return _context.abrupt("return", process.env.NODE_ENV === 'test' ? notificationInstance[cacheKey] : null);
        case 1:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
};
exports.getInstance = getInstance;
var _default = api;
exports.default = _default;