"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
var _typeof = require("@babel/runtime/helpers/typeof");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.paginationProps = exports.paginationConfig = exports.default = void 0;
var _vue = require("vue");
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _LeftOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/LeftOutlined"));
var _RightOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/RightOutlined"));
var _DoubleLeftOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/DoubleLeftOutlined"));
var _DoubleRightOutlined = _interopRequireDefault(require("@ant-design/icons-vue/lib/icons/DoubleRightOutlined"));
var _Select = _interopRequireWildcard(require("./Select"));
var _LocaleReceiver = require("../locale-provider/LocaleReceiver");
var _vcPagination = _interopRequireDefault(require("../vc-pagination"));
var _en_US = _interopRequireDefault(require("../vc-pagination/locale/en_US"));
var _classNames2 = _interopRequireDefault(require("../_util/classNames"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _useBreakpoint = _interopRequireDefault(require("../_util/hooks/useBreakpoint"));
var _type = require("../_util/type");
var _style = _interopRequireDefault(require("./style"));
function _getRequireWildcardCache(nodeInterop) { if (typeof WeakMap !== "function") return null; var cacheBabelInterop = new WeakMap(); var cacheNodeInterop = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(nodeInterop) { return nodeInterop ? cacheNodeInterop : cacheBabelInterop; })(nodeInterop); }
function _interopRequireWildcard(obj, nodeInterop) { if (!nodeInterop && obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { default: obj }; } var cache = _getRequireWildcardCache(nodeInterop); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (key !== "default" && Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj.default = obj; if (cache) { cache.set(obj, newObj); } return newObj; }
var __rest = void 0 && (void 0).__rest || function (s, e) {
  var t = {};
  for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p) && e.indexOf(p) < 0) t[p] = s[p];
  if (s != null && typeof Object.getOwnPropertySymbols === "function") for (var i = 0, p = Object.getOwnPropertySymbols(s); i < p.length; i++) {
    if (e.indexOf(p[i]) < 0 && Object.prototype.propertyIsEnumerable.call(s, p[i])) t[p[i]] = s[p[i]];
  }
  return t;
};

// CSSINJS

var paginationProps = function paginationProps() {
  return {
    total: Number,
    defaultCurrent: Number,
    disabled: (0, _type.booleanType)(),
    current: Number,
    defaultPageSize: Number,
    pageSize: Number,
    hideOnSinglePage: (0, _type.booleanType)(),
    showSizeChanger: (0, _type.booleanType)(),
    pageSizeOptions: (0, _type.arrayType)(),
    buildOptionText: (0, _type.functionType)(),
    showQuickJumper: (0, _type.someType)([Boolean, Object]),
    showTotal: (0, _type.functionType)(),
    size: (0, _type.stringType)(),
    simple: (0, _type.booleanType)(),
    locale: Object,
    prefixCls: String,
    selectPrefixCls: String,
    totalBoundaryShowSizeChanger: Number,
    selectComponentClass: String,
    itemRender: (0, _type.functionType)(),
    role: String,
    responsive: Boolean,
    showLessItems: (0, _type.booleanType)(),
    onChange: (0, _type.functionType)(),
    onShowSizeChange: (0, _type.functionType)(),
    'onUpdate:current': (0, _type.functionType)(),
    'onUpdate:pageSize': (0, _type.functionType)()
  };
};
exports.paginationProps = paginationProps;
var paginationConfig = function paginationConfig() {
  return (0, _extends2.default)((0, _extends2.default)({}, paginationProps()), {
    position: (0, _type.stringType)()
  });
};
exports.paginationConfig = paginationConfig;
var _default = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'APagination',
  inheritAttrs: false,
  props: paginationProps(),
  // emits: ['change', 'showSizeChange', 'update:current', 'update:pageSize'],
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('pagination', props),
      prefixCls = _useConfigInject.prefixCls,
      configProvider = _useConfigInject.configProvider,
      direction = _useConfigInject.direction;
    // style
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var selectPrefixCls = (0, _vue.computed)(function () {
      return configProvider.getPrefixCls('select', props.selectPrefixCls);
    });
    var breakpoint = (0, _useBreakpoint.default)();
    var _useLocaleReceiver = (0, _LocaleReceiver.useLocaleReceiver)('Pagination', _en_US.default, (0, _vue.toRef)(props, 'locale')),
      _useLocaleReceiver2 = (0, _slicedToArray2.default)(_useLocaleReceiver, 1),
      locale = _useLocaleReceiver2[0];
    var getIconsProps = function getIconsProps(pre) {
      var ellipsis = (0, _vue.createVNode)("span", {
        "class": "".concat(pre, "-item-ellipsis")
      }, [(0, _vue.createTextVNode)("\u2022\u2022\u2022")]);
      var prevIcon = (0, _vue.createVNode)("button", {
        "class": "".concat(pre, "-item-link"),
        "type": "button",
        "tabindex": -1
      }, [(0, _vue.createVNode)(_LeftOutlined.default, null, null)]);
      var nextIcon = (0, _vue.createVNode)("button", {
        "class": "".concat(pre, "-item-link"),
        "type": "button",
        "tabindex": -1
      }, [(0, _vue.createVNode)(_RightOutlined.default, null, null)]);
      var jumpPrevIcon = (0, _vue.createVNode)("a", {
        "rel": "nofollow",
        "class": "".concat(pre, "-item-link")
      }, [(0, _vue.createVNode)("div", {
        "class": "".concat(pre, "-item-container")
      }, [(0, _vue.createVNode)(_DoubleLeftOutlined.default, {
        "class": "".concat(pre, "-item-link-icon")
      }, null), ellipsis])]);
      var jumpNextIcon = (0, _vue.createVNode)("a", {
        "rel": "nofollow",
        "class": "".concat(pre, "-item-link")
      }, [(0, _vue.createVNode)("div", {
        "class": "".concat(pre, "-item-container")
      }, [(0, _vue.createVNode)(_DoubleRightOutlined.default, {
        "class": "".concat(pre, "-item-link-icon")
      }, null), ellipsis])]);
      // change arrows direction in right-to-left direction
      if (direction.value === 'rtl') {
        var _ref2 = [nextIcon, prevIcon];
        prevIcon = _ref2[0];
        nextIcon = _ref2[1];
        var _ref3 = [jumpNextIcon, jumpPrevIcon];
        jumpPrevIcon = _ref3[0];
        jumpNextIcon = _ref3[1];
      }
      return {
        prevIcon: prevIcon,
        nextIcon: nextIcon,
        jumpPrevIcon: jumpPrevIcon,
        jumpNextIcon: jumpNextIcon
      };
    };
    return function () {
      var _a;
      var size = props.size,
        _props$itemRender = props.itemRender,
        itemRender = _props$itemRender === void 0 ? slots.itemRender : _props$itemRender,
        _props$buildOptionTex = props.buildOptionText,
        buildOptionText = _props$buildOptionTex === void 0 ? slots.buildOptionText : _props$buildOptionTex,
        selectComponentClass = props.selectComponentClass,
        responsive = props.responsive,
        restProps = __rest(props, ["size", "itemRender", "buildOptionText", "selectComponentClass", "responsive"]);
      var isSmall = size === 'small' || !!(((_a = breakpoint.value) === null || _a === void 0 ? void 0 : _a.xs) && !size && responsive);
      var paginationProps = (0, _extends2.default)((0, _extends2.default)((0, _extends2.default)((0, _extends2.default)((0, _extends2.default)({}, restProps), getIconsProps(prefixCls.value)), {
        prefixCls: prefixCls.value,
        selectPrefixCls: selectPrefixCls.value,
        selectComponentClass: selectComponentClass || (isSmall ? _Select.default : _Select.MiddleSelect),
        locale: locale.value,
        buildOptionText: buildOptionText
      }), attrs), {
        class: (0, _classNames2.default)((0, _defineProperty2.default)({
          mini: isSmall
        }, "".concat(prefixCls.value, "-rtl"), direction.value === 'rtl'), attrs.class, hashId.value),
        itemRender: itemRender
      });
      return wrapSSR((0, _vue.createVNode)(_vcPagination.default, paginationProps, null));
    };
  }
});
exports.default = _default;