"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _extends6 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _style = require("../../input/style");
var _internal = require("../../theme/internal");
var _style2 = require("../../style");
var genPaginationDisabledStyle = function genPaginationDisabledStyle(token) {
  var _$concat2, _ref;
  var componentCls = token.componentCls;
  return _ref = {}, (0, _defineProperty2.default)(_ref, "".concat(componentCls, "-disabled"), {
    '&, &:hover': (0, _defineProperty2.default)({
      cursor: 'not-allowed'
    }, "".concat(componentCls, "-item-link"), {
      color: token.colorTextDisabled,
      cursor: 'not-allowed'
    }),
    '&:focus-visible': (0, _defineProperty2.default)({
      cursor: 'not-allowed'
    }, "".concat(componentCls, "-item-link"), {
      color: token.colorTextDisabled,
      cursor: 'not-allowed'
    })
  }), (0, _defineProperty2.default)(_ref, "&".concat(componentCls, "-disabled"), (_$concat2 = {
    cursor: 'not-allowed'
  }, (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-item"), {
    cursor: 'not-allowed',
    '&:hover, &:active': {
      backgroundColor: 'transparent'
    },
    a: {
      color: token.colorTextDisabled,
      backgroundColor: 'transparent',
      border: 'none',
      cursor: 'not-allowed'
    },
    '&-active': {
      borderColor: token.colorBorder,
      backgroundColor: token.paginationItemDisabledBgActive,
      '&:hover, &:active': {
        backgroundColor: token.paginationItemDisabledBgActive
      },
      a: {
        color: token.paginationItemDisabledColorActive
      }
    }
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-item-link"), (0, _defineProperty2.default)({
    color: token.colorTextDisabled,
    cursor: 'not-allowed',
    '&:hover, &:active': {
      backgroundColor: 'transparent'
    }
  }, "".concat(componentCls, "-simple&"), {
    backgroundColor: 'transparent'
  })), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-item-link-icon"), {
    opacity: 0
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-item-ellipsis"), {
    opacity: 1
  }), (0, _defineProperty2.default)(_$concat2, "".concat(componentCls, "-simple-pager"), {
    color: token.colorTextDisabled
  }), _$concat2)), _ref;
};
var genPaginationMiniStyle = function genPaginationMiniStyle(token) {
  var _$concat$concat, _ref2;
  var componentCls = token.componentCls;
  return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-total-text, &").concat(componentCls, "-mini ").concat(componentCls, "-simple-pager"), {
    height: token.paginationItemSizeSM,
    lineHeight: "".concat(token.paginationItemSizeSM, "px")
  }), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-item"), {
    minWidth: token.paginationItemSizeSM,
    height: token.paginationItemSizeSM,
    margin: 0,
    lineHeight: "".concat(token.paginationItemSizeSM - 2, "px")
  }), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-item:not(").concat(componentCls, "-item-active)"), {
    backgroundColor: 'transparent',
    borderColor: 'transparent'
  }), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-prev, &").concat(componentCls, "-mini ").concat(componentCls, "-next"), {
    minWidth: token.paginationItemSizeSM,
    height: token.paginationItemSizeSM,
    margin: 0,
    lineHeight: "".concat(token.paginationItemSizeSM, "px")
  }), (0, _defineProperty2.default)(_ref2, "\n    &".concat(componentCls, "-mini ").concat(componentCls, "-prev ").concat(componentCls, "-item-link,\n    &").concat(componentCls, "-mini ").concat(componentCls, "-next ").concat(componentCls, "-item-link\n    "), {
    backgroundColor: 'transparent',
    borderColor: 'transparent',
    '&::after': {
      height: token.paginationItemSizeSM,
      lineHeight: "".concat(token.paginationItemSizeSM, "px")
    }
  }), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-jump-prev, &").concat(componentCls, "-mini ").concat(componentCls, "-jump-next"), {
    height: token.paginationItemSizeSM,
    marginInlineEnd: 0,
    lineHeight: "".concat(token.paginationItemSizeSM, "px")
  }), (0, _defineProperty2.default)(_ref2, "&".concat(componentCls, "-mini ").concat(componentCls, "-options"), (_$concat$concat = {
    marginInlineStart: token.paginationMiniOptionsMarginInlineStart
  }, (0, _defineProperty2.default)(_$concat$concat, "&-size-changer", {
    top: token.paginationMiniOptionsSizeChangerTop
  }), (0, _defineProperty2.default)(_$concat$concat, "&-quick-jumper", {
    height: token.paginationItemSizeSM,
    lineHeight: "".concat(token.paginationItemSizeSM, "px"),
    input: (0, _extends6.default)((0, _extends6.default)({}, (0, _style.genInputSmallStyle)(token)), {
      width: token.paginationMiniQuickJumperInputWidth,
      height: token.controlHeightSM
    })
  }), _$concat$concat)), _ref2;
};
var genPaginationSimpleStyle = function genPaginationSimpleStyle(token) {
  var _ref3;
  var componentCls = token.componentCls;
  return _ref3 = {}, (0, _defineProperty2.default)(_ref3, "\n    &".concat(componentCls, "-simple ").concat(componentCls, "-prev,\n    &").concat(componentCls, "-simple ").concat(componentCls, "-next\n    "), (0, _defineProperty2.default)({
    height: token.paginationItemSizeSM,
    lineHeight: "".concat(token.paginationItemSizeSM, "px"),
    verticalAlign: 'top'
  }, "".concat(componentCls, "-item-link"), {
    height: token.paginationItemSizeSM,
    backgroundColor: 'transparent',
    border: 0,
    '&::after': {
      height: token.paginationItemSizeSM,
      lineHeight: "".concat(token.paginationItemSizeSM, "px")
    }
  })), (0, _defineProperty2.default)(_ref3, "&".concat(componentCls, "-simple ").concat(componentCls, "-simple-pager"), {
    display: 'inline-block',
    height: token.paginationItemSizeSM,
    marginInlineEnd: token.marginXS,
    input: {
      boxSizing: 'border-box',
      height: '100%',
      marginInlineEnd: token.marginXS,
      padding: "0 ".concat(token.paginationItemPaddingInline, "px"),
      textAlign: 'center',
      backgroundColor: token.paginationItemInputBg,
      border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder),
      borderRadius: token.borderRadius,
      outline: 'none',
      transition: "border-color ".concat(token.motionDurationMid),
      color: 'inherit',
      '&:hover': {
        borderColor: token.colorPrimary
      },
      '&:focus': {
        borderColor: token.colorPrimaryHover,
        boxShadow: "".concat(token.inputOutlineOffset, "px 0 ").concat(token.controlOutlineWidth, "px ").concat(token.controlOutline)
      },
      '&[disabled]': {
        color: token.colorTextDisabled,
        backgroundColor: token.colorBgContainerDisabled,
        borderColor: token.colorBorder,
        cursor: 'not-allowed'
      }
    }
  }), _ref3;
};
var genPaginationJumpStyle = function genPaginationJumpStyle(token) {
  var _$concat3, _hover2, _extends2, _$concat$concat3, _$concat$concat4, _ref4;
  var componentCls = token.componentCls;
  return _ref4 = {}, (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-jump-prev, ").concat(componentCls, "-jump-next"), (_$concat$concat3 = {
    outline: 0
  }, (0, _defineProperty2.default)(_$concat$concat3, "".concat(componentCls, "-item-container"), (_$concat3 = {
    position: 'relative'
  }, (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item-link-icon"), {
    color: token.colorPrimary,
    fontSize: token.fontSizeSM,
    opacity: 0,
    transition: "all ".concat(token.motionDurationMid),
    '&-svg': {
      top: 0,
      insetInlineEnd: 0,
      bottom: 0,
      insetInlineStart: 0,
      margin: 'auto'
    }
  }), (0, _defineProperty2.default)(_$concat3, "".concat(componentCls, "-item-ellipsis"), {
    position: 'absolute',
    top: 0,
    insetInlineEnd: 0,
    bottom: 0,
    insetInlineStart: 0,
    display: 'block',
    margin: 'auto',
    color: token.colorTextDisabled,
    fontFamily: 'Arial, Helvetica, sans-serif',
    letterSpacing: token.paginationEllipsisLetterSpacing,
    textAlign: 'center',
    textIndent: token.paginationEllipsisTextIndent,
    opacity: 1,
    transition: "all ".concat(token.motionDurationMid)
  }), _$concat3)), (0, _defineProperty2.default)(_$concat$concat3, '&:hover', (_hover2 = {}, (0, _defineProperty2.default)(_hover2, "".concat(componentCls, "-item-link-icon"), {
    opacity: 1
  }), (0, _defineProperty2.default)(_hover2, "".concat(componentCls, "-item-ellipsis"), {
    opacity: 0
  }), _hover2)), (0, _defineProperty2.default)(_$concat$concat3, '&:focus-visible', (0, _extends6.default)((_extends2 = {}, (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item-link-icon"), {
    opacity: 1
  }), (0, _defineProperty2.default)(_extends2, "".concat(componentCls, "-item-ellipsis"), {
    opacity: 0
  }), _extends2), (0, _style2.genFocusOutline)(token))), _$concat$concat3)), (0, _defineProperty2.default)(_ref4, "\n    ".concat(componentCls, "-prev,\n    ").concat(componentCls, "-jump-prev,\n    ").concat(componentCls, "-jump-next\n    "), {
    marginInlineEnd: token.marginXS
  }), (0, _defineProperty2.default)(_ref4, "\n    ".concat(componentCls, "-prev,\n    ").concat(componentCls, "-next,\n    ").concat(componentCls, "-jump-prev,\n    ").concat(componentCls, "-jump-next\n    "), {
    display: 'inline-block',
    minWidth: token.paginationItemSize,
    height: token.paginationItemSize,
    color: token.colorText,
    fontFamily: token.paginationFontFamily,
    lineHeight: "".concat(token.paginationItemSize, "px"),
    textAlign: 'center',
    verticalAlign: 'middle',
    listStyle: 'none',
    borderRadius: token.borderRadius,
    cursor: 'pointer',
    transition: "all ".concat(token.motionDurationMid)
  }), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-prev, ").concat(componentCls, "-next"), (_$concat$concat4 = {
    fontFamily: 'Arial, Helvetica, sans-serif',
    outline: 0,
    button: {
      color: token.colorText,
      cursor: 'pointer',
      userSelect: 'none'
    }
  }, (0, _defineProperty2.default)(_$concat$concat4, "".concat(componentCls, "-item-link"), {
    display: 'block',
    width: '100%',
    height: '100%',
    padding: 0,
    fontSize: token.fontSizeSM,
    textAlign: 'center',
    backgroundColor: 'transparent',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    borderRadius: token.borderRadius,
    outline: 'none',
    transition: "border ".concat(token.motionDurationMid)
  }), (0, _defineProperty2.default)(_$concat$concat4, "&:focus-visible ".concat(componentCls, "-item-link"), (0, _extends6.default)({}, (0, _style2.genFocusOutline)(token))), (0, _defineProperty2.default)(_$concat$concat4, "&:hover ".concat(componentCls, "-item-link"), {
    backgroundColor: token.colorBgTextHover
  }), (0, _defineProperty2.default)(_$concat$concat4, "&:active ".concat(componentCls, "-item-link"), {
    backgroundColor: token.colorBgTextActive
  }), (0, _defineProperty2.default)(_$concat$concat4, "&".concat(componentCls, "-disabled:hover"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-link"), {
    backgroundColor: 'transparent'
  })), _$concat$concat4)), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-slash"), {
    marginInlineEnd: token.paginationSlashMarginInlineEnd,
    marginInlineStart: token.paginationSlashMarginInlineStart
  }), (0, _defineProperty2.default)(_ref4, "".concat(componentCls, "-options"), {
    display: 'inline-block',
    marginInlineStart: token.margin,
    verticalAlign: 'middle',
    '&-size-changer.-select': {
      display: 'inline-block',
      width: 'auto'
    },
    '&-quick-jumper': {
      display: 'inline-block',
      height: token.controlHeight,
      marginInlineStart: token.marginXS,
      lineHeight: "".concat(token.controlHeight, "px"),
      verticalAlign: 'top',
      input: (0, _extends6.default)((0, _extends6.default)({}, (0, _style.genBasicInputStyle)(token)), {
        width: token.controlHeightLG * 1.25,
        height: token.controlHeight,
        boxSizing: 'border-box',
        margin: 0,
        marginInlineStart: token.marginXS,
        marginInlineEnd: token.marginXS
      })
    }
  }), _ref4;
};
var genPaginationItemStyle = function genPaginationItemStyle(token) {
  var componentCls = token.componentCls;
  return (0, _defineProperty2.default)({}, "".concat(componentCls, "-item"), (0, _extends6.default)((0, _extends6.default)((0, _defineProperty2.default)({
    display: 'inline-block',
    minWidth: token.paginationItemSize,
    height: token.paginationItemSize,
    marginInlineEnd: token.marginXS,
    fontFamily: token.paginationFontFamily,
    lineHeight: "".concat(token.paginationItemSize - 2, "px"),
    textAlign: 'center',
    verticalAlign: 'middle',
    listStyle: 'none',
    backgroundColor: 'transparent',
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " transparent"),
    borderRadius: token.borderRadius,
    outline: 0,
    cursor: 'pointer',
    userSelect: 'none',
    a: {
      display: 'block',
      padding: "0 ".concat(token.paginationItemPaddingInline, "px"),
      color: token.colorText,
      transition: 'none',
      '&:hover': {
        textDecoration: 'none'
      }
    }
  }, "&:not(".concat(componentCls, "-item-active)"), {
    '&:hover': {
      transition: "all ".concat(token.motionDurationMid),
      backgroundColor: token.colorBgTextHover
    },
    '&:active': {
      backgroundColor: token.colorBgTextActive
    }
  }), (0, _style2.genFocusStyle)(token)), {
    '&-active': {
      fontWeight: token.paginationFontWeightActive,
      backgroundColor: token.paginationItemBgActive,
      borderColor: token.colorPrimary,
      a: {
        color: token.colorPrimary
      },
      '&:hover': {
        borderColor: token.colorPrimaryHover
      },
      '&:hover a': {
        color: token.colorPrimaryHover
      }
    }
  }));
};
var genPaginationStyle = function genPaginationStyle(token) {
  var _extends5, _ref6;
  var componentCls = token.componentCls;
  return _ref6 = {}, (0, _defineProperty2.default)(_ref6, componentCls, (0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)((0, _extends6.default)({}, (0, _style2.resetComponent)(token)), (0, _defineProperty2.default)({
    'ul, ol': {
      margin: 0,
      padding: 0,
      listStyle: 'none'
    },
    '&::after': {
      display: 'block',
      clear: 'both',
      height: 0,
      overflow: 'hidden',
      visibility: 'hidden',
      content: '""'
    }
  }, "".concat(componentCls, "-total-text"), {
    display: 'inline-block',
    height: token.paginationItemSize,
    marginInlineEnd: token.marginXS,
    lineHeight: "".concat(token.paginationItemSize - 2, "px"),
    verticalAlign: 'middle'
  })), genPaginationItemStyle(token)), genPaginationJumpStyle(token)), genPaginationSimpleStyle(token)), genPaginationMiniStyle(token)), genPaginationDisabledStyle(token)), (_extends5 = {}, (0, _defineProperty2.default)(_extends5, "@media only screen and (max-width: ".concat(token.screenLG, "px)"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item"), {
    '&-after-jump-prev, &-before-jump-next': {
      display: 'none'
    }
  })), (0, _defineProperty2.default)(_extends5, "@media only screen and (max-width: ".concat(token.screenSM, "px)"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-options"), {
    display: 'none'
  })), _extends5))), (0, _defineProperty2.default)(_ref6, "&".concat(token.componentCls, "-rtl"), {
    direction: 'rtl'
  }), _ref6;
};
var genBorderedStyle = function genBorderedStyle(token) {
  var _$concat$concat5, _$concat$concat7, _$concat$concat8, _$concat6, _componentCls, _ref7;
  var componentCls = token.componentCls;
  return _ref7 = {}, (0, _defineProperty2.default)(_ref7, "".concat(componentCls).concat(componentCls, "-disabled"), (_$concat$concat7 = {
    '&, &:hover': (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-link"), {
      borderColor: token.colorBorder
    }),
    '&:focus-visible': (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-link"), {
      borderColor: token.colorBorder
    })
  }, (0, _defineProperty2.default)(_$concat$concat7, "".concat(componentCls, "-item, ").concat(componentCls, "-item-link"), (_$concat$concat5 = {
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder
  }, (0, _defineProperty2.default)(_$concat$concat5, "&:hover:not(".concat(componentCls, "-item-active)"), {
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder,
    a: {
      color: token.colorTextDisabled
    }
  }), (0, _defineProperty2.default)(_$concat$concat5, "&".concat(componentCls, "-item-active"), {
    backgroundColor: token.paginationItemDisabledBgActive
  }), _$concat$concat5)), (0, _defineProperty2.default)(_$concat$concat7, "".concat(componentCls, "-prev, ").concat(componentCls, "-next"), (0, _defineProperty2.default)({
    '&:hover button': {
      backgroundColor: token.colorBgContainerDisabled,
      borderColor: token.colorBorder,
      color: token.colorTextDisabled
    }
  }, "".concat(componentCls, "-item-link"), {
    backgroundColor: token.colorBgContainerDisabled,
    borderColor: token.colorBorder
  })), _$concat$concat7)), (0, _defineProperty2.default)(_ref7, componentCls, (_componentCls = {}, (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-prev, ").concat(componentCls, "-next"), (_$concat$concat8 = {
    '&:hover button': {
      borderColor: token.colorPrimaryHover,
      backgroundColor: token.paginationItemBg
    }
  }, (0, _defineProperty2.default)(_$concat$concat8, "".concat(componentCls, "-item-link"), {
    backgroundColor: token.paginationItemLinkBg,
    borderColor: token.colorBorder
  }), (0, _defineProperty2.default)(_$concat$concat8, "&:hover ".concat(componentCls, "-item-link"), {
    borderColor: token.colorPrimary,
    backgroundColor: token.paginationItemBg,
    color: token.colorPrimary
  }), (0, _defineProperty2.default)(_$concat$concat8, "&".concat(componentCls, "-disabled"), (0, _defineProperty2.default)({}, "".concat(componentCls, "-item-link"), {
    borderColor: token.colorBorder,
    color: token.colorTextDisabled
  })), _$concat$concat8)), (0, _defineProperty2.default)(_componentCls, "".concat(componentCls, "-item"), (_$concat6 = {
    backgroundColor: token.paginationItemBg,
    border: "".concat(token.lineWidth, "px ").concat(token.lineType, " ").concat(token.colorBorder)
  }, (0, _defineProperty2.default)(_$concat6, "&:hover:not(".concat(componentCls, "-item-active)"), {
    borderColor: token.colorPrimary,
    backgroundColor: token.paginationItemBg,
    a: {
      color: token.colorPrimary
    }
  }), (0, _defineProperty2.default)(_$concat6, '&-active', {
    borderColor: token.colorPrimary
  }), _$concat6)), _componentCls)), _ref7;
};
// ============================== Export ==============================
var _default = (0, _internal.genComponentStyleHook)('Pagination', function (token) {
  var paginationToken = (0, _internal.mergeToken)(token, {
    paginationItemSize: token.controlHeight,
    paginationFontFamily: token.fontFamily,
    paginationItemBg: token.colorBgContainer,
    paginationItemBgActive: token.colorBgContainer,
    paginationFontWeightActive: token.fontWeightStrong,
    paginationItemSizeSM: token.controlHeightSM,
    paginationItemInputBg: token.colorBgContainer,
    paginationMiniOptionsSizeChangerTop: 0,
    paginationItemDisabledBgActive: token.controlItemBgActiveDisabled,
    paginationItemDisabledColorActive: token.colorTextDisabled,
    paginationItemLinkBg: token.colorBgContainer,
    inputOutlineOffset: '0 0',
    paginationMiniOptionsMarginInlineStart: token.marginXXS / 2,
    paginationMiniQuickJumperInputWidth: token.controlHeightLG * 1.1,
    paginationItemPaddingInline: token.marginXXS * 1.5,
    paginationEllipsisLetterSpacing: token.marginXXS / 2,
    paginationSlashMarginInlineStart: token.marginXXS,
    paginationSlashMarginInlineEnd: token.marginSM,
    paginationEllipsisTextIndent: '0.13em' // magic for ui experience
  }, (0, _style.initInputToken)(token));
  return [genPaginationStyle(paginationToken), token.wireframe && genBorderedStyle(paginationToken)];
});
exports.default = _default;