"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.circleProps = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _vcProgress = require("../vc-progress");
var _utils = require("./utils");
var _props = require("./props");
var _propsUtil = require("../_util/props-util");
var _tooltip = _interopRequireDefault(require("../tooltip"));
var _type = require("../_util/type");
var circleProps = function circleProps() {
  return (0, _extends2.default)((0, _extends2.default)({}, (0, _props.progressProps)()), {
    strokeColor: (0, _type.anyType)()
  });
};
exports.circleProps = circleProps;
var CIRCLE_MIN_STROKE_WIDTH = 3;
var getMinPercent = function getMinPercent(width) {
  return CIRCLE_MIN_STROKE_WIDTH / width * 100;
};
var _default2 = (0, _vue.defineComponent)({
  compatConfig: {
    MODE: 3
  },
  name: 'Circle',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)(circleProps(), {
    trailColor: null
  }),
  setup: function setup(props, _ref) {
    var slots = _ref.slots,
      attrs = _ref.attrs;
    var originWidth = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.width) !== null && _a !== void 0 ? _a : 120;
    });
    var mergedSize = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.size) !== null && _a !== void 0 ? _a : [originWidth.value, originWidth.value];
    });
    var sizeRef = (0, _vue.computed)(function () {
      return (0, _utils.getSize)(mergedSize.value, 'circle');
    });
    var gapDeg = (0, _vue.computed)(function () {
      // Support gapDeg = 0 when type = 'dashboard'
      if (props.gapDegree || props.gapDegree === 0) {
        return props.gapDegree;
      }
      if (props.type === 'dashboard') {
        return 75;
      }
      return undefined;
    });
    var circleStyle = (0, _vue.computed)(function () {
      return {
        width: "".concat(sizeRef.value.width, "px"),
        height: "".concat(sizeRef.value.height, "px"),
        fontSize: "".concat(sizeRef.value.width * 0.15 + 6, "px")
      };
    });
    var circleWidth = (0, _vue.computed)(function () {
      var _a;
      return (_a = props.strokeWidth) !== null && _a !== void 0 ? _a : Math.max(getMinPercent(sizeRef.value.width), 6);
    });
    var gapPos = (0, _vue.computed)(function () {
      return props.gapPosition || props.type === 'dashboard' && 'bottom' || undefined;
    });
    // using className to style stroke color
    var percent = (0, _vue.computed)(function () {
      return (0, _utils.getPercentage)(props);
    });
    var isGradient = (0, _vue.computed)(function () {
      return Object.prototype.toString.call(props.strokeColor) === '[object Object]';
    });
    var strokeColor = (0, _vue.computed)(function () {
      return (0, _utils.getStrokeColor)({
        success: props.success,
        strokeColor: props.strokeColor
      });
    });
    var wrapperClassName = (0, _vue.computed)(function () {
      var _ref2;
      return _ref2 = {}, (0, _defineProperty2.default)(_ref2, "".concat(props.prefixCls, "-inner"), true), (0, _defineProperty2.default)(_ref2, "".concat(props.prefixCls, "-circle-gradient"), isGradient.value), _ref2;
    });
    return function () {
      var _a;
      var circleContent = (0, _vue.createVNode)(_vcProgress.Circle, {
        "percent": percent.value,
        "strokeWidth": circleWidth.value,
        "trailWidth": circleWidth.value,
        "strokeColor": strokeColor.value,
        "strokeLinecap": props.strokeLinecap,
        "trailColor": props.trailColor,
        "prefixCls": props.prefixCls,
        "gapDegree": gapDeg.value,
        "gapPosition": gapPos.value
      }, null);
      return (0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": [wrapperClassName.value, attrs.class],
        "style": [attrs.style, circleStyle.value]
      }), [sizeRef.value.width <= 20 ? (0, _vue.createVNode)(_tooltip.default, null, {
        default: function _default() {
          return [(0, _vue.createVNode)("span", null, [circleContent])];
        },
        title: slots.default
      }) : (0, _vue.createVNode)(_vue.Fragment, null, [circleContent, (_a = slots.default) === null || _a === void 0 ? void 0 : _a.call(slots)])]);
    };
  }
});
exports.default = _default2;