"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _useConfigInject2 = _interopRequireDefault(require("../config-provider/hooks/useConfigInject"));
var _style = _interopRequireDefault(require("./style"));
var _LocaleReceiver = require("../locale/LocaleReceiver");
var _type = require("../_util/type");
var _spin = _interopRequireDefault(require("../spin"));
var _button = _interopRequireDefault(require("../button"));
var _iconsVue = require("@ant-design/icons-vue/lib/icons");
var _internal = require("../theme/internal");
var _QRCodeCanvas = require("./QRCodeCanvas");
var _warning = _interopRequireDefault(require("../_util/warning"));
var _interface = require("./interface");
var QRCode = (0, _vue.defineComponent)({
  name: 'AQrcode',
  inheritAttrs: false,
  props: (0, _interface.qrcodeProps)(),
  emits: ['refresh'],
  setup: function setup(props, _ref) {
    var emit = _ref.emit,
      attrs = _ref.attrs,
      expose = _ref.expose;
    if (process.env.NODE_ENV !== 'production') {
      (0, _warning.default)(!(props.icon && props.errorLevel === 'L'), 'QRCode', 'ErrorLevel `L` is not recommended to be used with `icon`, for scanning result would be affected by low level.');
    }
    var _useLocaleReceiver = (0, _LocaleReceiver.useLocaleReceiver)('QRCode'),
      _useLocaleReceiver2 = (0, _slicedToArray2.default)(_useLocaleReceiver, 1),
      locale = _useLocaleReceiver2[0];
    var _useConfigInject = (0, _useConfigInject2.default)('qrcode', props),
      prefixCls = _useConfigInject.prefixCls;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var _useToken = (0, _internal.useToken)(),
      _useToken2 = (0, _slicedToArray2.default)(_useToken, 2),
      token = _useToken2[1];
    var qrCodeCanvas = (0, _vue.ref)();
    expose({
      toDataURL: function toDataURL(type, quality) {
        var _a;
        return (_a = qrCodeCanvas.value) === null || _a === void 0 ? void 0 : _a.toDataURL(type, quality);
      }
    });
    var qrCodeProps = (0, _vue.computed)(function () {
      var value = props.value,
        _props$icon = props.icon,
        icon = _props$icon === void 0 ? '' : _props$icon,
        _props$size = props.size,
        size = _props$size === void 0 ? 160 : _props$size,
        _props$iconSize = props.iconSize,
        iconSize = _props$iconSize === void 0 ? 40 : _props$iconSize,
        _props$color = props.color,
        color = _props$color === void 0 ? '#000' : _props$color,
        _props$errorLevel = props.errorLevel,
        errorLevel = _props$errorLevel === void 0 ? 'M' : _props$errorLevel;
      var imageSettings = {
        src: icon,
        x: undefined,
        y: undefined,
        height: iconSize,
        width: iconSize,
        excavate: true
      };
      return {
        value: value,
        size: size - (token.value.paddingSM + token.value.lineWidth) * 2,
        level: errorLevel,
        bgColor: 'transparent',
        fgColor: color,
        imageSettings: icon ? imageSettings : undefined
      };
    });
    return function () {
      var pre = prefixCls.value;
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "style": [attrs.style, {
          width: props.size + 'px',
          height: props.size + 'px'
        }],
        "class": [hashId.value, pre, (0, _defineProperty2.default)({}, "".concat(prefixCls, "-borderless"), !props.bordered)]
      }), [props.status !== 'active' && (0, _vue.createVNode)("div", {
        "class": "".concat(pre, "-mask")
      }, [props.status === 'loading' && (0, _vue.createVNode)(_spin.default, null, null), props.status === 'expired' && (0, _vue.createVNode)(_vue.Fragment, null, [(0, _vue.createVNode)("p", {
        "class": "".concat(pre, "-expired")
      }, [locale.value.expired]), (0, _vue.createVNode)(_button.default, {
        "type": "link",
        "onClick": function onClick(e) {
          return emit('refresh', e);
        }
      }, {
        default: function _default() {
          return [locale.value.refresh];
        },
        icon: function icon() {
          return (0, _vue.createVNode)(_iconsVue.ReloadOutlined, null, null);
        }
      })])]), (0, _vue.createVNode)(_QRCodeCanvas.QRCodeCanvas, (0, _objectSpread2.default)({
        "ref": qrCodeCanvas
      }, qrCodeProps.value), null)]));
    };
  }
});
var _default2 = (0, _type.withInstall)(QRCode);
exports.default = _default2;