"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.segmentedProps = exports.default = void 0;
var _vue = require("vue");
var _objectSpread2 = _interopRequireDefault(require("@babel/runtime/helpers/objectSpread2"));
var _slicedToArray2 = _interopRequireDefault(require("@babel/runtime/helpers/slicedToArray"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _typeof2 = _interopRequireDefault(require("@babel/runtime/helpers/typeof"));
var _classNames4 = _interopRequireDefault(require("../../_util/classNames"));
var _useConfigInject2 = _interopRequireDefault(require("../../config-provider/hooks/useConfigInject"));
var _propsUtil = require("../../_util/props-util");
var _style = _interopRequireDefault(require("../style"));
var _type = require("../../_util/type");
var _MotionThumb = _interopRequireDefault(require("./MotionThumb"));
function normalizeOptions(options) {
  return options.map(function (option) {
    if ((0, _typeof2.default)(option) === 'object' && option !== null) {
      return option;
    }
    return {
      label: option === null || option === void 0 ? void 0 : option.toString(),
      title: option === null || option === void 0 ? void 0 : option.toString(),
      value: option
    };
  });
}
var segmentedProps = function segmentedProps() {
  return {
    prefixCls: String,
    options: (0, _type.arrayType)(),
    block: (0, _type.booleanType)(),
    disabled: (0, _type.booleanType)(),
    size: (0, _type.stringType)(),
    value: (0, _extends2.default)((0, _extends2.default)({}, (0, _type.someType)([String, Number])), {
      required: true
    }),
    motionName: String,
    onChange: (0, _type.functionType)(),
    'onUpdate:value': (0, _type.functionType)()
  };
};
exports.segmentedProps = segmentedProps;
var SegmentedOption = function SegmentedOption(props, _ref) {
  var slots = _ref.slots,
    emit = _ref.emit;
  var value = props.value,
    disabled = props.disabled,
    payload = props.payload,
    title = props.title,
    prefixCls = props.prefixCls,
    _props$label = props.label,
    label = _props$label === void 0 ? slots.label : _props$label,
    checked = props.checked,
    className = props.className;
  var handleChange = function handleChange(event) {
    if (disabled) {
      return;
    }
    emit('change', event, value);
  };
  return (0, _vue.createVNode)("label", {
    "class": (0, _classNames4.default)((0, _defineProperty2.default)({}, "".concat(prefixCls, "-item-disabled"), disabled), className)
  }, [(0, _vue.createVNode)("input", {
    "class": "".concat(prefixCls, "-item-input"),
    "type": "radio",
    "disabled": disabled,
    "checked": checked,
    "onChange": handleChange
  }, null), (0, _vue.createVNode)("div", {
    "class": "".concat(prefixCls, "-item-label"),
    "title": typeof title === 'string' ? title : ''
  }, [typeof label === 'function' ? label({
    value: value,
    disabled: disabled,
    payload: payload,
    title: title
  }) : label])]);
};
SegmentedOption.inheritAttrs = false;
var _default = (0, _vue.defineComponent)({
  name: 'ASegmented',
  inheritAttrs: false,
  props: (0, _propsUtil.initDefaultProps)(segmentedProps(), {
    options: [],
    motionName: 'thumb-motion'
  }),
  slots: ['label'],
  setup: function setup(props, _ref2) {
    var emit = _ref2.emit,
      slots = _ref2.slots,
      attrs = _ref2.attrs;
    var _useConfigInject = (0, _useConfigInject2.default)('segmented', props),
      prefixCls = _useConfigInject.prefixCls,
      direction = _useConfigInject.direction,
      size = _useConfigInject.size;
    var _useStyle = (0, _style.default)(prefixCls),
      _useStyle2 = (0, _slicedToArray2.default)(_useStyle, 2),
      wrapSSR = _useStyle2[0],
      hashId = _useStyle2[1];
    var rootRef = (0, _vue.shallowRef)();
    var thumbShow = (0, _vue.shallowRef)(false);
    var segmentedOptions = (0, _vue.computed)(function () {
      return normalizeOptions(props.options);
    });
    var handleChange = function handleChange(_event, val) {
      if (props.disabled) {
        return;
      }
      emit('update:value', val);
      emit('change', val);
    };
    return function () {
      var _classNames2;
      var pre = prefixCls.value;
      return wrapSSR((0, _vue.createVNode)("div", (0, _objectSpread2.default)((0, _objectSpread2.default)({}, attrs), {}, {
        "class": (0, _classNames4.default)(pre, (_classNames2 = {}, (0, _defineProperty2.default)(_classNames2, hashId.value, true), (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-block"), props.block), (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-disabled"), props.disabled), (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-lg"), size.value == 'large'), (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-sm"), size.value == 'small'), (0, _defineProperty2.default)(_classNames2, "".concat(pre, "-rtl"), direction.value === 'rtl'), _classNames2), attrs.class),
        "ref": rootRef
      }), [(0, _vue.createVNode)("div", {
        "class": "".concat(pre, "-group")
      }, [(0, _vue.createVNode)(_MotionThumb.default, {
        "containerRef": rootRef,
        "prefixCls": pre,
        "value": props.value,
        "motionName": "".concat(pre, "-").concat(props.motionName),
        "direction": direction.value,
        "getValueIndex": function getValueIndex(val) {
          return segmentedOptions.value.findIndex(function (n) {
            return n.value === val;
          });
        },
        "onMotionStart": function onMotionStart() {
          thumbShow.value = true;
        },
        "onMotionEnd": function onMotionEnd() {
          thumbShow.value = false;
        }
      }, null), segmentedOptions.value.map(function (segmentedOption) {
        return (0, _vue.createVNode)(SegmentedOption, (0, _objectSpread2.default)((0, _objectSpread2.default)({
          "key": segmentedOption.value,
          "prefixCls": pre,
          "checked": segmentedOption.value === props.value,
          "onChange": handleChange
        }, segmentedOption), {}, {
          "className": (0, _classNames4.default)(segmentedOption.className, "".concat(pre, "-item"), (0, _defineProperty2.default)({}, "".concat(pre, "-item-selected"), segmentedOption.value === props.value && !thumbShow.value)),
          "disabled": !!props.disabled || !!segmentedOption.disabled
        }), slots);
      })])]));
    };
  }
});
exports.default = _default;